<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_Industrialtran extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_Industrialtran_model');
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_Industrialtran_view');
        $this->load->view('admin/footer_view');
    }

    public function import_excel_save() {
        try {
            
               // ✅ Check if file is uploaded and save it
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];
 
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
 
            // Create filename: Value_Addition_Program_YYYYMMDD_HHMMSS.xlsx
            $extension = pathinfo($originalName, PATHINFO_EXTENSION);
            $filename = 'Industrail_trainer_' . date('Ymd_His') . '.' . $extension;
            $targetFile = $uploadDir . $filename;
 
            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }
 
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];

            // Get active institute
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $Institute = $institute ? $institute->Institu_id : null;

            // ✅ Load existing maps
            $companyMap  = [];
            $branchMap   = [];
            $durationMap = [];
            $yearMap     = [];

            foreach ($this->db->get_where('company_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $companyMap[strtolower(trim((string)$d->comp_name))] = $d->ID;
            }

            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $branchMap[strtolower(trim((string)$g->branch_name))] = $g->branch_id;
            }

            foreach ($this->db->get_where('internduration_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $durationMap[strtolower(trim((string)$g->duration_days))] = $g->duration_id;
            }

            foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
                $yearMap[strtolower(trim((string)$g->fini_Label))] = $g->finiYear_id;
            }

            $rowCount = 0;
            foreach ($rows as $row) {
                $rowCount++;

                // ✅ Skip header row
                if ($rowCount === 1) {
                    continue;
                }

                // ---- Company mapping ----
                $companyStr = strtolower(trim((string)($row['fkcomp_ID'] ?? '')));
                if ($companyStr !== '') {
                    if (!isset($companyMap[$companyStr])) {
                        $this->db->insert('company_master', [
                            'comp_name' => ucfirst($companyStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $ID = $this->db->insert_id();
                        $companyMap[$companyStr] = $ID;
                    } else {
                        $ID = $companyMap[$companyStr];
                    }
                } else {
                    $ID = null;
                }

                // ---- Branch mapping ----
                $branchStr = strtolower(trim((string)($row['fkbranch_id'] ?? '')));
                if ($branchStr !== '') {
                    if (!isset($branchMap[$branchStr])) {
                        $this->db->insert('branch_master', [
                            'branch_name' => ucfirst($branchStr),
                            'is_on'       => 1,
                            'is_active'   => 1
                        ]);
                        $branch_id = $this->db->insert_id();
                        $branchMap[$branchStr] = $branch_id;
                    } else {
                        $branch_id = $branchMap[$branchStr];
                    }
                } else {
                    $branch_id = null;
                }

                // ---- Duration mapping ----
                $durationStr = strtolower(trim((string)($row['fkduration_id'] ?? '')));
                if ($durationStr !== '') {
                    if (!isset($durationMap[$durationStr])) {
                        $this->db->insert('internduration_master', [
                            'duration_days' => ucfirst($durationStr),
                            'is_on'         => 1,
                            'is_active'     => 1
                        ]);
                        $duration_id = $this->db->insert_id();
                        $durationMap[$durationStr] = $duration_id;
                    } else {
                        $duration_id = $durationMap[$durationStr];
                    }
                } else {
                    $duration_id = null;
                }

                // ---- Year mapping ----
                $yearStr = strtolower(trim((string)($row['finicial_Year'] ?? '')));
                if ($yearStr !== '') {
                    if (!isset($yearMap[$yearStr])) {
                        $this->db->insert('finiyear_master', [
                            'fini_Label' => ucfirst($yearStr),
                            'is_active'  => 1
                        ]);
                        $finiYear_id = $this->db->insert_id();
                        $yearMap[$yearStr] = $finiYear_id;
                    } else {
                        $finiYear_id = $yearMap[$yearStr];
                    }
                } else {
                    $finiYear_id = null;
                }

                // ---- Prepare row for insert ----
                $insertData[] = [
                    'fkcomp_ID'       => $ID,
                    'fkbranch_id'     => $branch_id,
                    'fkduration_id'   => $duration_id,
                    'StartDate'       => !empty($row['StartDate']) ? date('Y-m-d', strtotime($row['StartDate'])) : null,
                    'EndDate'         => !empty($row['EndDate']) ? date('Y-m-d', strtotime($row['EndDate'])) : null,
                    'Trainee_Details' => $row['Trainee_Details'] ?? '',
                    'Feedback'        => $row['Feedback'] ?? '',
                    'finicial_Year'   => $finiYear_id,
                    'Institute'       => $Institute,
                    'is_on'           => 1,
                    'is_active'       => 1
                ];
            }

            if (!empty($insertData)) {
                $this->Import_Industrialtran_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }

        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}
