<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_Patent extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_Patent_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
    }

    public function create()
    {

        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_Patent_view',$data);
        $this->load->view('admin/footer_view');
    }

    public function import_excel_save() {
        try {
            $fk_submenuId = $this->input->post('fk_submenuId');

             // ✅ Check if file is uploaded and save it
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];
 
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
 
            // Create filename: Value_Addition_Program_YYYYMMDD_HHMMSS.xlsx
            $extension = pathinfo($originalName, PATHINFO_EXTENSION);
            $filename = 'Patent_Details_' . date('Ymd_His') . '.' . $extension;
            $targetFile = $uploadDir . $filename;
 
            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }
 
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];
            
            $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
            $finicial_Year = $finiYear ? $finiYear->finiYear_id : null;
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $Institute = $institute ? $institute->Institu_id : null;

            $branchMap = [];
            $patenttypeMap = [];
            $mainuserMap = []; // This map is now actively used.
            $yearMap = [];
            $facultyMap = [];
            $studentMap = [];
            
            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $branchMap[strtolower(trim($g->branch_name))] = $g->branch_id;
            }
            foreach ($this->db->get_where('patenttpye_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $patenttypeMap[strtolower(trim($d->patenttpye_name))] = $d->patenttpye_id;
            }
            // Populate the mainuserMap with all existing main users
          foreach ($this->db->get_where('mainuser_master', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $mainuserMap[strtolower(trim($d->mainuser_name))] = $d->mainuser_id;
            }
            foreach ($this->db->get('finiyear_master')->result() as $g) {
                $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
            }
            foreach ($this->db->get('faculty_master')->result() as $f) {
                $facultyMap[strtolower(trim($f->fac_Fullname))] = $f->fac_id;
            }
            foreach ($this->db->get('student_reg')->result() as $s) {
                $studentMap[strtolower(trim($s->FullName))] = $s->Student_id;
            }

            $rowCount = 0;
            foreach ($rows as $row) {
                $rowCount++;
                
                if ($rowCount === 1) {
                    continue;
                }

                $branchStr = strtolower(trim($row['fkbranch_id'] ?? ''));
                if ($branchStr !== '' && !isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', ['branch_name' => ucfirst($branchStr), 'is_on' => 1, 'is_active' => 1]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr] ?? null;
                }

                $patenttypeStr = strtolower(trim($row['fkpatenttpye_id'] ?? ''));
                if ($patenttypeStr !== '' && !isset($patenttypeMap[$patenttypeStr])) {
                    $this->db->insert('patenttpye_master', ['patenttpye_name' => ucfirst($patenttypeStr), 'is_on' => 1, 'is_active' => 1]);
                    $patenttpye_id = $this->db->insert_id();
                    $patenttypeMap[$patenttypeStr] = $patenttpye_id;
                } else {
                    $patenttpye_id = $patenttypeMap[$patenttypeStr] ?? null;
                }
                
                $applicant_id = null;
                $applicant_type = strtolower(trim($row['applicant_type'] ?? ''));
                $applicant_name = strtolower(trim($row['applicant_name'] ?? ''));

                if (!empty($applicant_type) && !empty($applicant_name)) {
                    if ($applicant_type === 'faculty') {
                        if (!isset($facultyMap[$applicant_name])) {
                            $this->db->insert('faculty_master', ['fac_Fullname' => ucwords($applicant_name)]);
                            $applicant_id = $this->db->insert_id();
                            $facultyMap[$applicant_name] = $applicant_id;
                        } else {
                            $applicant_id = $facultyMap[$applicant_name];
                        }
                    } elseif ($applicant_type === 'student') {
                        if (!isset($studentMap[$applicant_name])) {
                            $this->db->insert('student_reg', ['FullName' => ucwords($applicant_name)]);
                            $applicant_id = $this->db->insert_id();
                            $studentMap[$applicant_name] = $applicant_id;
                        } else {
                            $applicant_id = $studentMap[$applicant_name];
                        }
                    }
                }
                
                $mainusreStr = strtolower(trim($row['applicant_type'] ?? ''));
if ($mainusreStr !== '') {
    if (!isset($mainuserMap[$mainusreStr])) {
        // Agar 'student' ya 'faculty' mainuser_master mein nahi hai, toh insert kare
        $this->db->insert('mainuser_master', [
            'mainuser_name' => ucfirst($mainusreStr),
            'is_on' => 1,
            'is_active' => 1
        ]);
        $mainuser_id = $this->db->insert_id();
        $mainuserMap[$mainusreStr] = $mainuser_id;
    } else {
        $mainuser_id = $mainuserMap[$mainusreStr];
    }
} else {
    $mainuser_id = null;
}
 
                
                $yearStr = strtolower(trim($row['finicial_Year'] ?? ''));
                if ($yearStr !== '' && !isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', ['fini_Label' => ucfirst($yearStr), 'is_active' => 1]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr] ?? null;
                }

                $insertData[] = [
                    'fkbranch_id'      => $branch_id,
                    'applicant_name'  => $row['applicant_name'] ?? '',
                    'patent_name'      => $row['patent_name'] ?? '',
                    'fkpatenttpye_id' => $patenttpye_id,
                    'Published'        => $row['Published'] ?? '',
                    'Granted'          => $row['Granted'] ?? '',
                    'ApplicNo'         => $row['ApplicNo'] ?? '',
                    'PublicDate'      => !empty($row['PublicDate']) ? date('Y-m-d', strtotime($row['PublicDate'])) : null,
                    'GrantDate'        => !empty($row['GrantDate']) ? date('Y-m-d', strtotime($row['GrantDate'])) : null,
                    'fkmainuser_id'    => $mainuser_id,
                    'finicial_Year'    => $finicial_Year,
                    'Institute'        => $Institute,
                    'applicant_type'  => $applicant_type,
                    'applicant_id'    => $applicant_id,
                    'created_date'    => date('Y-m-d H:i:s'),
                    'is_on'            => 1,
                    'is_active'        => 1,
                    'created_by'=>$_SESSION['userID']
                ];
            }

            if (!empty($insertData)) {
                $this->Import_Patent_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }

            // Insert log - Action 4 (Excel)
 
        $action = 4;
        $record_id = null;
        $excel_name = $originalName;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}