<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_citation extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_citation_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
    }

    // Load Import View
    public function create()
    {
        $current_url = $this->uri->uri_string();        
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_citation_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function import_excel_save() {
        // Enable error logging
        log_message('debug', 'Import citation save started');
        
        try {
            $fk_submenuId = $this->input->post('fk_submenuId');
            
            // ✅ Check if file is uploaded and save it
            $filename = '';
            if (!empty($_FILES['excel_file']['name'])) {
                $originalName = $_FILES['excel_file']['name'];
                $tempPath = $_FILES['excel_file']['tmp_name'];
     
                $uploadDir = FCPATH . 'uploads/excel/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }
     
                $extension = pathinfo($originalName, PATHINFO_EXTENSION);
                $filename = 'citation_' . date('Ymd_His') . '.' . $extension;
                $targetFile = $uploadDir . $filename;
     
                if (!move_uploaded_file($tempPath, $targetFile)) {
                    log_message('error', 'File upload failed');
                    echo "file_error";
                    return;
                }
            } else {
                log_message('error', 'No file uploaded');
                echo "no_file";
                return;
            }
                
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                log_message('error', 'No table data received');
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            if (!$rows || !is_array($rows)) {
                log_message('error', 'Invalid JSON data');
                echo "invalid_data";
                return;
            }

            $insertData = [];

            // Get Institute ID
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $Institute = $institute ? $institute->Institu_id : null;

            // ✅ Load existing year map
            $yearMap = [];
            $yearQuery = $this->db->get_where('finiyear_master', ['is_active' => 1]);
            foreach ($yearQuery->result() as $g) {
                $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
            }

            $rowCount = 0;
            foreach ($rows as $row) {
                $rowCount++;
     
                // ✅ Skip header row (ID = 0 or first row)
                if ($rowCount === 1 || (isset($row['cit_id']) && $row['cit_id'] == '0')) {
                    continue;
                }

                // ---- Year mapping ----
                $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
                $finiYear_id = null;
                
                if ($yearStr !== '' && $yearStr !== 'financial year') {
                    if (!isset($yearMap[$yearStr])) {
                        $this->db->insert('finiyear_master', [
                            'fini_Label' => ucfirst($yearStr),
                            'is_active' => 1
                        ]);
                        $finiYear_id = $this->db->insert_id();
                        $yearMap[$yearStr] = $finiYear_id;
                    } else {
                        $finiYear_id = $yearMap[$yearStr];
                    }
                }

                // ---- Prepare row for insert ----
                $insertData[] = [
                    'faculty_name'         => trim($row['faculty_name'] ?? ''),
                    'fac_id'               => trim($row['fac_id'] ?? ''),
                    'GS_Citations'         => trim($row['GS_Citations'] ?? ''),
                    'GS_h_index'           => trim($row['GS_h_index'] ?? ''),
                    'GS_i10_index'         => trim($row['GS_i10_index'] ?? ''),
                    'scopus_citation'      => trim($row['scopus_citation'] ?? ''),
                    'scopus_hindex'        => trim($row['scopus_hindex'] ?? ''),
                    'web_scienceCitation'  => trim($row['web_scienceCitation'] ?? ''),
                    'web_science_hindex'   => trim($row['web_science_hindex'] ?? ''),
                    'Financial_Year'       => $finiYear_id,
                    'Institute'            => $Institute,
                    'created_date'         => date('Y-m-d H:i:s'),
                    'is_on'                => 1,
                    'is_active'            => 1,
                    'created_by'           => isset($_SESSION['userID']) ? $_SESSION['userID'] : null
                ];
            }

            if (!empty($insertData)) {
                $result = $this->Import_citation_model->insert_batch($insertData);
                
                if ($result) {
                    // Insert log - Action 4 (Excel)
                    if (function_exists('insert_log')) {
                        $action = 4;
                        $record_id = null;
                        $excel_name = $filename;
                        $Fk_branch = null;
                        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch, isset($_SESSION['userID']) ? $_SESSION['userID'] : null);
                    }
                    
                    log_message('debug', 'Data inserted successfully');
                    echo "success";
                } else {
                    log_message('error', 'Database insert failed');
                    echo "db_error";
                }
            } else {
                log_message('error', 'No valid data to insert');
                echo "no_data";
            }

        } catch (Exception $e) {
            log_message('error', 'Exception in import: ' . $e->getMessage());
            echo "error:" . $e->getMessage();
        }
    }
}