<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_industryvisi_excel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_industryvisi_excel_model');
         $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_industryvisi_excel_view',$data);
        $this->load->view('admin/footer_view');
    }

    

public function import_excel_save() {
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            // Upload path
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'industry_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }

        // ✅ Process table data
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];

        $institute = $this->db->select('Institu_id')
            ->from('institute_master')
            ->get()
            ->row();
        $Institute = $institute ? $institute->Institu_id : null;

        // ✅ Load maps for existing master data
        $companyMap = [];
        $yearMap = [];
        $facultyMap = [];
        $branchMap = [];
        $divisionMap = [];
        $semesterMap = [];

        foreach ($this->db->get_where('classmaster', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
            $companyMap[strtolower(trim($g->classname))] = $g->class_id;
        }
        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
        foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
            $branchMap[strtolower(trim($r->branch_name))] = $r->branch_id;
        }
        foreach ($this->db->get_where('faculty_master', ['is_on' => 1, 'is_active' => 1])->result() as $p) {
            $facultyMap[strtolower(trim($p->fac_Fullname))] = $p->fac_id;
        }

        foreach ($this->db->get_where('division_master', ['is_on' => 1, 'is_active' => 1])->result() as $q) {
            $divisionMap[strtolower(trim($q->div_name))] = $q->div_id;
        }

        foreach ($this->db->get_where('semester_master', ['is_on' => 1, 'is_active' => 1])->result() as $m) {
            $semesterMap[strtolower(trim($m->Sem_Name))] = $m->SemID;
        }

        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;

            // ✅ Skip header row
            if ($rowCount === 1) continue;

            // ✅ Skip blank row
            if (
                empty(trim($row['fkbranch_id'])) &&
                empty(trim($row['fk_company'])) &&
                empty(trim($row['fac_1'])) &&
                empty(trim($row['fac_2'])) &&
                empty(trim($row['fac_3'])) &&
                empty(trim($row['fac_4']))
            ) {
                continue;
            }

            // ✅ Branch Master
            $branchStr = strtolower(trim($row['fkbranch_id'] ?? ''));
            if ($branchStr !== '') {
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }
            } else {
                $branch_id = null;
            }

            // ✅ division Master
            $divStr = strtolower(trim($row['fk_div'] ?? ''));
            if ($divStr !== '') {
                if (!isset($divisionMap[$divStr])) {
                    $this->db->insert('division_master', [
                        'div_name' => ucfirst($divStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $div_id = $this->db->insert_id();
                    $divisionMap[$divStr] = $div_id;
                } else {
                    $div_id = $divisionMap[$divStr];
                }
            } else {
                $div_id = null;
            }


            // ✅ semester Master
            $semStr = strtolower(trim($row['fk_sem'] ?? ''));
            if ($semStr !== '') {
                if (!isset($semesterMap[$semStr])) {
                    $this->db->insert('semester_master', [
                        'Sem_Name' => ucfirst($semStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $SemID = $this->db->insert_id();
                    $semesterMap[$semStr] = $SemID;
                } else {
                    $SemID = $semesterMap[$semStr];
                }
            } else {
                $SemID = null;
            }


            // ✅ Company Master
            $companyStr = strtolower(trim($row['fkclass_id'] ?? ''));
            if ($companyStr !== '') {
                if (!isset($companyMap[$companyStr])) {
                    $this->db->insert('classmaster', [
                        'classname' => ucfirst($companyStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $class_id = $this->db->insert_id();
                    $companyMap[$companyStr] = $class_id;
                } else {
                    $class_id = $companyMap[$companyStr];
                }
            } else {
                $class_id = null;
            }

            // ✅ Year Master
            $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

            // ✅ Faculty Master (fac_1 to fac_4)
            $getFacultyId = function ($name) use (&$facultyMap) {
                $facStr = strtolower(trim($name ?? ''));
                if ($facStr === '') return null;
                if (!isset($facultyMap[$facStr])) {
                    $this->db->insert('faculty_master', [
                        'fac_Fullname' => ucfirst($facStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $fac_id = $this->db->insert_id();
                    $facultyMap[$facStr] = $fac_id;
                } else {
                    $fac_id = $facultyMap[$facStr];
                }
                return $fac_id;
            };

            $fac1_id = $getFacultyId($row['fac_1'] ?? '');
            $fac2_id = $getFacultyId($row['fac_2'] ?? '');
            $fac3_id = $getFacultyId($row['fac_3'] ?? '');
            $fac4_id = $getFacultyId($row['fac_4'] ?? '');

            // ✅ Date conversions
            $startdate = !empty($row['startdate'])
                ? (is_numeric($row['startdate'])
                    ? gmdate("Y-m-d", ($row['startdate'] - 25569) * 86400)
                    : date('Y-m-d', strtotime(str_replace('/', '-', $row['startdate']))))
                : null;

            $enddate = !empty($row['enddate'])
                ? (is_numeric($row['enddate'])
                    ? gmdate("Y-m-d", ($row['enddate'] - 25569) * 86400)
                    : date('Y-m-d', strtotime(str_replace('/', '-', $row['enddate']))))
                : null;

            // ✅ Insert row
            $insertData[] = [
                'fkbranch_id'   => $branch_id,
                'fkclass_id'    => $class_id,
                'fk_div'   => $div_id,
                'fk_sem'  => $SemID,
                'fk_company' => $row['fk_company'] ?? '',
                'Address' => $row['Address'] ?? '',
                // 'fk_company'  => $fk_company,
                // 'Address'   => $Address,
                'fac_1'         => $fac1_id,
                'fac_2'         => $fac2_id,
                'fac_3'         => $fac3_id,
                'fac_4'         => $fac4_id,
                'startdate'     => $startdate,
                'enddate'       => $enddate,
                'Financial_Year'=> $finiYear_id,
                'Institute'     => $Institute,
                'created_date' => date('Y-m-d'),
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('industry_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
        
        // Insert log - Action 4 (Excel)

        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}


}
