<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_jobstud extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_jobstud_model');
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_jobstud_view');
        $this->load->view('admin/footer_view');
    }

 



   public function import_excel_save() {
        try {
            
             // ✅ Check if file is uploaded and save it
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];
 
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
 
            // Create filename: Value_Addition_Program_YYYYMMDD_HHMMSS.xlsx
            $extension = pathinfo($originalName, PATHINFO_EXTENSION);
            $filename = 'EarnlearnExcel_' . date('Ymd_His') . '.' . $extension;
            $targetFile = $uploadDir . $filename;
 
            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }
 
            $postData = $this->input->post('tableData');
            if (empty($postData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($postData, true);
            $insertData = [];
            //  $finiYear = $this->db ->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
            //  $finicial_Year = $finiYear ? $finiYear->finiYear_id : null;

             $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
             $Institute = $institute ? $institute->Institu_id : null;

    
            // ✅ Load existing branch & class maps
            $branchMap = [];
            $classMap  = [];
            $yearMap = [];

            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $branchMap[strtolower(trim($g->branch_name))] = $g->branch_id;
            }
            foreach ($this->db->get_where('classmaster', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $classMap[strtolower(trim($d->classname))] = $d->class_id;
            }

            foreach ($this->db->get_where('finiyear_master', ['is_active' => 1, 'is_active' => 1])->result() as $g) {
                $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
            }


           $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;
 
            // ✅ Header skip
            if ($rowCount === 1) {
                continue;
            }
                // ---- Branch mapping ----
                $branchStr = strtolower(trim($row['fkbranch_id'] ?? ''));
                if ($branchStr !== '') {
                    if (!isset($branchMap[$branchStr])) {
                        $this->db->insert('branch_master', [
                            'branch_name' => ucfirst($branchStr),
                            'is_on'       => 1,
                            'is_active'   => 1
                        ]);
                        $branch_id = $this->db->insert_id();
                        $branchMap[$branchStr] = $branch_id;
                    } else {
                        $branch_id = $branchMap[$branchStr];
                    }
                } else {
                    $branch_id = null;
                }

                // ---- Class mapping ----
                $classStr = strtolower(trim($row['fkclass_id'] ?? ''));
                if ($classStr !== '') {
                    if (!isset($classMap[$classStr])) {
                        $this->db->insert('classmaster', [
                            'classname' => ucfirst($classStr),
                            'is_on'     => 1,
                            'is_active' => 1
                        ]);
                        $class_id = $this->db->insert_id();
                        $classMap[$classStr] = $class_id;
                    } else {
                        $class_id = $classMap[$classStr];
                    }
                } else {
                    $class_id = null;
                }


                 
                // ---- Year mapping ----
                $yearStr = strtolower(trim($row['finicial_Year'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1,
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

                // ---- Prepare row for insert ----
                $insertData[] = [
                    'jobstud_name' => $row['jobstud_name'] ?? '',
                    'fkbranch_id'  => $branch_id,
                    'fkclass_id'   => $class_id,
                    'division'     => $row['division'] ?? '',
                    'studcontact'  => $row['studcontact'] ?? '',
                    'naturework'   => $row['naturework'] ?? '',
                    'Duration'     => $row['Duration'] ?? '',
                    'workingDays'  => $row['workingDays'] ?? '',
                    'paydetails'   => $row['paydetails'] ?? '',
                    'Remarks'      => $row['Remarks'] ?? '',
                    'PRN'          => $row['PRN'] ?? '',
                    'StartDate'    => !empty($row['StartDate']) ? date('Y-m-d', strtotime($row['StartDate'])) : null,
                    'EndDate'      => !empty($row['EndDate']) ? date('Y-m-d', strtotime($row['EndDate'])) : null,
                    'finicial_Year'  => $finiYear_id,
                    'Institute'  => $Institute,
                    'created_date' => date('Y-m-d H:i:s'),
                    'is_on'        => 1,
                    'is_active'    => 1
                ];
            }

            if (!empty($insertData)) {
                // ✅ use model method
                $this->Import_jobstud_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }

        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}
