<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_place extends CI_Controller {

    // public function __construct()
    // {
    //     parent::__construct();
    //     $this->load->model('Import_place_model');
    // }

    // Load Import_place View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_place_view');
        $this->load->view('admin/footer_view');
    }

public function Import_place_excel()
{
    try {
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            $uploadPath = 'uploads/excel/';
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            $filename = date('YmdHis') . '_' . $originalName;
            $targetFilePath = $uploadPath . $filename;

            if (!move_uploaded_file($tempPath, $targetFilePath)) {
                echo "file_upload_error";
                return;
            }

              // Load Excel
            $spreadsheet = IOFactory::load($targetFilePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

            if (empty($sheetData) || count($sheetData) < 2) {
                echo "no_data";
                return;
            }

            // Extract headers from first row
            $headers = $sheetData[1]; // Row 1 = headers
            $headerMap = [];
            foreach ($headers as $col => $headerName) {
                $headerMap[strtolower(trim($headerName))] = $col; // map header name → column letter
            }

            log_message('debug', 'Excel Header Map: ' . print_r($headerMap, true));
function getCellValue($headerMap, $row, $headerName) {
    return isset($headerMap[$headerName], $row[$headerMap[$headerName]]) 
        ? trim($row[$headerMap[$headerName]]) 
        : null;
}

            $spreadsheet = IOFactory::load($targetFilePath);
            $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

            // Master maps
            $branchMap = [];
            $studentMap = [];
            $divisionMap = [];
            $companyMap = [];
            $designationMap = [];
            $placementMap = [];
            


            // Load master data
            foreach ($this->db->get_where('branch_master', ['is_on' => 1, 'is_active' => 1])->result() as $g) {
                $branchMap[strtolower(trim($b->branch_name))] = $b->branch_id;
            }

            foreach ($this->db->get_where('student_reg', ['is_on' => 1, 'is_active' => 1])->result() as $d) {
                $studentMap[strtolower(trim($s->FullName))] = $s->Student_id;
            }

            foreach ($this->db->get_where('division_master', ['is_on' => 1, 'is_active' => 1])->result() as $t) {
                $divisionMap[strtolower(trim($d->div_name))] = $d->div_id;
            }

            foreach ($this->db->get_where('company_master', ['is_on' => 1, 'is_active' => 1])->result() as $r) {
                $companyMap[strtolower(trim($c->comp_name))] = $c->ID;
            }

            foreach ($this->db->get_where('designation_master', ['is_on' => 1, 'is_active' => 1])->result() as $rel) {
                $designationMap[strtolower(trim($des->desig_name))] = $des->desig_id;
            }

            foreach ($this->db->get_where('placement_type', ['is_on' => 1, 'is_active' => 1])->result() as $mt) {
                $placementMap[strtolower(trim($pla->name))] = $pla->id;
            }


            $insertData = [];

            foreach ($sheetData as $key => $row) {
                if ($key == 1) continue; // skip header

                      $place_id     = trim($row[$headerMap['Sr. No.']] ?? '');
$fk_branch    = trim($row[$headerMap['Department']] ?? '');
$email  = !empty(trim($row[$headerMap['father name']] ?? '')) ? trim($row[$headerMap['father name']]) : null;
$contact  = !empty(trim($row[$headerMap['mother name']] ?? '')) ? trim($row[$headerMap['mother name']]) : null;
$fk_div   = strtolower(trim($row[$headerMap['Division']] ?? ''));
$fk_place         = trim($row[$headerMap['dob']] ?? '');
$fk_desig = strtolower(trim($row[$headerMap['Job Role / Designation']] ?? ''));
$fk_student   = strtolower(trim($row[$headerMap['Student Name']] ?? ''));
$fk_class = strtolower(trim($row[$headerMap['mother tongue']] ?? ''));
$fk_company   = strtolower(trim($row[$headerMap['Company Name']] ?? ''));
$roll_no    = !empty(trim($row[$headerMap['Roll No.']] ?? '')) ? trim($row[$headerMap['Roll No.']]) : null;
$joining_date    = !empty(trim($row[$headerMap['address line 2']] ?? '')) ? trim($row[$headerMap['address line 2']]) : null;
$salary_package    = !empty(trim($row[$headerMap['Package (LPA)']] ?? '')) ? trim($row[$headerMap['Package (LPA)']]) : null;

   
                
                // Skip if mandatory fields are empty
                if (empty($appliID) || empty($fullName) || empty($genderStr) || empty($districtStr) || empty($talukaStr)) {
                    continue;
                }

                // Skip duplicate AppliID
                if ($this->db->get_where('student_reg', ['AppliID' => $appliID])->row()) {
                    continue;
                }

            
                // branch
                if (!isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $branch_id = $this->db->insert_id();
                    $branchMap[$branchStr] = $branch_id;
                } else {
                    $branch_id = $branchMap[$branchStr];
                }

                // Division
                if (!isset($divisionMap[$divisionStr])) {
                    $this->db->insert('division_master', [
                        'div_name' => ucfirst($divisionStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $div_id = $this->db->insert_id();
                    $divisionMap[$divisionStr] = $div_id;
                } else {
                    $div_id = $divisionMap[$divisionStr];
                }

                // student
                if (!isset($studentMap[$studentStr])) {
                    $this->db->insert('student_reg', [
                        'FullName' => ucfirst($studentStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $Student_id = $this->db->insert_id();
                    $studentMap[$studentStr] = $Student_id;
                } else {
                    $Student_id = $studentMap[$studentStr];
                }

                // placement type
if (!isset($placementMap[$placeStr])) {
    $this->db->insert('placement_type', [
        'name' => ucfirst($placeStr),
        'is_on' => 1,
        'is_active' => 1
    ]);
    $placeId= $this->db->insert_id();
    $placementMap[$placeStr] = $placeId;
} else {
    $placeId = $placementMap[$placeStr];
}


// company
if (!isset($companyMap[$companyStr])) {
    $this->db->insert('company_master', [
        'comp_name' => ucfirst($companyStr),
        'is_on' => 1,
        'is_active' => 1
    ]);
    $compid = $this->db->insert_id();
    $companyMap[$companyStr] = $compid;
} else {
    $compid = $companyMap[$companyStr];
}
              
                // designation
                if (!isset($designationMap[$designationStr])) {
                    $this->db->insert('designation_master', [
                        'desig_name' => ucfirst($designationStr),
                        'is_on' => 1,
                        'is_active' => 1
                    ]);
                    $desigId = $this->db->insert_id();
                    $designationMap[$designationStr] = $desigId;
                } else {
                    $desigId = $designationMap[$designationStr];
                }

               

$Financial_Year = null;
$finiYearId = null;

if (!empty($bf_raw)) {
    $dateStr = str_replace('/', '-', $bf_raw);
    $dateObj = DateTime::createFromFormat('d-m-Y', $dateStr);
    if (!$dateObj) {
        $dateObj = DateTime::createFromFormat('Y-m-d', $dateStr); // Try alternate format if needed
    }
    if (!$dateObj) {
        // Date parsing failed, but we won't echo or print anything here
        // You can log silently if you want:
        // log_message('error', "Date parsing failed for: $bf_raw");
    } else {
        $year = (int)$dateObj->format('Y');
        // You can keep this debug if you want or comment out:
        // echo "Parsed Year: $year\n";

        $this->db->select('finiYear_id, fini_Label');
        $finiYearRows = $this->db->get('finiyear_master')->result();

        foreach ($finiYearRows as $rowFY) {
            $range = explode('-', $rowFY->fini_Label);
            if (count($range) == 2) {
                $startYear = (int)$range[0];
                $endYear = (int)$range[1];
                if ($year >= $startYear && $year <= $endYear) {
                    $finiYearId = $rowFY->finiYear_id;
                    break;
                }
            }
        }
        $Financial_Year = $finiYearId;
        if (!$Financial_Year) {
            // Optional: comment this out if you want to suppress
            // echo "No matching financial year found for year: $year\n";
        }
    }
} else {
    // Optional: comment out if you want no output when $bf_raw empty
    // echo "bf_raw is empty or missing\n";
}


                // Final data array
                $insertData[] = [
                    'AppliID'        => $appliID,
                    'FullName'       => $fullName,
                    'FatherName'     => $fatherName,
                    'MotherName'     => $motherName,
                    'fkGender_id'    => $genderId,
                    'DOB'            => $DOB,
                    'fkReligion_id'  => $religionId,
                    'fkRegion_id'    => $regionId,
                    'fkMotherTon_id' => $motherTongueId,
                    'fkFamInc_id'    => $familyIncomeId,
                    'AddLine1'       => $addLine1,
                    'AddLine2'       => $addLine2,
                    'AddLine3'       => $addLine3,
                    'fkDistrict_id'  => $districtId,
                    'fkTaluka_id'    => $talukaId,
                    'fkState_id'     => $stateId,
                    'fkVillage_id'   => $Villid,
                    'Phone'    => $phone,
                    'EMail'    => $email,
                    'Mobile'   => $mobile,
                    'Pincode'  => $pincode,
                    'fkSSCBoard_id'  => $sscBoardId,
    'fkRelMin_id'    => $relMinId,
    'fkLinguMin_id'  => $linguMinId,
    'fkDefType_id'   => $defTypeId,
    'fkhandikap_id'  => $phTypeId,
    'fkCat_id'       => $catId,
    'fkHomeUni_id'   => $homeUniId,
    'fkCandType_id'  => $candTypeId,
       'SSCPassYear' => $sscPassYear,
    'SSCSeatNo' => $sscSeatNo,
    'SSCMathPer' => $sscMathPer,
    'SSCTotalPer' => $sscTotalPer,
     'fkQualifyExam_id' => $Qualify_id,
    'fkHSCBoard_id' => $hscid,
    'HSCPassYear' => $hscPassYear,
    'HSCSeatNo' => $hscSeat,
    'HSCPhyPer' => $hscPhy,
     'HSCChemPer' => $hscChem,
    'HSCMathPer' => $hscMath,
    'fkHSCAddSub_id' => $sub_id,
    'HSCSubPer' => $hscSubPer,
    'HSCEngPer' => $hscEngPer,
    'HSCTotalPer' => $hscTotPer,
    'EligiPer' => $EligiPer,
    'CETRoll' => $CETRoll,
    'CETPer' => $CETPer,
    'JEERollNo' => $JEERoll,
    'JEEPer' => $JEEPer,
    'MeritNo' => $MeritNo,
    'MeritMarks' => $MeritMarks,
    'InstCode' => $InsituCode,
        'fkInstitName_id' => $Institu_id,
    'fkBranchName_id' => $branch_id,
    'ChoiceCode' => $choiceCode,
    'fkSeatType_id' => $Seatid,
    'AdmDate' => $AdmDate,
    'ReportedDate' => $ReportedDate,
    'Financial_Year' => $Financial_Year,  
                    'form_no'        => 1,
                    'ExcelName'      => $originalName
                ];
            }

            if (!empty($insertData)) {
                $this->Import_place_model->insert_batch($insertData);
                echo "success";
            } else {
                echo "no_data";
            }

        } else {
            echo "no_file";
        }

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}

    // Import_place Excel Logic
//     public function Import_place_excel()
// {
//     try {
//         if (!empty($_FILES['excel_file']['name'])) {
//             // Get original file name
//             $originalName = $_FILES['excel_file']['name'];
//             $tempPath = $_FILES['excel_file']['tmp_name'];

//             // Upload folder
//             $uploadPath = 'uploads/excel/';
//             if (!is_dir($uploadPath)) {
//                 mkdir($uploadPath, 0777, true); // Create directory if not exists
//             }

//             // Create unique file name for storage
//             $filename = date('YmdHis') . '_' . $originalName;
//             $targetFilePath = $uploadPath . $filename;

//             // Move uploaded file
//             if (!move_uploaded_file($tempPath, $targetFilePath)) {
//                 echo "file_upload_error";
//                 return;
//             }

//             // Load Excel
//             $spreadsheet = IOFactory::load($targetFilePath);
//             $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

//             log_message('debug', 'Excel Header Row: ' . print_r($sheetData[1], true));

//             // Master data maps
//             $genderMap = [];
//             $districtMap = [];
//             $talukaMap = [];

//             // Load gender master
//             $genders = $this->db->get_where('gender_master', ['is_on' => 1, 'is_active' => 1])->result();
//             foreach ($genders as $g) {
//                 $genderMap[strtolower(trim($g->gender_name))] = $g->gender_id;
//             }

//             // Load district master
//             $districts = $this->db->get_where('district_master', ['is_on' => 1, 'is_active' => 1])->result();
//             foreach ($districts as $d) {
//                 $districtMap[strtolower(trim($d->district_name))] = $d->district_id;
//             }

//             // Load taluka master
//             $talukas = $this->db->get_where('taluka_master', ['is_on' => 1, 'is_active' => 1])->result();
//             foreach ($talukas as $t) {
//                 $talukaMap[strtolower(trim($t->taulkaName))] = $t->taluka_id;
//             }

//             $insertData = [];

//             foreach ($sheetData as $key => $row) {
//                 if ($key == 1) continue; // Skip header row

//                 $appliID     = trim($row['B'] ?? '');
//                 $fullName    = trim($row['C'] ?? '');
//                 $fatherName  = !empty(trim($row['D'] ?? '')) ? trim($row['D']) : null;
//                 $motherName  = !empty(trim($row['E'] ?? '')) ? trim($row['E']) : null;
//                 $genderStr   = strtolower(trim($row['F'] ?? ''));
//                 $DOB    = trim($row['G'] ?? '');
//                  $Religion  = !empty(trim($row['H'] ?? '')) ? trim($row['H']) : null;
//                 $districtStr = strtolower(trim($row['P'] ?? ''));
//                 $talukaStr   = strtolower(trim($row['Q'] ?? ''));

//                 if (empty($appliID) || empty($fullName) || empty($genderStr) || empty($districtStr) || empty($talukaStr)) {
//                     continue;
//                 }

//                 // Skip if AppliID exists
//                 $exists = $this->db->get_where('student_reg', ['AppliID' => $appliID])->row();
//                 if ($exists) continue;

//                 // Gender
//                 if (!isset($genderMap[$genderStr])) {
//                     $this->db->insert('gender_master', [
//                         'gender_name' => ucfirst($genderStr),
//                         'is_on' => 1,
//                         'is_active' => 1
//                     ]);
//                     $genderId = $this->db->insert_id();
//                     $genderMap[$genderStr] = $genderId;
//                 } else {
//                     $genderId = $genderMap[$genderStr];
//                 }

//                 // District
//                 if (!isset($districtMap[$districtStr])) {
//                     $this->db->insert('district_master', [
//                         'district_name' => ucfirst($districtStr),
//                         'is_on' => 1,
//                         'is_active' => 1
//                     ]);
//                     $districtId = $this->db->insert_id();
//                     $districtMap[$districtStr] = $districtId;
//                 } else {
//                     $districtId = $districtMap[$districtStr];
//                 }

//                 // Taluka
//                 if (!isset($talukaMap[$talukaStr])) {
//                     $this->db->insert('taluka_master', [
//                         'taulkaName' => ucfirst($talukaStr),
//                         'is_on' => 1,
//                         'is_active' => 1
//                     ]);
//                     $talukaId = $this->db->insert_id();
//                     $talukaMap[$talukaStr] = $talukaId;
//                 } else {
//                     $talukaId = $talukaMap[$talukaStr];
//                 }

//                 // Prepare data row
//                 $insertData[] = [
//                     'AppliID'       => $appliID,
//                     'FullName'      => $fullName,
//                     'FatherName'    => $fatherName,
//                     'MotherName'    => $motherName,
//                     'fkGender_id'   => $genderId,
//                     'DOB'   => $DOB,
//                     'fkReligion_id'   => $Religion,
//                     'fkRegion_id'   => $Region,
//                     'fkDistrict_id' => $districtId,
//                     'fkTaluka_id'   => $talukaId,
//                     'form_no'       => 1, // ✅ Hardcoded form number
//                     'ExcelName'     => $originalName // ✅ Original filename only
//                 ];
//             }

//             if (!empty($insertData)) {
//                 $this->Import_place_model->insert_batch($insertData);
//                 echo "success";
//             } else {
//                 echo "no_data";
//             }

//         } else {
//             echo "no_file";
//         }

//     } catch (Exception $e) {
//         echo "Error: " . $e->getMessage();
//     }
// }

 
}
