<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Import_techExcel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Import_techExcel_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // Load Import View
    public function create()
    {
        
         $data['branchdata'] = $this->Import_techExcel_model->getRegisteredBranches();
        $data['semdata'] = $this->Import_techExcel_model->getsem();
        
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Import_techExcel_view',$data);
        $this->load->view('admin/footer_view');
    }

   
 public function import_excel_save()
{
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        
        // ✅ Get Branch and Semester from form
        $fk_branch = $this->input->post('fkbranch_id');
        $fk_sem = $this->input->post('fk_sem');
        
        // ✅ Validate Branch and Semester
        if (empty($fk_branch) || empty($fk_sem)) {
            echo "branch_sem_required";
            return;
        }
        
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'tech_event_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "no_data";
                return;
            }
        }

        $jsonData = $this->input->post('tableData');
        if (empty($jsonData)) {
            echo "no_data";
            return;
        }

        $tableData = json_decode($jsonData, true);
        if (empty($tableData) || !is_array($tableData)) {
            echo "no_data";
            return;
        }

        // ✅ Load maps
        $eventMap = []; $levelMap = []; $yearMap = []; $studentMap = []; $rankMap = [];

        foreach ($this->db->get_where('event_master', ['is_on'=>1,'is_active'=>1])->result() as $g) {
            $eventMap[strtolower(trim($g->event_type))] = $g->event_id;
        }
        foreach ($this->db->get_where('level_master', ['is_on'=>1,'is_active'=>1])->result() as $d) {
            $levelMap[strtolower(trim($d->leval_name))] = $d->level_id;
        }
        foreach ($this->db->get_where('finiyear_master', ['is_active'=>1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
        foreach ($this->db->get_where('rank_master', ['is_on'=>1,'is_active'=>1])->result() as $r) {
            $rankMap[strtolower(trim($r->rank_name))] = $r->rank_id;
        }
        foreach ($this->db->get_where('student_reg', ['is_on'=>1,'is_active'=>1])->result() as $s) {
            $studentMap[strtolower(trim($s->FullName))] = $s->Student_id;
        }

        // ✅ Insert into technical_event with Branch and Semester
        $excelFileName = !empty($filename) ? $filename : NULL;

        $this->db->insert('technical_event', [
            'eventName' => NULL,
            'Financial_Year' => NULL,
            'excel_file' => $excelFileName,
            'fk_branch' => $fk_branch,      // 👈 Branch save
            'fk_sem' => $fk_sem,            // 👈 Semester save
            'created_by' => $_SESSION['userID']
        ]);
        $tech_id = $this->db->insert_id();

        $insertData = [];
        array_shift($tableData); // remove header row

        foreach ($tableData as $row) {
            $studentName  = trim($row['fk_student']);
            $rankName     = trim($row['fk_rank']);
            $institute    = trim($row['Institute']);
            $eventName    = trim($row['eventName']);
            $levelName    = trim($row['fk_leval']);
            $yearLabel    = trim($row['Financial_Year']);
            $eventType    = trim($row['fk_eventtype']);
            $eventDate    = trim($row['Event_date']);

            if (empty($studentName) && empty($rankName) && empty($institute) && empty($eventName) && empty($levelName) && empty($yearLabel)) continue;

            // Event
            $event_id = $eventStr = strtolower($eventType);
            if ($eventStr !== '') {
                if (!isset($eventMap[$eventStr])) {
                    $this->db->insert('event_master', ['event_type'=>ucfirst($eventStr),'is_on'=>1,'is_active'=>1]);
                    $event_id = $this->db->insert_id();
                    $eventMap[$eventStr] = $event_id;
                } else $event_id = $eventMap[$eventStr];
            }

            // Level
            $level_id = $levelStr = strtolower($levelName);
            if ($levelStr !== '') {
                if (!isset($levelMap[$levelStr])) {
                    $this->db->insert('level_master', ['leval_name'=>ucfirst($levelStr),'is_on'=>1,'is_active'=>1]);
                    $level_id = $this->db->insert_id();
                    $levelMap[$levelStr] = $level_id;
                } else $level_id = $levelMap[$levelStr];
            }

            // Year
            $finiYear_id = $yearStr = strtolower($yearLabel);
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', ['fini_Label'=>ucfirst($yearStr),'is_active'=>1]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else $finiYear_id = $yearMap[$yearStr];
            }

            // Student
            $Student_id = $studentStr = strtolower($studentName);
            if ($studentStr !== '') {
                if (!isset($studentMap[$studentStr])) {
                    $this->db->insert('student_reg', ['FullName'=>ucfirst($studentStr),'is_on'=>1,'is_active'=>1]);
                    $Student_id = $this->db->insert_id();
                    $studentMap[$studentStr] = $Student_id;
                } else $Student_id = $studentMap[$studentStr];
            }

            // Rank
            $rank_id = $rankStr = strtolower($rankName);
            if ($rankStr !== '') {
                if (!isset($rankMap[$rankStr])) {
                    $this->db->insert('rank_master', ['rank_name'=>ucfirst($rankStr),'is_on'=>1,'is_active'=>1]);
                    $rank_id = $this->db->insert_id();
                    $rankMap[$rankStr] = $rank_id;
                } else $rank_id = $rankMap[$rankStr];
            }

            $Event_date = !empty($eventDate) ? date('Y-m-d', strtotime(str_replace('/', '-', $eventDate))) : null;

            $insertData[] = [
                'fk_tech_id' => $tech_id,
                'fk_student' => $Student_id,
                'student_name' => $studentName,
                'fk_rank' => $rank_id,
                'Institute' => $institute,
                'eventName' => $eventName,
                'fk_leval' => $level_id,
                'Financial_Year' => $finiYear_id,
                'fk_eventtype' => $event_id,
                'Event_date' => $Event_date,
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('tech_event_student', $insertData);
            echo "success";
        } else echo "no_data";

        // Insert log - Action 4 (Excel)
        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = $fk_branch;  // 👈 Log me bhi branch save
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch, $_SESSION['userID']);

    } catch (Exception $e) {
        echo "Error: ".$e->getMessage();
    }
}


// ✅ Yeh function Excel filename check karega
public function check_duplicate_excel()
{
    if (!empty($_FILES['excel_file']['name'])) {
        $originalName = basename($_FILES['excel_file']['name']);
        
        // Database mein check karo ki yeh filename already hai ya nahi
        $existingFile = $this->db->query(
            "SELECT excel_file FROM technical_event 
             WHERE excel_file LIKE '%$originalName' 
             LIMIT 1"
        )->row();
        
        if ($existingFile) {
            echo "duplicate"; // File already exists
        } else {
            echo "unique"; // File is new
        }
    } else {
        echo "no_file";
    }
}

}
