<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class Industrialexcel extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Industrialexcel_model');
         $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
    }

    // Load Import View
    public function create()
    {
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Industrialexcel_view',$data);
        $this->load->view('admin/footer_view');
    }

public function import_excel_save() {
    try {
        $fk_submenuId = $this->input->post('fk_submenuId');
        
        // ✅ Handle Excel file upload
        if (!empty($_FILES['excel_file']['name'])) {
            $originalName = $_FILES['excel_file']['name'];
            $tempPath = $_FILES['excel_file']['tmp_name'];

            // Upload path
            $uploadDir = FCPATH . 'uploads/excel/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $filename = 'industrial_problem_excel_' . date('Ymd_His') . '_' . basename($originalName);
            $targetFile = $uploadDir . $filename;

            if (!move_uploaded_file($tempPath, $targetFile)) {
                echo "file_error";
                return;
            }
        }

        // ✅ Process table data
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];
 $institute = $this->db->select('Institu_id')
            ->from('institute_master')
            ->get()
            ->row();
        $Institute = $institute ? $institute->Institu_id : null;

        // ✅ Load maps for existing master data
       
        $yearMap = [];
        

       
        foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
            $yearMap[strtolower(trim($g->fini_Label))] = $g->finiYear_id;
        }
        
        $rowCount = 0;
        foreach ($rows as $row) {
            $rowCount++;

            // ✅ Skip header row
            if ($rowCount === 1) continue;

            // ✅ Year Master
            $yearStr = strtolower(trim($row['fk_finalyear'] ?? ''));
            if ($yearStr !== '') {
                if (!isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1
                    ]);
                    $finiYear_id = $this->db->insert_id();
                    $yearMap[$yearStr] = $finiYear_id;
                } else {
                    $finiYear_id = $yearMap[$yearStr];
                }
            } else {
                $finiYear_id = null;
            }

            
            

            // ✅ Date conversions
            // $indus_Date = !empty($row['indus_Date'])
            //     ? (is_numeric($row['indus_Date'])
            //         ? gmdate("Y-m-d", ($row['indus_Date'] - 25569) * 86400)
            //         : date('Y-m-d', strtotime(str_replace('/', '-', $row['indus_Date']))))
            //     : null;

            // ✅ Insert row
            $insertData[] = [
                'comp_name' => $row['comp_name'] ?? '',
                // 'indus_Date'     => $indus_Date,
                 'problem_statement' => $row['problem_statement'] ?? '',
               'fk_finalyear'=> $finiYear_id,
               'Institute'     => $Institute,
                'created_date' => date('Y-m-d'),
                'created_by'=>$_SESSION['userID']
            ];
        }

        if (!empty($insertData)) {
            $this->db->insert_batch('industrial_problem_data', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
        
        // Insert log - Action 4 (Excel)

        $action = 4;
        $record_id = null;
        $excel_name = $filename;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);

        
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}


}
