<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Industrialtran extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Industrialtran_model');
       $this->load->model('Log_model');
        $this->load->helper('log');
        
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }
 
 
    public function Dashboard()
    {
     
 
        // echo "<pre>";
        // print_r($data);
 
       
        $this->load->view('admin/header_view');
        $this->load->view('admin/Industrialtran_dash_view.php');
        $this->load->view('admin/footer_view');
   
   
 
    }
 
   
     public function index()
    {
      $data['alldata']=$this->Industrialtran_model->getdetailview();
 
        // echo "<pre>";
        // print_r($data);
 
       
        $this->load->view('admin/header_view');
        $this->load->view('admin/Industrialtran_detailview.php',$data);
        $this->load->view('admin/footer_view');
   
   
 
    }


    
    public function create()
    {
    //    $data['load_script'] = 'Designation';
        $data['branchdata'] = $this->Industrialtran_model->getbranch();
        $data['companydata'] = $this->Industrialtran_model->getcompany();
         $data['durationdata'] = $this->Industrialtran_model->getduration();
       
        //  echo "<pre>";
        // print_r($data);
 // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Industrialtran_view.php',$data);
        $this->load->view('admin/footer_view');
   
 
    }

   
 

// / File upload method with improved error handling
    private function upload_file($file_name, $upload_path = './upload/')
    {
        // Ensure upload directory exists and is writable
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, TRUE);
        }
 
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
        // $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE; // Use encrypted file names
 
        $this->upload->initialize($config);
 
        if (!$this->upload->do_upload($file_name)) {
            // If upload fails, return false or the current file
            return $this->input->post("hidden_photo{$file_name}");
        } else {
            $upload_data = $this->upload->data();
            return $upload_data['file_name'];
        }
    }
 
    
 

public function insertIndustrialtran()
{
   $fkcomp_ID     = $this->input->post('fkcomp_ID');
    $fkbranch_id    = $this->input->post('fkbranch_id');
    $fkduration_id     = $this->input->post('fkduration_id');
    $StartDate     = $this->input->post('StartDate');
    $EndDate       = $this->input->post('EndDate');
    $Trainee_Details       = $this->input->post('Trainee_Details');
    $Feedback      = $this->input->post('Feedback');
     $fk_submenuId = $this->input->post('fk_submenuId');


    // Handle excel file
    $student_list = null;
    if (!empty($_FILES['student_list']['name'])) {
        $student_list = $_FILES['student_list']['name'];
        // you can also move uploaded file if needed
        // move_uploaded_file($_FILES['excel_file']['tmp_name'], "./uploads/".$excel_name);
    }


    


    $this->load->library('upload');

$feedbackDoc_filename = $this->upload_file('feedbackDoc', './uploads/Industrialtran/');
$feedbackDoc = $feedbackDoc_filename ? '/uploads/Industrialtran/' . $feedbackDoc_filename : '';




    $fields = array(
        'fkcomp_ID'    => $fkcomp_ID,
        'fkbranch_id'   => $fkbranch_id,
        'fkduration_id'    => $fkduration_id,
        'StartDate'    => $StartDate,
        'EndDate'      => $EndDate,
        'Trainee_Details'      => $Trainee_Details,
        'Feedback'     => $Feedback,
        'feedbackDoc'     => $feedbackDoc,
        'student_list'    => $student_list,
        'faculty_list'    => $faculty_list,
        'created_by'=>$_SESSION['userID']
        
    
    );

    // Get current financial year
    $finiYear = $this->db->select('finiYear_id')->from('finiyear_master')->where('Active_Deactive', 1)->get()->row();
    if ($finiYear) {
        $fields['finicial_Year'] = $finiYear->finiYear_id;
    }

    // Get institute id
    $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
    if ($institute) {
        $fields['institute'] = $institute->Institu_id;
    }
     
    // Insert main guest lecture data first
    // $this->Industrialtran_model->insertdata($fields);
    
$inserted_id = $this->Industrialtran_model->insertdata($fields);
        $intrain_id =$inserted_id ;
 
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $inserted_id;
        $excel_name = null;
        $Fk_branch = $fkbranch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

    // Get the inserted guest ID
    // $intrain_id = $this->db->insert_id();

    // Handle multiple photos_Activity upload
    $train_photos = [];
    if (!empty($_FILES['train_photos']['name'][0])) {
        $filesCount = count($_FILES['train_photos']['name']);

        for ($i = 0; $i < $filesCount; $i++) {
            $_FILES['file']['name']     = $_FILES['train_photos']['name'][$i];
            $_FILES['file']['type']     = $_FILES['train_photos']['type'][$i];
            $_FILES['file']['tmp_name'] = $_FILES['train_photos']['tmp_name'][$i];
            $_FILES['file']['error']    = $_FILES['train_photos']['error'][$i];
            $_FILES['file']['size']     = $_FILES['train_photos']['size'][$i];

            $config['upload_path']   = './uploads/Industrialtran/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx|webp';
            // $config['max_size']      = 2048;
            $config['file_name']     = uniqid() . '_' . $_FILES['file']['name'];

            $this->upload->initialize($config);

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $train_photos_path = 'uploads/Industrialtran/' . $uploadData['file_name'];
                
                // Insert each photo into guesttalk_photo_master table
                $this->Industrialtran_model->insertgallery([
                    'fkintrain_id' => $intrain_id,  // Use the actual inserted guest ID
                    'train_photos' => $train_photos_path
                ]);
            }
        }
    }

    // Child data (student data)
    $student_name = $this->input->post('student_name');
    $prn_no = $this->input->post('prn_no');
    $fk_branch = $this->input->post('fk_branch');
    $fk_class = $this->input->post('fk_class');
 
    if (!empty($student_name)) {
        foreach ($student_name as $i => $name) {
            if (trim($name) == '') continue;
            $childData = array(
                'fkintrain_id' => $intrain_id,  
                'student_name' => $name,
                'prn_no' => $prn_no[$i] ?? null,
                'fk_branch' => $fk_branch[$i] ?? null,
                'fk_class' => $fk_class[$i] ?? null,
            );
            $this->Industrialtran_model->insertChild($childData);
        }
    }

    // Faculty data (after student data handling)
$faculty_name = $this->input->post('faculty_name');
$fk_faculty_branch = $this->input->post('fk_faculty_branch');
$fk_faculty_class = $this->input->post('fk_faculty_class');

if (!empty($faculty_name)) {
    foreach ($faculty_name as $i => $name) {
        if (trim($name) == '') continue;
        $facultyData = array(
            'fkintrain_id' => $intrain_id,  
            'faculty_name' => $name,
            'fk_branch' => $fk_faculty_branch[$i] ?? null,
            'fk_class' => $fk_faculty_class[$i] ?? null,
        );
        $this->Industrialtran_model->insertFaculty($facultyData);
    }
}

    echo json_encode(['success' => true, 'data' => $fields]);
}


   
   
   
public function update()
{
    $id = $this->uri->segment(4);
    $data['data'] = $this->Industrialtran_model->getbyid($id);
    $data['branchdata'] = $this->Industrialtran_model->getbranch();
    $data['companydata'] = $this->Industrialtran_model->getcompany();
     $data['durationdata'] = $this->Industrialtran_model->getduration();
    
    $data['selectedGallary'] = $this->Industrialtran_model->getSelectedimage($id);
     $data['childData'] = $this->Industrialtran_model->getChildByMainId($id);
     $data['facultyData'] = $this->Industrialtran_model->getFacultyByMainId($id);

    $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/Industrialtran_view.php', $data);
    $this->load->view('admin/footer_view');
}

   public function updateIndustrialtran()
{
    $intrain_id = $this->input->post('intrain_id'); // Fixed: removed extra space
    $fkcomp_ID     = $this->input->post('fkcomp_ID');
    $fkbranch_id    = $this->input->post('fkbranch_id');
    $fkduration_id     = $this->input->post('fkduration_id');
    $StartDate     = $this->input->post('StartDate');
    $EndDate       = $this->input->post('EndDate');
    $Trainee_Details       = $this->input->post('Trainee_Details');
    $Feedback      = $this->input->post('Feedback');
     $fk_submenuId = $this->input->post('fk_submenuId');

    // Handle removed existing photos FIRST
    $removed_photos = $this->input->post('removed_photos');
    if (!empty($removed_photos)) {
        $removed_photos_array = explode(',', $removed_photos);
        $this->deleteExistingPhotos($intrain_id, $removed_photos_array);
    }

    
    // Handle Reproof file upload
    $this->load->library('upload');

    // Handle feedbackDoc file upload
    $existing_feedbackDoc = $this->input->post('hidden_feedbackDoc');
    $feedbackDoc_filename = $this->upload_file('feedbackDoc', './uploads/Industrialtran/');
    $feedbackDoc = $feedbackDoc_filename ? 'uploads/Industrialtran/' . $feedbackDoc_filename : $existing_feedbackDoc;

    $fields = array(
        'intrain_id' => $intrain_id, // Fixed: removed extra space
        'fkcomp_ID'    => $fkcomp_ID,
        'fkbranch_id'   => $fkbranch_id,
        'fkduration_id'    => $fkduration_id,
        'StartDate'    => $StartDate,
        'EndDate'      => $EndDate,
        'Trainee_Details'      => $Trainee_Details,
        'Feedback'     => $Feedback,
        'feedbackDoc'     => $feedbackDoc,
        'modified_by'=>$_SESSION['userID']
       
    
    );

    // new code
    // Handle excel file
        if (!empty($_FILES['student_list']['name'])) {
            $updateData['excel_student_listname'] = $_FILES['student_list']['name'];
        }


    $this->Industrialtran_model->update($fields);
    // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $intrain_id;
        $excel_name = null;
        $Fk_branch = $fkbranch_id;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

    // Handle multiple train_photos update
    $uploaded_train_photos_files = $_FILES['train_photos'];
    $multiple_train_photos_uploaded = !empty($uploaded_train_photos_files['name'][0]);

    

    if ($multiple_train_photos_uploaded) {
        // ✅ Delete old photos first
        // $this->Industrialtran_model->deleteimagedata($intrain_id);  // Use $intrain_id instead of $intrain_id

        $count_files = count($_FILES['train_photos']['name']);
        for ($i = 0; $i < $count_files; $i++) {
            $_FILES['file']['name']     = $_FILES['train_photos']['name'][$i];
            $_FILES['file']['type']     = $_FILES['train_photos']['type'][$i];
            $_FILES['file']['tmp_name'] = $_FILES['train_photos']['tmp_name'][$i];
            $_FILES['file']['error']    = $_FILES['train_photos']['error'][$i];
            $_FILES['file']['size']     = $_FILES['train_photos']['size'][$i];

            $config['upload_path']   = './uploads/Industrialtran/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
            $config['max_size']      = 2048;
            $config['file_name']     = uniqid() . '_' . $_FILES['file']['name'];  // ✅ Added unique filename
            
            $this->upload->initialize($config);

            if ($this->upload->do_upload('file')) {
                $upload_data = $this->upload->data();
                $file_path = 'uploads/Industrialtran/' . $upload_data['file_name'];  // ✅ Removed leading slash for consistency
                
                // ✅ Use model method instead of direct DB insert
                $this->Industrialtran_model->insertgallery([
                    'fkintrain_id' => $intrain_id,  // Use $intrain_id
                    'train_photos' => $file_path
                ]);
            }
        }
    }

     // Get existing child records
        $existing_children = $this->Industrialtran_model->getChildByMainId($intrain_id);
        $existing_ids = array();
        foreach($existing_children as $child) {
            $existing_ids[] = $child->id;
        }
   
 
         // Child data arrays
        $ids  = $this->input->post('id');
       $student_name = $this->input->post('student_name');
    $prn_no  = $this->input->post('prn_no');
       $fk_branch  = $this->input->post('fk_branch');
    $fk_class  = $this->input->post('fk_class');
 
        $processed_ids = array();
 
        if (!empty($student_name)) {
            foreach ($student_name as $i => $name) {
                if (trim($name) == '') continue;
               
                $childData = array(
                    'fkintrain_id'=> $intrain_id,
                    'student_name'=> $name,
                'prn_no'=> $prn_no[$i] ?? null,
                 'fk_branch'=> $fk_branch[$i] ?? null,
                'fk_class'=> $fk_class[$i] ?? null,
 
                   
                );
 
                $existing_id = $ids[$i] ?? null;
               
                if (!empty($existing_id) && is_numeric($existing_id)) {
                    // Update existing record
                    $this->Industrialtran_model->updateChild($existing_id, $childData);
                    $processed_ids[] = $existing_id;
                } else {
                    // Insert new record
                    $this->Industrialtran_model->insertChild($childData);
                }
            }
        }
 
        // Delete records that were removed from UI
        $ids_to_delete = array_diff($existing_ids, $processed_ids);
        if (!empty($ids_to_delete)) {
            foreach($ids_to_delete as $delete_id) {
                $this->Industrialtran_model->deleteChild($delete_id);
            }
        }


        // Get existing faculty records
$existing_faculty = $this->Industrialtran_model->getFacultyByMainId($intrain_id);
$existing_faculty_ids = array();
foreach($existing_faculty as $faculty) {
    $existing_faculty_ids[] = $faculty->id;
}

// Faculty data arrays
$faculty_ids = $this->input->post('faculty_id');
$faculty_name = $this->input->post('faculty_name');
$fk_faculty_branch = $this->input->post('fk_faculty_branch');
$fk_faculty_class = $this->input->post('fk_faculty_class');

$processed_faculty_ids = array();

if (!empty($faculty_name)) {
    foreach ($faculty_name as $i => $name) {
        if (trim($name) == '') continue;
        
        $facultyData = array(
            'fkintrain_id' => $intrain_id,
            'faculty_name' => $name,
            'fk_branch' => $fk_faculty_branch[$i] ?? null,
            'fk_class' => $fk_faculty_class[$i] ?? null,
        );

        $existing_faculty_id = $faculty_ids[$i] ?? null;
        
        if (!empty($existing_faculty_id) && is_numeric($existing_faculty_id)) {
            // Update existing record
            $this->Industrialtran_model->updateFaculty($existing_faculty_id, $facultyData);
            $processed_faculty_ids[] = $existing_faculty_id;
        } else {
            // Insert new record
            $this->Industrialtran_model->insertFaculty($facultyData);
        }
    }
}

// Delete faculty records that were removed from UI
$faculty_ids_to_delete = array_diff($existing_faculty_ids, $processed_faculty_ids);
if (!empty($faculty_ids_to_delete)) {
    foreach($faculty_ids_to_delete as $delete_id) {
        $this->Industrialtran_model->deleteFaculty($delete_id);
    }
}
   

    echo json_encode(['success' => true, 'data' => $fields]);
}

private function deleteExistingPhotos($intrain_id, $removed_photos_array)
{
    if (!empty($removed_photos_array)) {
        // Delete from database
        $this->Industrialtran_model->deleteSpecificPhotos($intrain_id, $removed_photos_array);
        
        // Delete physical files
        foreach ($removed_photos_array as $photo_path) {
            $full_path = FCPATH . $photo_path;
            if (file_exists($full_path)) {
                unlink($full_path);
            }
        }
    }
}
}