<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class IndustrialtranReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('IndustrialtranReport_model');
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }

public function Report()
{
    // $data['alldata'] = []; // Empty by default
     $data['yeardata'] = $this->IndustrialtranReport_model->getyear();
      $data['institutedata'] = $this->IndustrialtranReport_model->getinstitu();
    $data['branchdata'] = $this->IndustrialtranReport_model->getbranch();
     $data['companydata'] = $this->IndustrialtranReport_model->getcompany();

     $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
   
   
    $this->load->view('admin/header_view');
    $this->load->view('admin/IndustrialtranReport_view.php',$data);
    $this->load->view('admin/footer_view');
}


public function getindusttData()
{
    $institu_id = $this->input->post('fk_institu'); 
    $branch_ids = $this->input->post('fkbranch_id');
    $company_ids = $this->input->post('fkcomp_ID');
    $year_id = $this->input->post('year');  
    $start_date = $this->input->post('start_date');  // Add this
    $end_date = $this->input->post('end_date');      // Add this

    $data = $this->IndustrialtranReport_model->getindustDataFiltered(
        $institu_id, 
        $branch_ids, 
        $company_ids, 
        $year_id, 
        $start_date, 
        $end_date
    );
    

    echo json_encode($data);
}

  

public function getPrintHeadings()
{
    $data = $this->IndustrialtranReport_model->getPrintHeadings();
    echo json_encode($data);
}

// studenet view

public function getStudentList()
{
    $fkintrain_id = $this->input->post('fkintrain_id');
    if (!$fkintrain_id) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->IndustrialtranReport_model->getStudentsByMeetId($fkintrain_id);
 
    echo json_encode($students);
}

// Faculty list method
public function getFacultyList()
{
    $fkintrain_id = $this->input->post('fkintrain_id');
    if (!$fkintrain_id) {
        echo json_encode([]);
        return;
    }
 
    $faculty = $this->IndustrialtranReport_model->getfacultyByMeetId($fkintrain_id);
 
    echo json_encode($faculty);
}


//  branch wise year graph new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->IndustrialtranReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->IndustrialtranReport_model->getSingleYearData($year,$branches);
        $types   = $this->IndustrialtranReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 

// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('start_date');  // match JS
    $endDate   = $this->input->post('end_date');    // match JS
 
    $result = $this->IndustrialtranReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('start_date');  // match JS
    $endDate   = $this->input->post('end_date');    // match JS
 
    $result = $this->IndustrialtranReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('start_date');
    $endDate   = $this->input->post('end_date');
 
    $result = $this->IndustrialtranReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 
  
}
