<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Industry_report extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Industry_report_model');
        
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
        
    }


   
   
    public function create()
	{
  $data['branchdata'] = $this->Industry_report_model->getbranch();
 $data['companydata'] = $this->Industry_report_model->getcompany();
  $data['institutedata'] = $this->Industry_report_model->getinstitu();
    // $data['catdata'] = $this->Industry_report_model->getcat();
//   $data['typedata'] = $this->Industry_report_model->gettype();
    $data['classdata'] = $this->Industry_report_model->getclass();

$data['divdata'] = $this->Industry_report_model->getdiv(); 
$data['yeardata'] = $this->Industry_report_model->getyear();


$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Industry_report_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id'); 
    $class_ids = $this->input->post('fk_class');
     $div_ids = $this->input->post('fk_div');
    $company_ids = $this->input->post('fk_company');
    $year = $this->input->post('year');


    $data = $this->Industry_report_model->getDataByInstitute(
        $institute_id,
        $year,
        $branch_ids,
        $class_ids,
        $div_ids,
        $company_ids
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->Industry_report_model->getPrintHeadings();
    echo json_encode($data);
}


// year and branch chart
 
 
// public function getYearwiseData()
// {
//     $year = $this->input->post('year');
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->Industry_report_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year
//         $summary = $this->Industry_report_model->getSingleYearData($year);
//         $types   = $this->Industry_report_model->getYearwiseTypes($year);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }
 

 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->Industry_report_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->Industry_report_model->getSingleYearData($year, $branches);
        $types   = $this->Industry_report_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
 
    $result = $this->Industry_report_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
    $result = $this->Industry_report_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
  
    $result = $this->Industry_report_model->getCombinedData($institu, $branches, $years);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 
 

// public function getStudentDetails() {
//     $id = $this->input->post('id');
//     $this->db->select('student_name, fk_branch, prn_no, fk_class');
//     $this->db->from('industryvisit_student'); 
//     $this->db->where('fk_induID', $id);
//     $query = $this->db->get();
//     echo json_encode($query->result());
// }


public function getStudentList()
{
    $fk_induID = $this->input->post('fk_induID');
    if (!$fk_induID) {
        echo json_encode([]);
        return;
    }
 
    // $this->load->model('ParentMeet_model');
    $students = $this->Industry_report_model->getStudentsByMeetId($fk_induID);
 
    echo json_encode($students);
}
 


}
