<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Internship extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Internship_model');
        $this->load->library('upload');
         $this->load->model('Log_model');
        $this->load->helper('log');
        
            if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Internship_dash_view.php');
        $this->load->view('admin/footer_view');
    }
    
    public function create()
    {
        // Load all required data for dropdowns
        $data['branchdata'] = $this->Internship_model->getBranch();
        $data['classdata'] = $this->Internship_model->getClass();
        $data['companyCatdata'] = $this->Internship_model->getCompanyCat();
        $data['companydata'] = $this->Internship_model->getCompany();
        $data['durationdata'] = $this->Internship_model->getDuration();
        $data['intertypedata'] = $this->Internship_model->getIntertype();
        $data['yeardata'] = $this->Internship_model->getYearData();
         $data['activeYear'] = $this->Internship_model->getActiveYear();
        
        // Set active year (you can modify this logic as needed)
        $data['active_year_id'] = date('Y');
        
        // Initialize empty data for new form
        $data['mainData'] = null;
        $data['childData'] = null;
        
         // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Internship_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertinternship()
{
    try {
        $this->output->set_content_type('application/json');
        
        $posted_data = $this->input->post();
       $fk_submenuId = $posted_data['fk_submenuId'] ?? null;

        
        if (empty($posted_data['finicial_Year']) || $posted_data['finicial_Year'] == '0') {
            echo json_encode(['status' => 'error', 'message' => 'Financial Year is required']);
            return;
        }
        
        if (empty($posted_data['student_name']) || !is_array($posted_data['student_name'])) {
            echo json_encode(['status' => 'error', 'message' => 'At least one student record is required']);
            return;
        }
        
        $finicial_Year = $posted_data['finicial_Year'];
        
        // ⭐ FIXED: Handle excel file upload with proper library initialization
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            // Create directory if it doesn't exist
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            $config['max_size'] = 10240; // 10MB max
            $config['file_name'] = 'internship_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            // ⭐ Initialize upload library with config
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
                log_message('info', 'Excel file uploaded successfully: ' . $excel_name);
            } else {
                $error = $this->upload->display_errors('', '');
                log_message('error', 'Excel upload failed: ' . $error);
                // Continue anyway - Excel is optional
            }
        }


        // Handle PDF file upload
        $common_pdf = null;
        if (!empty($_FILES['common_pdf']['name'])) {
            $config['upload_path'] = './uploads/pdf/';
            $config['allowed_types'] = 'pdf';
            $config['file_name'] = 'internship_pdf_' . time() . '_' . $_FILES['common_pdf']['name'];
            $config['max_size'] = 10240; // 10MB max
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('common_pdf')) {
                $common_pdf = $this->upload->data('file_name');
            } else {
                log_message('error', 'PDF upload failed: ' . $this->upload->display_errors('', ''));
            }
        }

        // Save parent data
        $parentData = array(
            'finicial_Year' => $finicial_Year,
            'excel_file' => $excel_name,
            'Common_pdf' => $common_pdf,
            'created_by'=>$_SESSION['userID']
        );
        
        $main_id = $this->Internship_model->insertMain($parentData);
        
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $main_id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
        
        if (!$main_id) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert main record']);
            return;
        }

        // Child data arrays
        $student_name = $this->input->post('student_name');
        $prn = $this->input->post('prn');
        $stipend_amount = $this->input->post('stipend_amount');
        $fkbranch_id = $this->input->post('fkbranch_id');
        $fkclass_id = $this->input->post('fkclass_id');
        $fkcompCat_id = $this->input->post('fkcompCat_id');  
        $fkcomp_Id = $this->input->post('fkcomp_Id');
        $fkduration_id = $this->input->post('fkduration_id');
        $fkinter_id = $this->input->post('fkinter_id');
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date'); 
        $finicial_Year_child = $this->input->post('finicial_Year_child');


        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        $inserted_count = 0;

        // ⭐ FIXED: Handle multiple file uploads per row
        $joining_letters = [];
        $completion_letters = [];
        $presentation_letters = [];

        // Process joining letters
        if (!empty($_FILES['joining_letter']['name'])) {
            foreach ($_FILES['joining_letter']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['joining_letter']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['joining_letter']['name'][$key],
                        'type' => $_FILES['joining_letter']['type'][$key],
                        'tmp_name' => $_FILES['joining_letter']['tmp_name'][$key],
                        'error' => $_FILES['joining_letter']['error'][$key],
                        'size' => $_FILES['joining_letter']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/joining/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'joining_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120; // 5MB
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $joining_letters[$key] = $this->upload->data('file_name');
                    } else {
                        log_message('error', 'Joining letter upload failed for row ' . $key . ': ' . $this->upload->display_errors());
                        $joining_letters[$key] = null;
                    }
                } else {
                    $joining_letters[$key] = null;
                }
            }
        }

        // Process completion letters
        if (!empty($_FILES['completion_letter']['name'])) {
            foreach ($_FILES['completion_letter']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['completion_letter']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['completion_letter']['name'][$key],
                        'type' => $_FILES['completion_letter']['type'][$key],
                        'tmp_name' => $_FILES['completion_letter']['tmp_name'][$key],
                        'error' => $_FILES['completion_letter']['error'][$key],
                        'size' => $_FILES['completion_letter']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/completion/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'completion_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $completion_letters[$key] = $this->upload->data('file_name');
                    } else {
                        log_message('error', 'Completion letter upload failed for row ' . $key);
                        $completion_letters[$key] = null;
                    }
                } else {
                    $completion_letters[$key] = null;
                }
            }
        }

        // Process presentation letters
        if (!empty($_FILES['presentation_letter']['name'])) {
            foreach ($_FILES['presentation_letter']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['presentation_letter']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['presentation_letter']['name'][$key],
                        'type' => $_FILES['presentation_letter']['type'][$key],
                        'tmp_name' => $_FILES['presentation_letter']['tmp_name'][$key],
                        'error' => $_FILES['presentation_letter']['error'][$key],
                        'size' => $_FILES['presentation_letter']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/presentation/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'presentation_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $presentation_letters[$key] = $this->upload->data('file_name');
                    } else {
                        log_message('error', 'Presentation letter upload failed for row ' . $key);
                        $presentation_letters[$key] = null;
                    }
                } else {
                    $presentation_letters[$key] = null;
                }
            }
        }

        // Insert child records with their respective files
        if (!empty($student_name)) {
            foreach ($student_name as $i => $name) {
                if (trim($name) == '') continue;
                
                $branch_id = $this->getOrCreateBranch($fkbranch_id[$i] ?? null);
                $class_id = $this->getOrCreateClass($fkclass_id[$i] ?? null);
                $compCat_id = $this->getOrCreateCompanyCat($fkcompCat_id[$i] ?? null);
                $comp_id = $this->getOrCreateCompany($fkcomp_Id[$i] ?? null);
                $duration_id = $this->getOrCreateDuration($fkduration_id[$i] ?? null);
                $inter_id = $this->getOrCreateIntertype($fkinter_id[$i] ?? null);
                $year_id = $this->getOrCreateYear($finicial_Year_child[$i] ?? null);
                
                // ⭐ Get file for THIS specific row only (or null if not uploaded)
                $joining_file = isset($joining_letters[$i]) ? $joining_letters[$i] : null;
                $completion_file = isset($completion_letters[$i]) ? $completion_letters[$i] : null;
                $presentation_file = isset($presentation_letters[$i]) ? $presentation_letters[$i] : null;
                
                $childData = array(
                    'main_id' => $main_id,
                    'student_name' => $name,
                    'prn' => $prn[$i] ?? null,
                    'stipend_amount' => $stipend_amount[$i] ?? null,
                    'fkbranch_id' => $branch_id,
                    'fkclass_id' => $class_id,
                    'fkcompCat_id' => $compCat_id,
                    'fkcomp_Id' => $comp_id,
                    'fkduration_id' => $duration_id,
                    'fkinter_id' => $inter_id,
                    'start_date' => !empty($start_date[$i]) ? $start_date[$i] : null,
                    'end_date' => !empty($end_date[$i]) ? $end_date[$i] : null,
                    'finicial_Year' => $year_id,
                    'institute' => $institute_id,
                    // ⭐ IMPORTANT: Only this row's files are saved, others get NULL
                    'joining_letter' => $joining_file,
                    'completion_letter' => $completion_file,
                    'presentation_letter' => $presentation_file
                );

                if ($this->Internship_model->insertChild($childData)) {
                    $inserted_count++;
                }
            }
        }

        // Clean up temporary file array
        unset($_FILES['temp_file']);

        if ($inserted_count > 0) {
            echo json_encode([
                'status' => 'success', 
                'main_id' => $main_id,
                'inserted_count' => $inserted_count,
                'message' => "Successfully saved {$inserted_count} student records"
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No student records were saved']);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Internship insertion error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
    // Helper methods to get or create master entries
    private function getOrCreateBranch($value) {
        if (empty($value)) return null;
        
        // If it's numeric, assume it's an ID
        if (is_numeric($value)) {
            return $value;
        }
        
        // Check if branch exists by name
        $existing = $this->Internship_model->getBranchByName($value);
        if ($existing) {
            return $existing->branch_id;
        }
        
        // Create new branch
        return $this->Internship_model->insertBranch(['branch_name' => $value]);
    }

    private function getOrCreateClass($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->Internship_model->getClassByName($value);
        if ($existing) {
            return $existing->class_id;
        }
        
        return $this->Internship_model->insertClass(['classname' => $value]);
    }

    private function getOrCreateCompanyCat($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->Internship_model->getCompanyCatByName($value);
        if ($existing) {
            return $existing->compCat_id;
        }
        
        return $this->Internship_model->insertCompanyCat(['category_name' => $value]);
    }

    private function getOrCreateCompany($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->Internship_model->getCompanyByName($value);
        if ($existing) {
            return $existing->ID;
        }
        
        return $this->Internship_model->insertCompany(['comp_name' => $value]);
    }

    private function getOrCreateDuration($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->Internship_model->getDurationByName($value);
        if ($existing) {
            return $existing->duration_id;
        }
        
        return $this->Internship_model->insertDuration(['duration_type' => $value]);
    }

    private function getOrCreateIntertype($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->Internship_model->getIntertypeByName($value);
        if ($existing) {
            return $existing->inter_id;
        }
        
        return $this->Internship_model->insertIntertype(['internship_type' => $value]);
    }

    private function getOrCreateYear($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->Internship_model->getYearByLabel($value);
        if ($existing) {
            return $existing->finiYear_id;
        }
        
        return $this->Internship_model->insertYear(['fini_Label' => $value]);
    }

    public function index()
    {
        // Load list view
        $data['alldata'] = $this->Internship_model->getAllInternships();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Internship_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function update($id)
    {
        // Load all required data for dropdowns
        $data['branchdata'] = $this->Internship_model->getBranch();
        $data['classdata'] = $this->Internship_model->getClass();
        $data['companyCatdata'] = $this->Internship_model->getCompanyCat();
        $data['companydata'] = $this->Internship_model->getCompany();
        $data['durationdata'] = $this->Internship_model->getDuration();
        $data['intertypedata'] = $this->Internship_model->getIntertype();
        $data['yeardata'] = $this->Internship_model->getYearData();
        
        // Load existing data
        $data['mainData'] = $this->Internship_model->getMainById($id);
        $data['childData'] = $this->Internship_model->getChildByMainId($id);
        $data['active_year_id'] = $data['mainData']->finicial_Year ?? date('Y');
        
         $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Internship_view.php', $data);
        $this->load->view('admin/footer_view');
    }

   
public function updateinternship()
{
    try {
        $this->output->set_content_type('application/json');
        
        // ⭐ LOAD UPLOAD LIBRARY AT THE START
        $this->load->library('upload');
        
        $posted_data = $this->input->post();
        $main_id = $posted_data['main_id'] ?? null;
       $fk_submenuId = $posted_data['fk_submenuId'] ?? null;

        
        if (empty($main_id)) {
            echo json_encode(['status' => 'error', 'message' => 'Main ID is required for update']);
            return;
        }
        
        if (empty($posted_data['finicial_Year']) || $posted_data['finicial_Year'] == '0') {
            echo json_encode(['status' => 'error', 'message' => 'Financial Year is required']);
            return;
        }
        
        $finicial_Year = $posted_data['finicial_Year'];
        
        // Get existing main data
        $existingMain = $this->Internship_model->getMainById($main_id);
        
        // Handle excel file upload (keep existing if no new file)
        $excel_name = $existingMain->excel_file;
        if (!empty($_FILES['excel_file']['name'])) {
            $config['upload_path'] = './uploads/excel/';
            $config['allowed_types'] = 'xlsx|xls';
            $config['file_name'] = 'internship_' . time() . '_' . $_FILES['excel_file']['name'];
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                // Delete old file if exists
                if ($existingMain->excel_file && file_exists('./uploads/excel/' . $existingMain->excel_file)) {
                    unlink('./uploads/excel/' . $existingMain->excel_file);
                }
                $excel_name = $this->upload->data('file_name');
            } else {
                log_message('error', 'Excel upload failed: ' . $this->upload->display_errors('', ''));
            }
        }

        // Handle PDF file upload (keep existing if no new file)
        $common_pdf = $existingMain->Common_pdf;
        if (!empty($_FILES['common_pdf']['name'])) {
            $config['upload_path'] = './uploads/pdf/';
            $config['allowed_types'] = 'pdf';
            $config['file_name'] = 'internship_pdf_' . time() . '_' . $_FILES['common_pdf']['name'];
            $config['max_size'] = 10240;
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('common_pdf')) {
                // Delete old file if exists
                if ($existingMain->Common_pdf && file_exists('./uploads/pdf/' . $existingMain->Common_pdf)) {
                    unlink('./uploads/pdf/' . $existingMain->Common_pdf);
                }
                $common_pdf = $this->upload->data('file_name');
            } else {
                log_message('error', 'PDF upload failed: ' . $this->upload->display_errors('', ''));
            }
        }

        // Update parent data
        $parentData = array(
            'finicial_Year' => $finicial_Year,
            'excel_file' => $excel_name,
            'Common_pdf' => $common_pdf,
             'modified_by'=>$_SESSION['userID']
        );
        
        $this->Internship_model->updateMain($main_id, $parentData);
        // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $main_id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        // Delete all existing child records for this main_id
        $this->Internship_model->deleteChildByMainId($main_id);

        // Child data arrays
        $student_name = $this->input->post('student_name');
        $prn = $this->input->post('prn');
        $stipend_amount = $this->input->post('stipend_amount');
        $fkbranch_id = $this->input->post('fkbranch_id');
        $fkclass_id = $this->input->post('fkclass_id');
        $fkcompCat_id = $this->input->post('fkcompCat_id');  
        $fkcomp_Id = $this->input->post('fkcomp_Id');
        $fkduration_id = $this->input->post('fkduration_id');
        $fkinter_id = $this->input->post('fkinter_id');
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date'); 
        $finicial_Year_child = $this->input->post('finicial_Year_child');
        $existing_joining_letter = $this->input->post('existing_joining_letter');
        $existing_completion_letter = $this->input->post('existing_completion_letter');
        $existing_presentation_letter = $this->input->post('existing_presentation_letter');

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        $inserted_count = 0;

        // Process file uploads
        $joining_letters = [];
        $completion_letters = [];
        $presentation_letters = [];

        // Process joining letters
        if (!empty($_FILES['joining_letter']['name'])) {
            foreach ($_FILES['joining_letter']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['joining_letter']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['joining_letter']['name'][$key],
                        'type' => $_FILES['joining_letter']['type'][$key],
                        'tmp_name' => $_FILES['joining_letter']['tmp_name'][$key],
                        'error' => $_FILES['joining_letter']['error'][$key],
                        'size' => $_FILES['joining_letter']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/joining/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'joining_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $joining_letters[$key] = $this->upload->data('file_name');
                    } else {
                        log_message('error', 'Joining letter upload failed for row ' . $key);
                        $joining_letters[$key] = $existing_joining_letter[$key] ?? null;
                    }
                } else {
                    $joining_letters[$key] = $existing_joining_letter[$key] ?? null;
                }
            }
        } else {
            // If no files uploaded, use existing files
            if (!empty($existing_joining_letter)) {
                foreach ($existing_joining_letter as $key => $file) {
                    $joining_letters[$key] = $file;
                }
            }
        }

        // Process completion letters
        if (!empty($_FILES['completion_letter']['name'])) {
            foreach ($_FILES['completion_letter']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['completion_letter']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['completion_letter']['name'][$key],
                        'type' => $_FILES['completion_letter']['type'][$key],
                        'tmp_name' => $_FILES['completion_letter']['tmp_name'][$key],
                        'error' => $_FILES['completion_letter']['error'][$key],
                        'size' => $_FILES['completion_letter']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/completion/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'completion_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $completion_letters[$key] = $this->upload->data('file_name');
                    } else {
                        log_message('error', 'Completion letter upload failed for row ' . $key);
                        $completion_letters[$key] = $existing_completion_letter[$key] ?? null;
                    }
                } else {
                    $completion_letters[$key] = $existing_completion_letter[$key] ?? null;
                }
            }
        } else {
            if (!empty($existing_completion_letter)) {
                foreach ($existing_completion_letter as $key => $file) {
                    $completion_letters[$key] = $file;
                }
            }
        }

        // Process presentation letters
        if (!empty($_FILES['presentation_letter']['name'])) {
            foreach ($_FILES['presentation_letter']['name'] as $key => $filename) {
                if (!empty($filename) && $_FILES['presentation_letter']['error'][$key] == 0) {
                    $_FILES['temp_file'] = array(
                        'name' => $_FILES['presentation_letter']['name'][$key],
                        'type' => $_FILES['presentation_letter']['type'][$key],
                        'tmp_name' => $_FILES['presentation_letter']['tmp_name'][$key],
                        'error' => $_FILES['presentation_letter']['error'][$key],
                        'size' => $_FILES['presentation_letter']['size'][$key]
                    );
                    
                    $config['upload_path'] = './uploads/letters/presentation/';
                    $config['allowed_types'] = 'pdf|doc|docx';
                    $config['file_name'] = 'presentation_' . time() . '_' . $key . '_' . $filename;
                    $config['max_size'] = 5120;
                    
                    if (!is_dir($config['upload_path'])) {
                        mkdir($config['upload_path'], 0777, true);
                    }
                    
                    $this->upload->initialize($config);
                    
                    if ($this->upload->do_upload('temp_file')) {
                        $presentation_letters[$key] = $this->upload->data('file_name');
                    } else {
                        log_message('error', 'Presentation letter upload failed for row ' . $key);
                        $presentation_letters[$key] = $existing_presentation_letter[$key] ?? null;
                    }
                } else {
                    $presentation_letters[$key] = $existing_presentation_letter[$key] ?? null;
                }
            }
        } else {
            if (!empty($existing_presentation_letter)) {
                foreach ($existing_presentation_letter as $key => $file) {
                    $presentation_letters[$key] = $file;
                }
            }
        }

        // Insert child records
        if (!empty($student_name)) {
            foreach ($student_name as $i => $name) {
                if (trim($name) == '') continue;
                
                $branch_id = $this->getOrCreateBranch($fkbranch_id[$i] ?? null);
                $class_id = $this->getOrCreateClass($fkclass_id[$i] ?? null);
                $compCat_id = $this->getOrCreateCompanyCat($fkcompCat_id[$i] ?? null);
                $comp_id = $this->getOrCreateCompany($fkcomp_Id[$i] ?? null);
                $duration_id = $this->getOrCreateDuration($fkduration_id[$i] ?? null);
                $inter_id = $this->getOrCreateIntertype($fkinter_id[$i] ?? null);
                $year_id = $this->getOrCreateYear($finicial_Year_child[$i] ?? null);
                
                $joining_file = isset($joining_letters[$i]) ? $joining_letters[$i] : null;
                $completion_file = isset($completion_letters[$i]) ? $completion_letters[$i] : null;
                $presentation_file = isset($presentation_letters[$i]) ? $presentation_letters[$i] : null;
                
                $childData = array(
                    'main_id' => $main_id,
                    'student_name' => $name,
                    'prn' => $prn[$i] ?? null,
                    'stipend_amount' => $stipend_amount[$i] ?? null,
                    'fkbranch_id' => $branch_id,
                    'fkclass_id' => $class_id,
                    'fkcompCat_id' => $compCat_id,
                    'fkcomp_Id' => $comp_id,
                    'fkduration_id' => $duration_id,
                    'fkinter_id' => $inter_id,
                    'start_date' => !empty($start_date[$i]) ? $start_date[$i] : null,
                    'end_date' => !empty($end_date[$i]) ? $end_date[$i] : null,
                    'finicial_Year' => $year_id,
                    'institute' => $institute_id,
                    'joining_letter' => $joining_file,
                    'completion_letter' => $completion_file,
                    'presentation_letter' => $presentation_file
                );

                if ($this->Internship_model->insertChild($childData)) {
                    $inserted_count++;
                }
            }
        }

        unset($_FILES['temp_file']);

        if ($inserted_count > 0) {
            echo json_encode([
                'status' => 'success', 
                'main_id' => $main_id,
                'inserted_count' => $inserted_count,
                'message' => "Successfully updated {$inserted_count} student records"
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No student records were updated']);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Internship update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}

}