<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class JobStudent extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('JobStudent_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
        
    }
 
    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/JobStudent_dash_view.php');
        $this->load->view('admin/footer_view');
    }
 
    public function index()
    {
        $data['alldata'] = $this->JobStudent_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/JobStudent_detailview.php',$data);
        $this->load->view('admin/footer_view');
    }
    
    public function create()
    {
        $data['branchdata'] = $this->JobStudent_model->getbranch();
        $data['facultydata'] = $this->JobStudent_model->getFac();
        $data['classdata'] = $this->JobStudent_model->getclass();
        $data['yeardata'] = $this->JobStudent_model->getyear();
          $data['activeYear'] = $this->JobStudent_model->getActiveYear();
        $data['natureworkdata'] = $this->JobStudent_model->getNatureWork();
// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/JobStudent_view.php',$data);
        $this->load->view('admin/footer_view');
    }

    public function insertJobStudent()
    {
        try {
            $this->output->set_content_type('application/json');

            // Get entry_date and year from form (NOT arrays)
            $entry_date = $this->input->post('entry_date');
           $year = $this->input->post('finicial_Year');
$fk_submenuId = $this->input->post('fk_submenuId');
            // Handle excel file upload
            $excel_name = null;
            if (!empty($_FILES['excel_file']['name'])) {
                $config['upload_path']   = './uploads/excel/';
                $config['allowed_types'] = 'xls|xlsx';
                $config['file_name']     = time() . '_' . $_FILES['excel_file']['name'];
                
                // Create directory if not exists
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }
                
                $this->load->library('upload', $config);
                
                if ($this->upload->do_upload('excel_file')) {
                    $upload_data = $this->upload->data();
                    $excel_name = $upload_data['file_name'];
                }
            }

            // Get institute id
            $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $institute_id = $institute ? $institute->Institu_id : null;

            // Child data arrays
            $student_name   = $this->input->post('student_name');
            $prn            = $this->input->post('prn'); 
            $fkbranch_id    = $this->input->post('fkbranch_id'); 
            $fkclass_id     = $this->input->post('fkclass_id'); 
            $fknature_id    = $this->input->post('nature_work');
            $fkfac_id       = $this->input->post('fkfac_id'); // Array
            $division       = $this->input->post('division'); 
            $studcontact    = $this->input->post('studcontact'); 
            $nature_work    = $this->input->post('nature_work'); 
            $Duration       = $this->input->post('Duration'); 
            $workingDays    = $this->input->post('workingDays'); 
            $payment_details= $this->input->post('payment_details'); 
            $Remarks        = $this->input->post('Remarks'); 
            $start_date     = $this->input->post('start_date'); 
            $end_date       = $this->input->post('end_date');

            // Debug logging
            log_message('debug', 'Faculty IDs received: ' . print_r($fkfac_id, true));

            $inserted_count = 0;

            if (!empty($student_name)) {
                foreach ($student_name as $i => $name) {
                    if (trim($name) == '') continue;

                    // Get or create branch ID
                    $branch_id = $this->getOrCreateBranch($fkbranch_id[$i] ?? null);
                    
                    // Get or create class ID
                    $class_id  = $this->getOrCreateClass($fkclass_id[$i] ?? null);
                    
                    // Get or create nature work ID
                    $nature_id = $this->getOrCreateNatureWork($fknature_id[$i] ?? null);

                    // Get or create faculty ID (FIXED - now will create if needed)
                    $faculty_id = $this->getOrCreateFaculty($fkfac_id[$i] ?? null);
                    
                    // Debug log for each row
                    log_message('debug', "Row $i: Faculty input = '{$fkfac_id[$i]}', Resolved ID = '$faculty_id'");

                    // Save all data directly to jobstudent_master
                    $childData = array(
                        'jobstud_name' => $name,
                        'PRN'          => $prn[$i] ?? null,
                        'fkbranch_id'  => $branch_id,
                        'fkclass_id'   => $class_id,
                        'fknature_id'  => $nature_id,
                        'division'     => $division[$i] ?? null,
                        'studcontact'  => $studcontact[$i] ?? null,
                        'naturework'   => $nature_work[$i] ?? null,
                        'Duration'     => $Duration[$i] ?? null,
                        'workingDays'  => $workingDays[$i] ?? null,
                        'paydetails'   => $payment_details[$i] ?? null,
                        'Remarks'      => $Remarks[$i] ?? null,
                        'StartDate'    => $start_date[$i] ?? null,
                        'EndDate'      => $end_date[$i] ?? null,
                        'fkfac_id'     => $faculty_id, // Now will have proper value
                        'entry_date'   => $entry_date,
                        'finicial_Year'=> $year,
                        'excel_name'   => $excel_name,
                        'institute'    => $institute_id,
                        'created_by'=>$_SESSION['userID']
                    );

                    // if ($this->JobStudent_model->insertChild($childData)) {
                    //     $inserted_count++;
                    // }

                    $inserted_id = $this->JobStudent_model->insertChild($childData);

if ($inserted_id) {

    $inserted_count++;

    // 🔹 log insert
    $action = 1; // Insert
    $record_id = $inserted_id;
    $excel_name = null;
    $Fk_branch = null;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );
}

                }
            }

            if ($inserted_count > 0) {
                echo json_encode([
                    'status' => 'success',
                    'inserted_count' => $inserted_count,
                    'message' => "Successfully saved {$inserted_count} student records"
                ]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'No student records were saved']);
            }

        } catch (Exception $e) {
            log_message('error', 'JobStudent insertion error: ' . $e->getMessage());
            echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
        }
    }

    // Helper method to get or create branch
    private function getOrCreateBranch($value) {
        if (empty($value)) return null;
        
        // If it's numeric, it's already an ID
        if (is_numeric($value)) {
            return $value;
        }
        
        // Check if branch exists by name
        $existing = $this->JobStudent_model->getBranchByName($value);
        if ($existing) {
            return $existing->branch_id;
        }
        
        // Create new branch
        return $this->JobStudent_model->insertBranch(['branch_name' => trim($value)]);
    }

    // Helper method to get or create class
    private function getOrCreateClass($value) {
        if (empty($value)) return null;
        
        // If it's numeric, it's already an ID
        if (is_numeric($value)) {
            return $value;
        }
        
        // Check if class exists by name
        $existing = $this->JobStudent_model->getClassByName($value);
        if ($existing) {
            return $existing->class_id;
        }
        
        // Create new class
        return $this->JobStudent_model->insertClass(['classname' => trim($value)]);
    }

    // Helper method for nature of work
    private function getOrCreateNatureWork($value) {
        if (empty($value)) return null;
        
        if (is_numeric($value)) {
            return $value;
        }
        
        $existing = $this->JobStudent_model->getNatureWorkByName($value);
        if ($existing) {
            return $existing->nature_id;
        }
        
        return $this->JobStudent_model->insertNatureWork(['nature_name' => trim($value)]);
    }

    // FIXED: Helper method for faculty - NOW CREATES FACULTY IF NOT EXISTS
    private function getOrCreateFaculty($value) {
        if (empty($value)) {
            log_message('debug', 'getOrCreateFaculty: Empty value received');
            return null;
        }
        
        // If it's numeric, it's already an ID
        if (is_numeric($value)) {
            log_message('debug', "getOrCreateFaculty: Numeric ID '$value' provided");
            return $value;
        }
        
        // Check if faculty exists by name
        log_message('debug', "getOrCreateFaculty: Searching for faculty name '$value'");
        $existing = $this->JobStudent_model->getFacultyByName($value);
        if ($existing) {
            log_message('debug', "getOrCreateFaculty: Found existing faculty with ID {$existing->fac_id}");
            return $existing->fac_id;
        }
        
        // ✅ CREATE NEW FACULTY IF NOT FOUND (same as branch/class)
        log_message('debug', "getOrCreateFaculty: Creating new faculty with name '$value'");
        $new_id = $this->JobStudent_model->insertFaculty(['fac_Fullname' => trim($value)]);
        log_message('debug', "getOrCreateFaculty: New faculty created with ID $new_id");
        return $new_id;
    }

    public function update($id) {
        $data['mainData'] = $this->JobStudent_model->getMainById($id);
        $data['childData'] = $this->JobStudent_model->getChildByMainId($id);
        
        $data['branchdata'] = $this->JobStudent_model->getbranch();
        $data['facultydata'] = $this->JobStudent_model->getFac();
        $data['classdata'] = $this->JobStudent_model->getclass();
        $data['yeardata'] = $this->JobStudent_model->getyear();
        $data['natureworkdata'] = $this->JobStudent_model->getNatureWork();
        
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/JobStudent_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function updateJobStudent()
{
    try {
        $this->output->set_content_type('application/json');

        // Get main record ID
        $main_id = $this->input->post('jobstud_id');
        
        // Get entry_date and year from form
        $entry_date = $this->input->post('entry_date');
       $year = $this->input->post('finicial_Year');
$fk_submenuId = $this->input->post('fk_submenuId');

        // Handle excel file upload (optional during update)
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $config['upload_path']   = './uploads/excel/';
            $config['allowed_types'] = 'xls|xlsx';
            $config['file_name']     = time() . '_' . $_FILES['excel_file']['name'];
            
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }
            
            $this->load->library('upload', $config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
            }
        }

        // Get institute id
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;

        // Child data arrays
        $jobstud_ids    = $this->input->post('jobstud_id'); // Array of record IDs
        $student_name   = $this->input->post('student_name');
        $prn            = $this->input->post('prn'); 
        $fkbranch_id    = $this->input->post('fkbranch_id'); 
        $fkclass_id     = $this->input->post('fkclass_id'); 
        $fknature_id    = $this->input->post('nature_work');
        $fkfac_id       = $this->input->post('fkfac_id');
        $division       = $this->input->post('division'); 
        $studcontact    = $this->input->post('studcontact'); 
        $nature_work    = $this->input->post('nature_work'); 
        $Duration       = $this->input->post('Duration'); 
        $workingDays    = $this->input->post('workingDays'); 
        $payment_details= $this->input->post('payment_details'); 
        $Remarks        = $this->input->post('Remarks'); 
        $start_date     = $this->input->post('start_date'); 
        $end_date       = $this->input->post('end_date');

        $updated_count = 0;
        $inserted_count = 0;

        if (!empty($student_name)) {
            foreach ($student_name as $i => $name) {
                if (trim($name) == '') continue;

                // Get or create IDs
                $branch_id = $this->getOrCreateBranch($fkbranch_id[$i] ?? null);
                $class_id  = $this->getOrCreateClass($fkclass_id[$i] ?? null);
                $nature_id = $this->getOrCreateNatureWork($fknature_id[$i] ?? null);
                $faculty_id = $this->getOrCreateFaculty($fkfac_id[$i] ?? null);

                $childData = array(
                    'jobstud_name' => $name,
                    'PRN'          => $prn[$i] ?? null,
                    'fkbranch_id'  => $branch_id,
                    'fkclass_id'   => $class_id,
                    'fknature_id'  => $nature_id,
                    'division'     => $division[$i] ?? null,
                    'studcontact'  => $studcontact[$i] ?? null,
                    'naturework'   => $nature_work[$i] ?? null,
                    'Duration'     => $Duration[$i] ?? null,
                    'workingDays'  => $workingDays[$i] ?? null,
                    'paydetails'   => $payment_details[$i] ?? null,
                    'Remarks'      => $Remarks[$i] ?? null,
                    'StartDate'    => $start_date[$i] ?? null,
                    'EndDate'      => $end_date[$i] ?? null,
                    'fkfac_id'     => $faculty_id,
                    'entry_date'   => $entry_date,
                    'finicial_Year'=> $year,
                    'institute'    => $institute_id,
                    'modified_by'=>$_SESSION['userID']
                );

                // Update excel_name only if new file uploaded
                if ($excel_name) {
                    $childData['excel_name'] = $excel_name;
                }

                // Check if this is an existing record or new one
                if (!empty($jobstud_ids[$i]) && is_numeric($jobstud_ids[$i])) {
                    // Update existing record
                    if ($this->JobStudent_model->updateRow($jobstud_ids[$i], $childData)) {
                        $updated_count++;

                        // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $jobstud_ids[$i];
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
                    }
                } else {
                    // Insert new record
                    if ($this->JobStudent_model->insertChild($childData)) {
                        $inserted_count++;
                    }
                }
            }
        }

        if ($updated_count > 0 || $inserted_count > 0) {
            $message = "Successfully updated {$updated_count} record(s)";
            if ($inserted_count > 0) {
                $message .= " and added {$inserted_count} new record(s)";
            }
            echo json_encode([
                'status' => 'success',
                'updated_count' => $updated_count,
                'inserted_count' => $inserted_count,
                'message' => $message
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No records were updated']);
        }

    } catch (Exception $e) {
        log_message('error', 'JobStudent update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}

}
?>