<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class JobStudentReport extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('JobStudentReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Report()
    {
        $data['yeardata'] = $this->JobStudentReport_model->getyear();
        $data['branchdata'] = $this->JobStudentReport_model->getbranch();
        $data['institutedata'] = $this->JobStudentReport_model->getinstitu();
        $data['classdata'] = $this->JobStudentReport_model->getclass();
        $data['worktypedata'] = $this->JobStudentReport_model->getworktype();
        
        // $activeYear = $this->db
        //     ->select('finiYear_id')
        //     ->from('finiyear_master')
        //     ->where('Active_Deactive', 1)
        //     ->get()
        //     ->row();
    
        // $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/JobStudentReport_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    // ✅ UPDATED: Added class and nature filters
    public function getJobStudentReportData()
    {
        $institu_id = $this->input->post('fk_institu'); 
        $branch_ids = $this->input->post('fkbranch_id');
        $class_ids = $this->input->post('fkclass_id'); // NEW
        $nature_ids = $this->input->post('fknature_id'); // NEW
        $year_id    = $this->input->post('year'); 
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate'); 

        $data = $this->JobStudentReport_model->getjobStudentDataFiltered(
            $institu_id, 
            $branch_ids, 
            $class_ids,   // NEW
            $nature_ids,  // NEW
            $year_id, 
            $startDate, 
            $endDate
        );

        echo json_encode($data);
    }

    public function getPrintHeadings()
    {
        $data = $this->JobStudentReport_model->getPrintHeadings();
        echo json_encode($data);
    }

    // ✅ UPDATED: Added class and nature filters
    public function getYearwiseData()
    {
        $year = $this->input->post('year');
        $branches = $this->input->post('branches');
        $classes = $this->input->post('classes'); // NEW
        $natures = $this->input->post('natures'); // NEW
    
        if ($year == "0" || empty($year)) {
            $summary = $this->JobStudentReport_model->getAllYearsData($branches, $classes, $natures);
            $types   = [];
        } else {
            $summary = $this->JobStudentReport_model->getSingleYearData($year, $branches, $classes, $natures);
            $types   = $this->JobStudentReport_model->getYearwiseTypes($year, $branches, $classes, $natures);
        }
    
        echo json_encode([
            "status"  => "success",
            "summary" => $summary,
            "types"   => $types
        ]);
    }

    // ✅ UPDATED: Added class and nature filters
    public function getBranchwiseData()
    {
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('fkbranch_id');
        $classes   = $this->input->post('classes'); // NEW
        $natures   = $this->input->post('natures'); // NEW
        $year      = $this->input->post('year');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');
    
        $result = $this->JobStudentReport_model->getBranchwiseCount(
            $institu, 
            $branches, 
            $classes,  // NEW
            $natures,  // NEW
            $year, 
            $startDate, 
            $endDate
        );
        echo json_encode($result);
    }

    // ✅ UPDATED: Added class and nature filters
    public function getBranchDetails()
    {
        $branch_id = $this->input->post('branch_id');
        $institu   = $this->input->post('fk_institu');
        $classes   = $this->input->post('classes'); // NEW
        $natures   = $this->input->post('natures'); // NEW
        $year      = $this->input->post('year');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');
    
        $result = $this->JobStudentReport_model->getBranchDetailsData(
            $branch_id, 
            $institu, 
            $classes,  // NEW
            $natures,  // NEW
            $year, 
            $startDate, 
            $endDate
        );
        echo json_encode($result);
    }

    // ✅ UPDATED: Added class and nature filters
    public function getCombinedData()
    {
        $institu   = $this->input->post('fk_institu');
        $branches  = $this->input->post('branches');
        $classes   = $this->input->post('classes'); // NEW
        $natures   = $this->input->post('natures'); // NEW
        $years     = $this->input->post('years');
        $startDate = $this->input->post('StartDate');
        $endDate   = $this->input->post('EndDate');
    
        $result = $this->JobStudentReport_model->getCombinedData(
            $institu, 
            $branches, 
            $classes,  // NEW
            $natures,  // NEW
            $years, 
            $startDate, 
            $endDate
        );
    
        echo json_encode([
            "status"      => "success",
            "branchData"  => $result['branchData'],
            "yearData"    => $result['yearData']
        ]);
    }
}
?>