<?php
if(!defined('BASEPATH')) exit('No direct script access allowed');
class MenuLogin extends CI_Controller{

	public function __construct(){
		
		parent::__construct();		
		
		$this->load->model(['MenuLogin_model']);
		$this->load->helper(['form', 'url']);
			
	} 

	public function index(){
		// $this->load->view('common/header_view');
		$this->load->view('admin/MenuLogin_view');
		// $this->load->view('common/footer_view');
	
	}

	public function login_validation()
	{
		$this->load->library('form_validation');
		$this->form_validation->set_rules('userName', 'Username', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

		if ($this->form_validation->run() == TRUE) {
			$userName = $this->input->post('userName');
			$password = $this->input->post('password');

			// ✅ Database login
			$data = $this->MenuLogin_model->can_login($userName, $password);

			if (!empty($data)) {
				$session_data = array(
					'userName' => $data[0]->UserName,
					'Password' => $data[0]->Password,
					'userID' => $data[0]->UserID,
					'fkfaculty_ID' => $data[0]->fkfaculty_ID, 
					'fkRole_id' => $data[0]->fkRole_id,
					'fkBranch_Id' => $data[0]->fkBranch_Id,
					'branch_name' => $data[0]->branch_name,
				);
				$this->session->set_userdata($session_data);

				redirect('admin/Getlink/create');
			} else {
				// Set error message and reload the login page
				$this->session->set_flashdata('error', 'Invalid username or password');
				redirect('admin/MenuLogin');
			}
		} else {
			// Validation failed, reload login page with validation errors
			$this->index();
		}
	}
	
	public function logout()
{
    
    $userId = $this->session->userdata('userID');
    
    
    $this->session->unset_userdata('userName');
    $this->session->unset_userdata('Password');
    $this->session->unset_userdata('userID');
    $this->session->unset_userdata('fkfaculty_ID');
    $this->session->unset_userdata('fkRole_id');
     
    $this->session->sess_destroy();
     
    // $this->session->unset_tempdata();
     
    redirect('admin/MenuLogin');
}

}