<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class MiniAdd extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('MiniAdd_model');
          $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    // Load Import View
    public function create()
    {
        $data['branchList'] = $this->MiniAdd_model->get_all_Branch();
        $data['yearList'] = $this->MiniAdd_model->getyear();
        $data['projectTypeList'] = $this->MiniAdd_model->getMini();
        $data['classList'] = $this->MiniAdd_model->getclass();
        $data['divisionList'] = $this->MiniAdd_model->getdiv();
        $data['rankList'] = $this->MiniAdd_model->getrank();
        $data['sponsorList'] = $this->MiniAdd_model->gettype();
        $data['studentList'] = $this->MiniAdd_model->getstudent();

// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/MiniAdd_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Edit existing project
    public function update($project_id = null)
    {
        if (!$project_id) {
            redirect('admin/MiniAdd/index');
            return;
        }

        // Get main data and child data
        $data['mainData'] = $this->MiniAdd_model->getMainDataByProjectId($project_id);
        $data['childData'] = $this->MiniAdd_model->getChildDataByProjectId($project_id);
        $data['branchList'] = $this->MiniAdd_model->get_all_Branch();
        $data['yearList'] = $this->MiniAdd_model->getyear();
        $data['projectTypeList'] = $this->MiniAdd_model->getMini();
        $data['classList'] = $this->MiniAdd_model->getclass();
        $data['divisionList'] = $this->MiniAdd_model->getdiv();
        $data['rankList'] = $this->MiniAdd_model->getrank();
        $data['sponsorList'] = $this->MiniAdd_model->gettype();
        $data['studentList'] = $this->MiniAdd_model->getstudent();

$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/MiniAdd_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->MiniAdd_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Mini_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/MiniProject_dash_view');
        $this->load->view('admin/footer_view');
    }

    public function Report()
	{
    //   $data['alldata']=$this->MiniAdd_model->getdetailview();
$data['institutedata'] = $this->MiniAdd_model->get_all_institute();
 $data['Branch'] = $this->MiniAdd_model->get_all_Branch();
    $data['branchdata'] = $this->MiniAdd_model->getbranch();   
$data['yeardata'] = $this->MiniAdd_model->getyear();
$data['guidenamedata'] = $this->MiniAdd_model->getGuideNames();
$data['projectTitledata'] = $this->MiniAdd_model->getProjectTitles();
        $data['projectTypeList'] = $this->MiniAdd_model->getMini();

 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/MiniReport',$data);
		$this->load->view('admin/footer_view');

	}

    // ============================================================
    // INSERT MINI PROJECT
    // ============================================================
    public function insertMiniProject()
    {
        try {
            $this->output->set_content_type('application/json');
            
            $posted_data = $this->input->post();
            log_message('debug', 'Mini Project Posted Data: ' . print_r($posted_data, true));

            // Get values from dropdowns - THESE ARE REQUIRED
            $mainProjectType = $posted_data['ProjectType'] ?? '';
            $mainSelectedYear = $posted_data['FiniYear'] ?? '';
            $mainBranchId = $posted_data['BranchID'] ?? '';
$fk_submenuId = $this->input->post('fk_submenuId') ?? '';

            // Validate required values
            if (empty($mainProjectType) || empty($mainSelectedYear) || empty($mainBranchId)) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'Please select Project Type, Academic Year, and Branch/Department'
                ]);
                return;
            }

            // Insert Project Records directly
            $insertCount = 0;
            $errors = [];

            if (!empty($posted_data['project_title']) && is_array($posted_data['project_title'])) {
                $count = count($posted_data['project_title']);

                for ($i = 0; $i < $count; $i++) {
                    if (empty(trim($posted_data['project_title'][$i]))) {
                        continue;
                    }

                    $projectData = [
                        'fkBranch_id'     => $mainBranchId,
                        'FiniYear'        => $mainSelectedYear,
                        'project_title'   => trim($posted_data['project_title'][$i]),
                        'guide_name'      => !empty($posted_data['guide_name'][$i]) ? trim($posted_data['guide_name'][$i]) : null,
                        'rank'            => !empty($posted_data['rank'][$i]) ? $posted_data['rank'][$i] : null,
                        'fk_sponser'      => !empty($posted_data['fk_sponser'][$i]) ? $posted_data['fk_sponser'][$i] : null,
                        'ProjectType'     => $mainProjectType,
                        'fk_institu'      => $this->session->userdata('institute_id') ?? 1,
                        'group_no'        => !empty($posted_data['group_no'][$i]) ? trim($posted_data['group_no'][$i]) : null,
                        'roll_no'         => !empty($posted_data['roll_no'][$i]) ? trim($posted_data['roll_no'][$i]) : null,
                        'student_name'    => !empty($posted_data['student_name'][$i]) ? $posted_data['student_name'][$i] : null,
                        'prn'             => !empty($posted_data['prn'][$i]) ? trim($posted_data['prn'][$i]) : '',
                        'class'           => !empty($posted_data['class'][$i]) ? $posted_data['class'][$i] : null,
                        'division'        => !empty($posted_data['division'][$i]) ? $posted_data['division'][$i] : null,
                        'excel_upload_id' => null,
                        'created_by'=>$_SESSION['userID']
                    ];

                    log_message('debug', 'Project Data Row ' . ($i + 1) . ': ' . print_r($projectData, true));

                    if ($this->db->insert('miniproject_master', $projectData)) {
                        
                          $inserted_id = $this->db->insert_id();
 
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $inserted_id;
        $excel_name = null;
        $Fk_branch = $mainBranchId;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
       
                        
                        
                        $insertCount++;
                    } else {
                        $db_error = $this->db->error();
                        $errors[] = "Row " . ($i + 1) . " failed to insert. DB Error: " . $db_error['message'];
                    }
                }
            }

            if ($insertCount > 0) {
                $message = "Successfully saved {$insertCount} project(s)";

                if (!empty($errors)) {
                    $message .= ". Some errors occurred: " . implode(", ", $errors);
                }

                echo json_encode([
                    'status' => 'success',
                    'message' => $message
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'No valid records to save. ' . implode(", ", $errors)
                ]);
            }
            
            

        } catch (Exception $e) {
            log_message('error', 'Mini Project insert error: ' . $e->getMessage());
            echo json_encode([
                'status' => 'error',
                'message' => 'Server error: ' . $e->getMessage()
            ]);
        }
    }

    // ============================================================
    // UPDATE MINI PROJECT
    // ============================================================
    public function updateMiniProject()
    {
        try {
            $this->output->set_content_type('application/json');
            
            $posted_data = $this->input->post();
            log_message('debug', 'Update Posted Data: ' . print_r($posted_data, true));

            // Get values from dropdowns - THESE ARE REQUIRED
            $mainProjectType = $posted_data['ProjectType'] ?? '';
            $mainSelectedYear = $posted_data['FiniYear'] ?? '';
            $mainBranchId = $posted_data['BranchID'] ?? '';
$fk_submenuId = $this->input->post('fk_submenuId') ?? '';

            if (empty($mainProjectType) || empty($mainSelectedYear) || empty($mainBranchId)) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'Please select Project Type, Academic Year, and Branch/Department'
                ]);
                return;
            }

            // Process project records
            $updateCount = 0;
            $insertCount = 0;
            $errors = [];

            if (!empty($posted_data['project_title']) && is_array($posted_data['project_title'])) {
                $count = count($posted_data['project_title']);

                for ($i = 0; $i < $count; $i++) {
                    if (empty(trim($posted_data['project_title'][$i]))) {
                        continue;
                    }

                    $projectData = [
                        'fkBranch_id'     => $mainBranchId,
                        'FiniYear'        => $mainSelectedYear,
                        'project_title'   => trim($posted_data['project_title'][$i]),
                        'guide_name'      => !empty($posted_data['guide_name'][$i]) ? trim($posted_data['guide_name'][$i]) : null,
                        'rank'            => !empty($posted_data['rank'][$i]) ? $posted_data['rank'][$i] : null,
                        'fk_sponser'      => !empty($posted_data['fk_sponser'][$i]) ? $posted_data['fk_sponser'][$i] : null,
                        'ProjectType'     => $mainProjectType,
                        'fk_institu'      => $this->session->userdata('institute_id') ?? 1,
                        'group_no'        => !empty($posted_data['group_no'][$i]) ? trim($posted_data['group_no'][$i]) : null,
                        'roll_no'         => !empty($posted_data['roll_no'][$i]) ? trim($posted_data['roll_no'][$i]) : null,
                        'student_name'    => !empty($posted_data['student_name'][$i]) ? $posted_data['student_name'][$i] : null,
                        'prn'             => !empty($posted_data['prn'][$i]) ? trim($posted_data['prn'][$i]) : '',
                        'class'           => !empty($posted_data['class'][$i]) ? $posted_data['class'][$i] : null,
                        'division'        => !empty($posted_data['division'][$i]) ? $posted_data['division'][$i] : null,
                        'excel_upload_id' => null,
                        'modified_by'=>$_SESSION['userID']
                    ];

                    // Check if this is update or insert
                    $projectId = $posted_data['project_id'][$i] ?? '';

                    if (!empty($projectId) && is_numeric($projectId)) {
                        // Update existing record
                        $this->db->where('project_id', $projectId);
                        if ($this->db->update('miniproject_master', $projectData)) {
                            $updateCount++;
                            log_message('debug', 'Updated project_id: ' . $projectId);
                            
                            // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $projectId;
        $excel_name = null;
        $Fk_branch = $mainBranchId;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
                            
                            
                        } else {
                            $db_error = $this->db->error();
                            $errors[] = "Row " . ($i + 1) . " failed to update. DB Error: " . $db_error['message'];
                        }
                    } else {
                        // Insert new record
                        if ($this->db->insert('miniproject_master', $projectData)) {
                            $insertCount++;
                            log_message('debug', 'Inserted new project at row: ' . ($i + 1));
                        } else {
                            $db_error = $this->db->error();
                            $errors[] = "Row " . ($i + 1) . " failed to insert. DB Error: " . $db_error['message'];
                        }
                    }
                }
            }

            $totalProcessed = $updateCount + $insertCount;

            if ($totalProcessed > 0) {
                $message = "Successfully processed {$totalProcessed} record(s)";
                if ($updateCount > 0) {
                    $message .= " (Updated: {$updateCount})";
                }
                if ($insertCount > 0) {
                    $message .= " (Inserted: {$insertCount})";
                }

                if (!empty($errors)) {
                    $message .= ". Some errors occurred: " . implode(", ", $errors);
                }

                echo json_encode([
                    'status' => 'success',
                    'message' => $message
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'No records were processed. ' . implode(", ", $errors)
                ]);
            }

        } catch (Exception $e) {
            log_message('error', 'Mini Project update error: ' . $e->getMessage());
            echo json_encode([
                'status' => 'error',
                'message' => 'Server error: ' . $e->getMessage()
            ]);
        }
    }

    // ============================================================
    // DELETE SINGLE PROJECT
    // ============================================================
    public function deleteProject()
    {
        try {
            $this->output->set_content_type('application/json');
            
            $project_id = $this->input->post('project_id');
            
            if (empty($project_id)) {
                echo json_encode(['status' => 'error', 'message' => 'Project ID not provided']);
                return;
            }

            $this->db->where('project_id', $project_id);
            if ($this->db->delete('miniproject_master')) {
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Project deleted successfully'
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to delete project'
                ]);
            }

        } catch (Exception $e) {
            log_message('error', 'Delete project error: ' . $e->getMessage());
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to delete project: ' . $e->getMessage()
            ]);
        }
    }

    // report code

    public function showDataByInstitute()
{
    $institute_id    = $this->input->post('InstituteId');
        $MiMe_IDs    = $this->input->post('ProjectType');
    $branches        = $this->input->post('fkbranch_id');  
    $guide_names     = $this->input->post('guide_name');
    $project_titles  = $this->input->post('project_title');
    $years  = $this->input->post('years');

    $data = $this->MiniAdd_model->getDataByInstitute(
        $institute_id,
        $MiMe_IDs,
        $branches,
        $guide_names,
        $project_titles,
        $years
    );

    echo json_encode($data);
}

public function getStudentsByProject()
{
    $project_id = $this->input->post('project_id');
    $students = $this->MiniAdd_model->getStudentsByProject($project_id);
    echo json_encode($students);
}

public function getPrintHeadings()
{
    $data = $this->MiniAdd_model->getPrintHeadings();
    echo json_encode($data);
}


public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu'); 
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    // $startDate = $this->input->post('StartDate');
    // $endDate   = $this->input->post('EndDate');

    $result = $this->MiniAdd_model->getCombinedData($institu, $branches, $years);

    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}


public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id');
    $institu   = $this->input->post('fk_institu');
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    // Debug
    if (!$branch_id) {
        die(json_encode(['error' => 'Branch ID missing']));
    }

    try {
        $result = $this->MiniAdd_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
        echo json_encode($result);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
    }
}

public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // may be an array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->MiniAdd_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->MiniAdd_model->getSingleYearData($year, $institu, $branches, $startDate, $endDate);
        $types   = $this->MiniAdd_model->getYearwiseTypes($year, $institu, $branches, $startDate, $endDate);
    }

    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}


}
?>