<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mou extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Mou_model');
        $this->load->library('upload');
               $this->load->model('Log_model');
        $this->load->helper('log'); // Load upload library in constructor

        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function index()
    {
        $data['alldata'] = $this->Mou_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Mou_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Mou_dash_view');
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['durationdata'] = $this->Mou_model->getduration();
        $data['yeardata'] = $this->Mou_model->getyear();
        $data['branchdata'] = $this->Mou_model->getbranch();

        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Mou_view', $data);
        $this->load->view('admin/footer_view');
    }

public function insertMou()
{
    // ----------- Get form data -----------
    $Indu_Name     = $this->input->post('Indu_Name');
    $SignDate      = $this->input->post('SignDate');
    $StartDate     = $this->input->post('StartDate');
    $EndDate       = $this->input->post('EndDate');
    $fkDuration_id = $this->input->post('fkDuration_id');
    $Suggestion    = $this->input->post('Suggestion');
    $fkYear_id     = $this->input->post('fkYear_id');
    $Branch_id     = $this->input->post('Branch_id');
    $fk_submenuId  = $this->input->post('fk_submenuId');
    $fk_branch     = $Branch_id;

    // ----------- File defaults -----------
    $Certificate = '';
    $Training = '';
    $Intership = '';
    $Guest_Lec = '';
    $Industry_visit = '';
    $VAP = '';
    $Consultancy = '';

    $upload_errors = [];

    // ----------- Upload files -----------
    if (!empty($_FILES['Certificate']['name'])) {
        $r = $this->uploadFile('Certificate', 'uploads/mou/certificates/');
        $r['success'] ? $Certificate = $r['path'] : $upload_errors[] = $r['error'];
    }

    if (!empty($_FILES['Training']['name'])) {
        $r = $this->uploadFile('Training', 'uploads/mou/training/');
        $r['success'] ? $Training = $r['path'] : $upload_errors[] = $r['error'];
    }

    if (!empty($_FILES['Intership']['name'])) {
        $r = $this->uploadFile('Intership', 'uploads/mou/intership/');
        $r['success'] ? $Intership = $r['path'] : $upload_errors[] = $r['error'];
    }

    if (!empty($_FILES['Guest_Lec']['name'])) {
        $r = $this->uploadFile('Guest_Lec', 'uploads/mou/guestlecture/');
        $r['success'] ? $Guest_Lec = $r['path'] : $upload_errors[] = $r['error'];
    }

    if (!empty($_FILES['Industry_visit']['name'])) {
        $r = $this->uploadFile('Industry_visit', 'uploads/mou/industryvisit/');
        $r['success'] ? $Industry_visit = $r['path'] : $upload_errors[] = $r['error'];
    }

    if (!empty($_FILES['VAP']['name'])) {
        $r = $this->uploadFile('VAP', 'uploads/mou/vap/');
        $r['success'] ? $VAP = $r['path'] : $upload_errors[] = $r['error'];
    }

    if (!empty($_FILES['Consultancy']['name'])) {
        $r = $this->uploadFile('Consultancy', 'uploads/mou/consultancy/');
        $r['success'] ? $Consultancy = $r['path'] : $upload_errors[] = $r['error'];
    }

    // ----------- Prepare insert data -----------
    $fields = array(
        'Indu_Name'       => $Indu_Name,
        'SignDate'        => $SignDate,
        'StartDate'       => $StartDate,
        'EndDate'         => $EndDate,
        'fkDuration_id'   => $fkDuration_id,
        'Highlight_Detail'=> $Suggestion,
        'fkYear_id'       => $fkYear_id,
        'Branch_id'       => $Branch_id,
        'Certificate'     => $Certificate,
        'Training'        => $Training,
        'Intership'       => $Intership,
        'Guest_Lec'       => $Guest_Lec,
        'Industry_visit'  => $Industry_visit,
        'VAP'             => $VAP,
        'Consultancy'     => $Consultancy,
        'created_by'      => $_SESSION['userID']
    );

    // ----------- INSERT DATA -----------
    $this->Mou_model->insertdata($fields);
    $mou_id = $this->db->insert_id();

    // ----------- INSERT LOG (THIS IS THE RIGHT PLACE) -----------
    $action     = 1; // 1 = Insert
    $record_id = $mou_id;
    $excel_name = null;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $fk_branch,
        $_SESSION['userID']
    );

    // ----------- Gallery Upload -----------
    $gallery_result = $this->uploadGallery($mou_id);

    // ----------- Response -----------
    echo json_encode([
        'status' => 'success',
        'message' => 'MOU created successfully',
        'upload_errors' => $upload_errors,
        'gallery_errors' => $gallery_result['errors']
    ]);
}

    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Mou_model->getbyid($id);
        $data['durationdata'] = $this->Mou_model->getduration();
        $data['yeardata'] = $this->Mou_model->getyear();
        $data['branchdata'] = $this->Mou_model->getbranch();
        $data['selectedGallary'] = $this->Mou_model->getAwardGallery($id);

        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Mou_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function updateMou()
    {
        // Get form data
        $mou_id = $this->input->post('mou_id');
        $Indu_Name = $this->input->post('Indu_Name');
        $SignDate = $this->input->post('SignDate');
        $StartDate = $this->input->post('StartDate');
        $EndDate = $this->input->post('EndDate');
        $fkDuration_id = $this->input->post('fkDuration_id');
        $Suggestion = $this->input->post('Suggestion');
        $fkYear_id = $this->input->post('fkYear_id');
        $Branch_id = $this->input->post('Branch_id');

        // Initialize file paths with existing values from hidden fields
        $Certificate = $this->input->post('hidden_certificate');
        $Training = $this->input->post('hidden_training');
        $Intership = $this->input->post('hidden_intership');
        $Guest_Lec = $this->input->post('hidden_guestlec');
        $Industry_visit = $this->input->post('hidden_industryvisit');
        $VAP = $this->input->post('hidden_vap');
        $Consultancy = $this->input->post('hidden_consultancy');
        $fk_submenuId = $this->input->post('fk_submenuId');
 

        // Track upload errors
        $upload_errors = [];

        // Handle Certificate Upload
        if (!empty($_FILES['Certificate']['name'])) {
            $result = $this->uploadFile('Certificate', 'uploads/mou/certificates/');
            if ($result['success']) {
                // Delete old file if exists
                if (!empty($Certificate) && file_exists(FCPATH . $Certificate)) {
                    unlink(FCPATH . $Certificate);
                }
                $Certificate = $result['path'];
            } else {
                $upload_errors[] = 'Certificate: ' . $result['error'];
            }
        }

        // Handle Training Upload
        if (!empty($_FILES['Training']['name'])) {
            $result = $this->uploadFile('Training', 'uploads/mou/training/');
            if ($result['success']) {
                if (!empty($Training) && file_exists(FCPATH . $Training)) {
                    unlink(FCPATH . $Training);
                }
                $Training = $result['path'];
            } else {
                $upload_errors[] = 'Training: ' . $result['error'];
            }
        }

        // Handle Intership Upload
        if (!empty($_FILES['Intership']['name'])) {
            $result = $this->uploadFile('Intership', 'uploads/mou/intership/');
            if ($result['success']) {
                if (!empty($Intership) && file_exists(FCPATH . $Intership)) {
                    unlink(FCPATH . $Intership);
                }
                $Intership = $result['path'];
            } else {
                $upload_errors[] = 'Intership: ' . $result['error'];
            }
        }

        // Handle Guest_Lec Upload
        if (!empty($_FILES['Guest_Lec']['name'])) {
            $result = $this->uploadFile('Guest_Lec', 'uploads/mou/guestlecture/');
            if ($result['success']) {
                if (!empty($Guest_Lec) && file_exists(FCPATH . $Guest_Lec)) {
                    unlink(FCPATH . $Guest_Lec);
                }
                $Guest_Lec = $result['path'];
            } else {
                $upload_errors[] = 'Guest Lecture: ' . $result['error'];
            }
        }

        // Handle Industry_visit Upload
        if (!empty($_FILES['Industry_visit']['name'])) {
            $result = $this->uploadFile('Industry_visit', 'uploads/mou/industryvisit/');
            if ($result['success']) {
                if (!empty($Industry_visit) && file_exists(FCPATH . $Industry_visit)) {
                    unlink(FCPATH . $Industry_visit);
                }
                $Industry_visit = $result['path'];
            } else {
                $upload_errors[] = 'Industry Visit: ' . $result['error'];
            }
        }

        // Handle VAP Upload
        if (!empty($_FILES['VAP']['name'])) {
            $result = $this->uploadFile('VAP', 'uploads/mou/vap/');
            if ($result['success']) {
                if (!empty($VAP) && file_exists(FCPATH . $VAP)) {
                    unlink(FCPATH . $VAP);
                }
                $VAP = $result['path'];
            } else {
                $upload_errors[] = 'VAP: ' . $result['error'];
            }
        }

        // Handle Consultancy Upload
        if (!empty($_FILES['Consultancy']['name'])) {
            $result = $this->uploadFile('Consultancy', 'uploads/mou/consultancy/');
            if ($result['success']) {
                if (!empty($Consultancy) && file_exists(FCPATH . $Consultancy)) {
                    unlink(FCPATH . $Consultancy);
                }
                $Consultancy = $result['path'];
            } else {
                $upload_errors[] = 'Consultancy: ' . $result['error'];
            }
        }

        // Handle removed gallery photos
        $removed_photos = $this->input->post('removed_photos');
        if (!empty($removed_photos)) {
            $removed_photos_array = explode(',', $removed_photos);
            $this->Mou_model->deleteExistingPhotos($mou_id, $removed_photos_array);

            // Delete physical files
            foreach ($removed_photos_array as $photo) {
                $file_path = FCPATH . $photo;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
        }

        // Prepare data for update
        $fields = array(
            'mou_id' => $mou_id,
            'Indu_Name' => $Indu_Name,
            'SignDate' => $SignDate,
            'StartDate' => $StartDate,
            'EndDate' => $EndDate,
            'fkDuration_id' => $fkDuration_id,
            'Highlight_Detail' => $Suggestion,
            'fkYear_id' => $fkYear_id,
            'Branch_id' => $Branch_id,
            'Certificate' => $Certificate,
            'Training' => $Training,
            'Intership' => $Intership,
            'Guest_Lec' => $Guest_Lec,
            'Industry_visit' => $Industry_visit,
            'VAP' => $VAP,
            'Consultancy' => $Consultancy,
            'modified_by'=>$_SESSION['userID']
        );

        // Update MOU data
        $this->Mou_model->update($fields);
        // ----------- INSERT LOG (UPDATE ACTION) -----------
$action      = 2;              // 2 = Update
$record_id  = $mou_id;         // Updated record ID
$excel_name = null;
$fk_branch  = $Branch_id;

insert_log(
    $this,
    $fk_submenuId,
    $action,
    $record_id,
    $excel_name,
    $fk_branch,
    $_SESSION['userID']
);


        // Handle new Award Gallery uploads
        $gallery_result = $this->uploadGallery($mou_id);

        echo json_encode([
            'status' => 'success',
            'message' => 'MOU updated successfully',
            'upload_errors' => $upload_errors,
            'gallery_errors' => $gallery_result['errors'],
            'data' => $fields
        ]);
    }

    // Helper function to upload single file - IMPROVED VERSION
    private function uploadFile($field_name, $upload_path)
    {
        // Check if file was actually uploaded
        if (!isset($_FILES[$field_name]) || $_FILES[$field_name]['error'] === UPLOAD_ERR_NO_FILE) {
            return [
                'success' => false,
                'error' => 'No file uploaded',
                'path' => null
            ];
        }

        // Check for upload errors
        if ($_FILES[$field_name]['error'] !== UPLOAD_ERR_OK) {
            $error_messages = [
                UPLOAD_ERR_INI_SIZE => 'File exceeds upload_max_filesize',
                UPLOAD_ERR_FORM_SIZE => 'File exceeds MAX_FILE_SIZE',
                UPLOAD_ERR_PARTIAL => 'File was only partially uploaded',
                UPLOAD_ERR_NO_TMP_DIR => 'Missing temporary folder',
                UPLOAD_ERR_CANT_WRITE => 'Failed to write file to disk',
                UPLOAD_ERR_EXTENSION => 'Upload stopped by extension'
            ];
            
            return [
                'success' => false,
                'error' => $error_messages[$_FILES[$field_name]['error']] ?? 'Unknown upload error',
                'path' => null
            ];
        }

        $full_path = FCPATH . $upload_path;

        // Create directory if it doesn't exist
        if (!is_dir($full_path)) {
            if (!mkdir($full_path, 0755, true)) {
                log_message('error', "Failed to create directory: {$full_path}");
                return [
                    'success' => false,
                    'error' => 'Failed to create upload directory',
                    'path' => null
                ];
            }
        }

        // Check if directory is writable
        if (!is_writable($full_path)) {
            log_message('error', "Directory not writable: {$full_path}");
            return [
                'success' => false,
                'error' => 'Upload directory is not writable',
                'path' => null
            ];
        }

        $config['upload_path'] = $full_path;
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = FALSE; // Don't encrypt, use custom name
        $config['file_name'] = time() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '', $_FILES[$field_name]['name']);

        $this->upload->initialize($config);

        if ($this->upload->do_upload($field_name)) {
            $uploadData = $this->upload->data();
            $file_path = $upload_path . $uploadData['file_name'];
            
            // Verify the file actually exists
            if (!file_exists(FCPATH . $file_path)) {
                log_message('error', "File upload reported success but file not found: " . FCPATH . $file_path);
                return [
                    'success' => false,
                    'error' => 'File upload verification failed',
                    'path' => null
                ];
            }
            
            return [
                'success' => true,
                'error' => null,
                'path' => $file_path
            ];
        } else {
            $error = $this->upload->display_errors('', '');
            log_message('error', "Upload failed for {$field_name}: {$error}");
            return [
                'success' => false,
                'error' => $error,
                'path' => null
            ];
        }
    }

    // Helper function to upload gallery images - IMPROVED VERSION
    private function uploadGallery($mou_id)
    {
        $errors = [];
        $success_count = 0;
        
        if (empty($_FILES['AwardGallery']['name'][0])) {
            return ['errors' => [], 'success_count' => 0];
        }

        $filesCount = count($_FILES['AwardGallery']['name']);

        for ($i = 0; $i < $filesCount; $i++) {
            // Skip if no file
            if (empty($_FILES['AwardGallery']['name'][$i])) {
                continue;
            }

            $_FILES['file']['name'] = $_FILES['AwardGallery']['name'][$i];
            $_FILES['file']['type'] = $_FILES['AwardGallery']['type'][$i];
            $_FILES['file']['tmp_name'] = $_FILES['AwardGallery']['tmp_name'][$i];
            $_FILES['file']['error'] = $_FILES['AwardGallery']['error'][$i];
            $_FILES['file']['size'] = $_FILES['AwardGallery']['size'][$i];

            $upload_path = FCPATH . 'uploads/mou/gallery/';

            // Create directory if it doesn't exist
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0755, true);
            }

            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
            $config['max_size'] = 5120;
            $config['file_name'] = uniqid() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '', $_FILES['file']['name']);

            $this->upload->initialize($config);

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $filePath = 'uploads/mou/gallery/' . $uploadData['file_name'];

                // Verify file exists
                if (file_exists(FCPATH . $filePath)) {
                    // Use model method to insert gallery data
                    $this->Mou_model->insertGallery([
                        'fkAward_id' => $mou_id,
                        'file_path' => $filePath
                    ]);
                    $success_count++;
                } else {
                    $errors[] = "File {$_FILES['file']['name']} upload verification failed";
                    log_message('error', "Gallery file not found after upload: " . FCPATH . $filePath);
                }
            } else {
                $error = $this->upload->display_errors('', '');
                $errors[] = "File {$_FILES['file']['name']}: {$error}";
                log_message('error', "Gallery upload error: {$error}");
            }
        }

        return [
            'errors' => $errors,
            'success_count' => $success_count
        ];
    }

    // Report page
    public function Report()
    {
        $data['Branch'] = $this->Mou_model->getbranch();
        $data['branchdata'] = $this->Mou_model->getbranch();
        $data['yeardata'] = $this->Mou_model->getyear();
        
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
     
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/MouReport_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Show filtered data
    public function showDataByFilters()
    {
        $branch_ids = $this->input->post('fkbranch_id');
        $year_id = $this->input->post('year');
        $startdate = $this->input->post('startdate');
        $enddate = $this->input->post('enddate');

        $data = $this->Mou_model->showDataByFilters($branch_ids, $year_id, $startdate, $enddate);
        echo json_encode($data);
    }

    // Get combined chart data (branch + year)
    // public function getCombinedData()
    // {
    //     $branch_ids = $this->input->post('branches');
    //     $year_ids = $this->input->post('years');
    //     $startdate = $this->input->post('StartDate');
    //     $enddate = $this->input->post('EndDate');

    //     // Get branch-wise data
    //     $branchData = $this->Mou_model->getBranchWiseData($year_ids, $startdate, $enddate);
        
    //     // Get year-wise data
    //     $yearData = $this->Mou_model->getYearWiseData($branch_ids, $startdate, $enddate);

    //     echo json_encode([
    //         'status' => 'success',
    //         'branchData' => $branchData,
    //         'yearData' => $yearData
    //     ]);
    // }

// Replace these methods in your Mou.php controller

// Get combined chart data (branch + year)
public function getCombinedData()
{
    $branch_ids = $this->input->post('branches');
    $year_ids = $this->input->post('years');
    $startdate = $this->input->post('StartDate');
    $enddate = $this->input->post('EndDate');

    // Ensure arrays are not empty or null
    $branch_ids = !empty($branch_ids) && is_array($branch_ids) ? $branch_ids : [];
    $year_ids = !empty($year_ids) && is_array($year_ids) ? $year_ids : [];

    // Get branch-wise data with ALL filters
    $branchData = $this->Mou_model->getBranchWiseData($branch_ids, $year_ids, $startdate, $enddate);
    
    // Get year-wise data with ALL filters
    $yearData = $this->Mou_model->getYearWiseData($branch_ids, $year_ids, $startdate, $enddate);

    echo json_encode([
        'status' => 'success',
        'branchData' => $branchData,
        'yearData' => $yearData,
        'debug' => [
            'branch_ids' => $branch_ids,
            'year_ids' => $year_ids,
            'startdate' => $startdate,
            'enddate' => $enddate,
            'branch_count' => count($branchData),
            'year_count' => count($yearData)
        ]
    ]);
}

// Get branch details for drill-down
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id');
    $year_ids = $this->input->post('year');
    $startdate = $this->input->post('StartDate');
    $enddate = $this->input->post('EndDate');

    // Ensure arrays
    $year_ids = !empty($year_ids) && is_array($year_ids) ? $year_ids : [];

    // When drilling down into a branch, apply the year filter
    $data = $this->Mou_model->getBranchDetails($branch_id, [], $year_ids, $startdate, $enddate);
    
    echo json_encode($data);
}

// Get year details for drill-down
public function getYearwiseData()
{
    $year_id = $this->input->post('year');
    $branch_ids = $this->input->post('branches');
    $startdate = $this->input->post('StartDate');
    $enddate = $this->input->post('EndDate');

    // Ensure arrays
    $branch_ids = !empty($branch_ids) && is_array($branch_ids) ? $branch_ids : [];

    if ($year_id == "0" || empty($year_id)) {
        // Get all years summary - shouldn't happen in normal flow
        $types = [];
    } else {
        // Get specific year details - apply the branch filter
        $types = $this->Mou_model->getYearDetails($year_id, $branch_ids, [], $startdate, $enddate);
    }

    echo json_encode([
        "status" => "success",
        "types" => $types
    ]);
}
    // // Get branch details for drill-down
    // public function getBranchDetails()
    // {
    //     $branch_id = $this->input->post('branch_id');
    //     $year_ids = $this->input->post('year');
    //     $startdate = $this->input->post('StartDate');
    //     $enddate = $this->input->post('EndDate');

    //     $data = $this->Mou_model->getBranchDetails($branch_id, $year_ids, $startdate, $enddate);
    //     echo json_encode($data);
    // }

//     public function getBranchDetails()
// {
//     $branch_id = $this->input->post('branch_id');
//     $year_ids = $this->input->post('year');
//     $startdate = $this->input->post('StartDate');
//     $enddate = $this->input->post('EndDate');

//     // Ensure arrays
//     $year_ids = !empty($year_ids) ? $year_ids : [];

//     // When drilling down into a branch, apply the year filter
//     $data = $this->Mou_model->getBranchDetails($branch_id, [], $year_ids, $startdate, $enddate);
//     echo json_encode($data);
// }

    // Get year details for drill-down
    // public function getYearwiseData()
    // {
    //     $year_id = $this->input->post('year');
    //     $branch_ids = $this->input->post('branches');
    //     $startdate = $this->input->post('StartDate');
    //     $enddate = $this->input->post('EndDate');

    //     if ($year_id == "0" || empty($year_id)) {
    //         // Get all years summary
    //         $summary = $this->Mou_model->getYearWiseData($branch_ids, $startdate, $enddate);
    //         $types = [];
    //     } else {
    //         // Get specific year summary and details
    //         $summary = $this->Mou_model->getYearWiseData($branch_ids, $startdate, $enddate);
    //         $types = $this->Mou_model->getYearDetails($year_id, $branch_ids, $startdate, $enddate);
    //     }

    //     echo json_encode([
    //         "status" => "success",
    //         "summary" => $summary,
    //         "types" => $types
    //     ]);
    // }

//     public function getYearwiseData()
// {
//     $year_id = $this->input->post('year');
//     $branch_ids = $this->input->post('branches');
//     $startdate = $this->input->post('StartDate');
//     $enddate = $this->input->post('EndDate');

//     // Ensure arrays
//     $branch_ids = !empty($branch_ids) ? $branch_ids : [];

//     if ($year_id == "0" || empty($year_id)) {
//         // Get all years summary
//         $summary = $this->Mou_model->getYearWiseData($branch_ids, [], $startdate, $enddate);
//         $types = [];
//     } else {
//         // Get specific year details - apply the branch filter
//         $types = $this->Mou_model->getYearDetails($year_id, $branch_ids, [], $startdate, $enddate);
//         $summary = [];
//     }

//     echo json_encode([
//         "status" => "success",
//         "summary" => $summary,
//         "types" => $types
//     ]);
// }

    // Get print headings
    public function getPrintHeadings()
    {
        $data = $this->Mou_model->getPrintHeadings();
        echo json_encode($data);
    }

    // DEBUG FUNCTION - Remove after testing
    public function checkDirectories()
    {
        $directories = [
            'uploads/mou/certificates/',
            'uploads/mou/training/',
            'uploads/mou/intership/',
            'uploads/mou/guestlecture/',
            'uploads/mou/industryvisit/',
            'uploads/mou/vap/',
            'uploads/mou/consultancy/',
            'uploads/mou/gallery/'
        ];

        $status = [];
        foreach ($directories as $dir) {
            $full_path = FCPATH . $dir;
            $status[$dir] = [
                'exists' => is_dir($full_path),
                'writable' => is_writable($full_path),
                'path' => $full_path
            ];
        }

        echo '<pre>';
        print_r($status);
        echo '</pre>';
    }
}