<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class NPTL extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('NPTL_model');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/NPTL_dash_view.php');
        $this->load->view('admin/footer_view');
    }
   
    public function index()
    {
        $data['alldata'] = $this->NPTL_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/NPTL_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['durationdata'] = $this->NPTL_model->getduration();
        $data['yeardata'] = $this->NPTL_model->getyear();
        $data['activeYear'] = $this->NPTL_model->getActiveYear();
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/NPTL_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function insert()
    {
        $fk_submenuId = $this->input->post('fk_submenuId');
        // Get main form data
        $mainData = array(
            'Domain_branch' => $this->input->post('Domain_branch'),
            'Domain_name' => $this->input->post('Domain_name'),
            'Faculty_name' => $this->input->post('Faculty_name'),
            'Faculty_id' => $this->input->post('Faculty_id'),
            'finicial_Year' => $this->input->post('finicial_Year'),
            'Date' => $this->input->post('Date'),
            'Photo_url' => $this->input->post('Photo_url'),
            'created_by'=>$_SESSION['userID']
            
        );
        
        
 $institute = $this->db
    ->select('Institu_id')
    ->from('institute_master')
    ->get()
    ->row();

if ($institute) {
    $mainData['institute'] = $institute->Institu_id;
}

        
        // Insert main data and get the ID
        $mainId = $this->NPTL_model->insertMainData($mainData);

 
        // Insert log - Action 1 (Insert)

        $action = 1;

        $record_id = $mainId;

        $excel_name = null;

        $Fk_branch = null;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        //  $sub_id = $this->db->insert_id();
 
        
        if ($mainId) {
            // Get table data
            $courseNames = $this->input->post('Course_name');
            $durationIds = $this->input->post('fkduration_id');
            $startDates = $this->input->post('StartDate');
            $endDates = $this->input->post('EndDate');
            $grades = $this->input->post('Grade');
            $yearIds = $this->input->post('fkfiniYear_id');
            

            // Process each row
            if (!empty($courseNames)) {
                foreach ($courseNames as $key => $courseName) {
                    if (!empty($courseName)) {
                        // Handle file upload for certificate
                        $certiPhoto = '';
                        if (!empty($_FILES['Certi_photo']['name'][$key])) {
                            $_FILES['userfile']['name'] = $_FILES['Certi_photo']['name'][$key];
                            $_FILES['userfile']['type'] = $_FILES['Certi_photo']['type'][$key];
                            $_FILES['userfile']['tmp_name'] = $_FILES['Certi_photo']['tmp_name'][$key];
                            $_FILES['userfile']['error'] = $_FILES['Certi_photo']['error'][$key];
                            $_FILES['userfile']['size'] = $_FILES['Certi_photo']['size'][$key];
                            
                            $config['upload_path'] = './uploads/nptl/';
                            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
                            $config['max_size'] = 5120; // 5MB
                            $config['file_name'] = 'certi_' . time() . '_' . $_FILES['Certi_photo']['name'][$key];
                            
                            // Create directory if it doesn't exist
                            if (!is_dir($config['upload_path'])) {
                                mkdir($config['upload_path'], 0777, true);
                            }
                            
                            $this->upload->initialize($config);
                            
                            if ($this->upload->do_upload('userfile')) {
                                $upload_data = $this->upload->data();
                                $certiPhoto = 'uploads/nptl/' . $upload_data['file_name'];
                            }
                        }
                        
                        $childData = array(
                            'fknptlmain_id' => $mainId,
                            'Course_name' => $courseName,
                            'fkduration_id' => $durationIds[$key],
                            'StartDate' => $startDates[$key],
                            'EndDate' => $endDates[$key],
                            'Grade' => $grades[$key],
                            'Certi_photo' => $certiPhoto,
                            'fkfiniYear_id' => $yearIds[$key],
                            'created_by'=>$_SESSION['userID']
                        );
                        
                        // Insert child data
                        $this->NPTL_model->insertChildData($childData);
                    }
                }
            }
            
            echo json_encode(['success' => true, 'message' => 'Data inserted successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to insert main data']);
        }
    }
public function update()
{
    $id = $this->uri->segment(4);
    $data['data'] = $this->NPTL_model->getMainById($id); // Changed from 'mainData' to 'data'
    $data['childData'] = $this->NPTL_model->getChildByMainId($id);
    $data['durationdata'] = $this->NPTL_model->getduration();
    $data['yeardata'] = $this->NPTL_model->getyear();
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/NPTL_view', $data);
    $this->load->view('admin/footer_view');
}
    // public function update()
    // {
    //     $id = $this->uri->segment(4);
    //     $data['mainData'] = $this->NPTL_model->getMainById($id);
    //     $data['childData'] = $this->NPTL_model->getChildByMainId($id);
    //     $data['durationdata'] = $this->NPTL_model->getduration();
    //     $data['yeardata'] = $this->NPTL_model->getyear();
        
    //     $this->load->view('admin/header_view');
    //     $this->load->view('admin/NPTL_view', $data);
    //     $this->load->view('admin/footer_view');
    // }

    public function updateData()
    {
        // Get main form data
        $mainId = $this->input->post('main_NPTL_id');
        $fk_submenuId = $this->input->post('fk_submenuId');

        $mainData = array(
            'Domain_branch' => $this->input->post('Domain_branch'),
            'Domain_name' => $this->input->post('Domain_name'),
            'Faculty_name' => $this->input->post('Faculty_name'),
            'Faculty_id' => $this->input->post('Faculty_id'),
            'finicial_Year' => $this->input->post('finicial_Year'),
            'Date' => $this->input->post('Date'),
            'Photo_url' => $this->input->post('Photo_url'),
            'modified_by'=>$_SESSION['userID']
        );
        
        // Update main data
        $result = $this->NPTL_model->updateMainData($mainId, $mainData);
        // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $mainId;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);


        if ($result) {
            // Get table data
            $nptlIds = $this->input->post('NPTL_id');
            $courseNames = $this->input->post('Course_name');
            $durationIds = $this->input->post('fkduration_id');
            $startDates = $this->input->post('StartDate');
            $endDates = $this->input->post('EndDate');
            $grades = $this->input->post('Grade');
            $existingCertificates = $this->input->post('existing_Certi_photo');
            $yearIds = $this->input->post('fkfiniYear_id');
            
            // Process each row
            if (!empty($courseNames)) {
                foreach ($courseNames as $key => $courseName) {
                    if (!empty($courseName)) {
                        // Handle file upload for certificate
                        $certiPhoto = $existingCertificates[$key];
                        
                        if (!empty($_FILES['Certi_photo']['name'][$key])) {
                            $_FILES['userfile']['name'] = $_FILES['Certi_photo']['name'][$key];
                            $_FILES['userfile']['type'] = $_FILES['Certi_photo']['type'][$key];
                            $_FILES['userfile']['tmp_name'] = $_FILES['Certi_photo']['tmp_name'][$key];
                            $_FILES['userfile']['error'] = $_FILES['Certi_photo']['error'][$key];
                            $_FILES['userfile']['size'] = $_FILES['Certi_photo']['size'][$key];
                            
                            $config['upload_path'] = './uploads/nptl/';
                            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
                            $config['max_size'] = 5120;
                            $config['file_name'] = 'certi_' . time() . '_' . $_FILES['Certi_photo']['name'][$key];
                            
                            if (!is_dir($config['upload_path'])) {
                                mkdir($config['upload_path'], 0777, true);
                            }
                            
                            $this->upload->initialize($config);
                            
                            if ($this->upload->do_upload('userfile')) {
                                $upload_data = $this->upload->data();
                                $certiPhoto = 'uploads/nptl/' . $upload_data['file_name'];
                                
                                // Delete old file if exists
                                if (!empty($existingCertificates[$key]) && file_exists(FCPATH . $existingCertificates[$key])) {
                                    unlink(FCPATH . $existingCertificates[$key]);
                                }
                            }
                        }
                        
                        $childData = array(
                            'fknptlmain_id' => $mainId,
                            'Course_name' => $courseName,
                            'fkduration_id' => $durationIds[$key],
                            'StartDate' => $startDates[$key],
                            'EndDate' => $endDates[$key],
                            'Grade' => $grades[$key],
                            'Certi_photo' => $certiPhoto,
                            'fkfiniYear_id' => $yearIds[$key]
                        );
                        
                        // Check if it's an existing record or a new one
                        if (!empty($nptlIds[$key])) {
                            // Update existing record
                            $this->NPTL_model->updateChildData($nptlIds[$key], $childData);
                        } else {
                            // Insert new record
                            $this->NPTL_model->insertChildData($childData);
                        }
                    }
                }
            }
            
            echo json_encode(['success' => true, 'message' => 'Data updated successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update main data']);
        }
    }
}
?>