<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;

class NSS extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('NSS_model');
    }

    // Load Import View
    public function create()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/NSS_view');
        $this->load->view('admin/footer_view');
    }

    // Load Import View
    public function Report()
    {

        // $data['Branch'] = $this->NSS_model->getDistinctDepartments();
        $data['Act'] = $this->NSS_model->getActivity();

        $data['institutedata'] = $this->NSS_model->get_all_institute();
            //   $data['departmentdata'] = $this->NSS_model->getbranch();

//  $data['Branch'] = $this->NSS_model->get_all_Branch();
      
$data['yeardata'] = $this->NSS_model->getyear();
//  $activeYear = $this->db
//     ->select('finiYear_id')
//     ->from('finiyear_master')
//     ->where('Active_Deactive', 1)
//     ->get()
//     ->row();
 
// $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

        $this->load->view('admin/header_view');
        $this->load->view('admin/NSS_Report',$data);
        $this->load->view('admin/footer_view');
    }


public function showDataByInstitute()
{
    $institute_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $year         = $this->input->post('year');        // ✅ financial year
    $activities   = $this->input->post('NssActName');  // ✅ activities array

    $data = $this->NSS_model->getDataByInstitute(
        $institute_id,
        $startdate,
        $enddate,
        $activities,  // ✅ correct position
        $year         // ✅ pass as last argument
    );

    echo json_encode($data);
}



public function getPrintHeadings()
{
    $data = $this->NSS_model->getPrintHeadings();
    echo json_encode($data);
}



public function import_excel_save() {
      try {
        // ✅ Handle File Upload
        if (!empty($_FILES['excel_file']['name'])) {
            $uploadPath = FCPATH . 'uploads/excel/'; // C:\xampp\htdocs\NAAC\uploads\excel\
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Save with timestamp to avoid overwrite
            $fileName = 'nss_excel_' . date('Ymd_His') . '.xlsx';
            $targetFilePath = $uploadPath . $fileName;

            if (!move_uploaded_file($_FILES['excel_file']['tmp_name'], $targetFilePath)) {
                echo "error_uploading_file";
                return;
            }
        }

        // ✅ Table data handling
        $postData = $this->input->post('tableData');
        if (empty($postData)) {
            echo "no_data";
            return;
        }

        $rows = json_decode($postData, true);
        $insertData = [];
  
        // ✅ Get Institute ID (first record from institute_master)
        $institute = $this->db
            ->select('Institu_id')
            ->from('institute_master')
            ->get()
            ->row();
        $instituteId = $institute ? $institute->Institu_id : null;


        // ✅ Build year map (normalize by trimming and lowercase)
$yearMap = [];
foreach ($this->db->get_where('finiyear_master', ['is_active' => 1])->result() as $g) {
    $key = strtolower(trim($g->fini_Label));
    $yearMap[$key] = $g->finiYear_id;
}

$rowCount = 0;
foreach ($rows as $row) {
    $rowCount++;
    if ($rowCount === 1) continue; // skip header

    $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
    if ($yearStr !== '') {
        if (!isset($yearMap[$yearStr])) {
            // Insert new financial year if not found
            $this->db->insert('finiyear_master', [
                'fini_Label' => trim($row['Financial_Year']), // keep original as label
                'is_active' => 1
            ]);
            $finiYear_id = $this->db->insert_id();
            $yearMap[$yearStr] = $finiYear_id;
        } else {
            $finiYear_id = $yearMap[$yearStr];
        }
    } else {
        $finiYear_id = null;
    }

    $actDate = !empty($row['ActDate']) ? date('Y-m-d', strtotime($row['ActDate'])) : null;

    $insertData[] = [
        'NssActName'      => $row['NssActName'] ?? '',
        'PlaceOFAct'      => $row['PlaceOFAct'] ?? '',
        'SPOCName'        => $row['SPOCName'] ?? '',
        // 'Department'      => $row['Department'] ?? '',
        'Month'           => $row['Month'] ?? '',
        'ActDate'         => $actDate,
        'StudPart'        => $row['StudPart'] ?? '',
        'Report_Flag'     => $row['Report_Flag'] ?? '',
        'Report_pdf'      => null,
        'Activity_Status' => $row['Activity_Status'] ?? '',
        'Financial_Year'  => $finiYear_id,   // ✅ Now works
        'Institute_id'    => $instituteId
    ];
}


        if (!empty($insertData)) {
            $this->db->insert_batch('nss_master', $insertData);
            echo "success";
        } else {
            echo "no_data";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}


public function getYearwiseData() {
$year      = $this->input->post('year_id');
$institu   = $this->input->post('fk_institu');
// $departments = $this->input->post('departments');
$startDate = $this->input->post('StartDate');
$endDate   = $this->input->post('EndDate');


    if ($year == "0" || empty($year)) {
        $summary = $this->NSS_model->getAllYearsData($institu, $startDate, $endDate);
        $types   = [];
    } else {
        $summary = $this->NSS_model->getSingleYearData($year, $institu, $startDate, $endDate);
$types   = $this->NSS_model->getYearwiseTypes($year, $institu, $startDate, $endDate);
    }

    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}


public function getCombinedData()
{
    $institu     = $this->input->post('fk_institu');
    // $departments = $this->input->post('departments');
    $years       = $this->input->post('years');
    $startDate   = $this->input->post('StartDate');
    $endDate     = $this->input->post('EndDate');

    $result = $this->NSS_model->getCombinedData($institu, $years, $startDate, $endDate);

    echo json_encode([
        "status"         => "success",
        // "departmentData" => $result['departmentData'],
        "yearData"       => $result['yearData']
    ]);
}


}
