<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class NSSForm extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('NSSForm_model');
        
    }


    
        public function index()
    {

        $data['alldata']=$this->NSSForm_model->getdetailview();

        $this->load->view('admin/header_view');
        $this->load->view('admin/NSS_detailview',$data);
        $this->load->view('admin/footer_view');
    }


 public function dashboard()
	{
    //   $data['alldata']=$this->ParentMeet_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/NSS_dash_view');
		$this->load->view('admin/footer_view');
	

	}
    public function create()
	{
    //    $data['load_script'] = 'Designation';

           $data['Department'] = $this->NSSForm_model->getDistinctDepartments();
           $data['Faculty'] = $this->NSSForm_model->get_all_faculty();
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/NSSForm_view',$data);
		$this->load->view('admin/footer_view');
	

	}

public function insertNewNSS()
{
    // ============================================================
    // ✅ STEP 0: Load Dependencies
    // ============================================================
    $this->load->library('upload');
    $this->load->helper(['form', 'url']);
    $this->load->database();

    // ============================================================
    // ✅ STEP 1: Save Excel or Manual Entry Info
    // ============================================================
    if (!empty($_FILES['activity_excel']['name'])) {
        // Case 1: Excel file uploaded
        $excel_name = $_FILES['activity_excel']['name'];

        $excelData = [
            'excel_name'   => $excel_name,
            'entry_type'   => 'excel',
            'institute_id' => 1
        ];
        $this->db->insert('nss_excel_uploads', $excelData);
        $excel_id = $this->db->insert_id();
    } else {
        // Case 2: Manual entry → always create a new row
        $excelData = [
            'excel_name'   => 'Manual Entry_' . date('Ymd_His'), // unique per entry
            'entry_type'   => 'manual',
            'institute_id' => 1
        ];
        $this->db->insert('nss_excel_uploads', $excelData);
        $excel_id = $this->db->insert_id();
    }

    // ============================================================
    // ✅ STEP 2: Fetch POST Data
    // ============================================================
    $Year            = $this->input->post('Year');
    $ActivityName    = $this->input->post('ActivityName');
    $PlaceOfActivity = $this->input->post('PlaceOfActivity');
    $DateOfActivity  = $this->input->post('DateOfActivity');
    $StudentCount    = $this->input->post('StudentCount');
    $URL             = $this->input->post('URL');
    $NssAct_ID       = $this->input->post('NssAct_ID');
    $existing_report = $this->input->post('existing_report');

    // ============================================================
    // ✅ STEP 3: Upload Report PDFs (if any)
    // ============================================================
    $report_pdf_paths = [];
    if (!empty($_FILES['report_pdf']['name'])) {
        foreach ($_FILES['report_pdf']['name'] as $key => $pdf_name) {
            if (!empty($pdf_name)) {
                $_FILES['activity_report']['name']     = $_FILES['report_pdf']['name'][$key];
                $_FILES['activity_report']['type']     = $_FILES['report_pdf']['type'][$key];
                $_FILES['activity_report']['tmp_name'] = $_FILES['report_pdf']['tmp_name'][$key];
                $_FILES['activity_report']['error']    = $_FILES['report_pdf']['error'][$key];
                $_FILES['activity_report']['size']     = $_FILES['report_pdf']['size'][$key];

                $config['upload_path']   = './uploads/nss_reports/';
                $config['allowed_types'] = 'pdf';
                $config['max_size']      = 5120; // 5MB
                $config['file_name']     = uniqid() . '_' . $pdf_name;

                if (!is_dir($config['upload_path'])) {
                    @mkdir($config['upload_path'], 0777, TRUE);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('activity_report')) {
                    $uploadData = $this->upload->data();
                    $report_pdf_paths[$key] = '/uploads/nss_reports/' . $uploadData['file_name'];
                } else {
                    // retain old file if upload fails
                    $report_pdf_paths[$key] = $existing_report[$key] ?? null;
                }
            } else {
                $report_pdf_paths[$key] = $existing_report[$key] ?? null;
            }
        }
    }

    // ============================================================
    // ✅ STEP 4: Save NSS Summary Data
    // ============================================================
    if (!empty($ActivityName)) {
        foreach ($ActivityName as $i => $actName) {
            if (trim($actName) == '') continue;

            // ✅ Financial Year logic
            $fini_label = $Year[$i] ?? null;
            $financial_year_id = null;

            if (!empty($fini_label)) {
                $this->db->select('finiYear_id');
                $this->db->from('finiyear_master');
                $this->db->where('fini_Label', $fini_label);
                $fini_query = $this->db->get();

                if ($fini_query->num_rows() > 0) {
                    $financial_year_id = $fini_query->row()->finiYear_id;
                } else {
                    $fini_data = [
                        'fini_Label'      => $fini_label,
                        'StartDate'       => null,
                        'EndDate'         => null,
                        'Active_Deactive' => 1,
                        'is_default'      => 0
                    ];
                    $this->db->insert('finiyear_master', $fini_data);
                    $financial_year_id = $this->db->insert_id();
                }
            }

            // ✅ Prepare data for nss_master
            $nssData = [
                'Financial_Year' => $financial_year_id,
                'NssActName'     => $actName,
                'PlaceOFAct'     => $PlaceOfActivity[$i] ?? null,
                'ActDate'        => $DateOfActivity[$i] ?? null,
                'StudPart'       => $StudentCount[$i] ?? null,
                'Report_pdf'     => $report_pdf_paths[$i] ?? null,
                'Month'          => $URL[$i] ?? null,
                'Institute_id'   => 1,
                'excel_upload_id'=> $excel_id
            ];

            // ✅ Insert or Update
            if (!empty($NssAct_ID[$i])) {
                $this->db->where('NssAct_ID', $NssAct_ID[$i]);
                $this->db->update('nss_master', $nssData);
            } else {
                $this->db->insert('nss_master', $nssData);
            }
        }
    }

    // ============================================================
    // ✅ STEP 5: Final Response
    // ============================================================
    echo json_encode(['status' => 'success', 'message' => 'NSS Summary saved successfully!']);
}
	
  public function update()
	{
		$id=$this->uri->segment(4);
        $data['data']=$this->NSSForm_model->getbyid($id);
           $data['Department'] = $this->NSSForm_model->getDistinctDepartments();
           $data['Faculty'] = $this->NSSForm_model->get_all_faculty();   
           $data['studentParentList'] = $this->NSSForm_model->get_students_by_nss($id); 
        //  $data['load_script'] = 'Designation';

        //  echo "<pre>";
        // print_r($data);

       
           $this->load->view('admin/header_view');
		$this->load->view('admin/NSSForm_view',$data);
           $this->load->view('admin/footer_view');
	}

 public function updateNss()
{
    $NssAct_ID    = $this->input->post('NssAct_ID');
    $NssActName   = $this->input->post('NssActName');
    $PlaceOFAct   = $this->input->post('PlaceOFAct');
    $SPOCName     = $this->input->post('SPOCName');
    $Department   = $this->input->post('Department');
    $Month        = $this->input->post('Month');
    $ActDate      = $this->input->post('ActDate');
    $StudPart     = $this->input->post('StudPart');
    $report_flag  = $this->input->post('Report_Flag');
    $activity_status = $this->input->post('Activity_Status');
    $Report_pdf   = $this->input->post('hidden_photo'); // Keep old if no new uploaded

    // ----------------- Single Image Upload -----------------
    if (!empty($_FILES['Report_pdf']['name'])) {
        $config['upload_path']   = FCPATH . 'uploads/Reportflag/';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $config['max_size']      = 2048;
        $config['file_name']     = time() . '_' . $_FILES['Report_pdf']['name'];

        $this->load->library('upload', $config);

        if ($this->upload->do_upload('Report_pdf')) {
            $uploadData   = $this->upload->data();
            $Report_pdf = 'uploads/Reportflag/' . $uploadData['file_name'];
        } else {
            echo $this->upload->display_errors();
            return;
        }
    }

    // Prepare fields for updating nss_master
    $fields = array(
        'NssActName'      => $NssActName,
        'PlaceOFAct'      => $PlaceOFAct,
        'SPOCName'        => $SPOCName,
        'Department'      => $Department,
        'Month'           => $Month,
        'ActDate'         => $ActDate,
        'StudPart'        => $StudPart,
        'Report_Flag'     => $report_flag,
        'Activity_Status' => $activity_status,
        'Report_pdf'      => $Report_pdf
    );

    // Update nss_master
    $this->db->where('NssAct_ID', $NssAct_ID)->update('nss_master', $fields);

    // âœ… Handle nss_students: delete old and insert new
    $prn          = $this->input->post('prn');
    $student_name = $this->input->post('student_name');
    $mobile_no    = $this->input->post('mobile_no');
    $occupation   = $this->input->post('occupation');

    // Delete existing students for this NSS activity
    $this->db->where('fkNssAct_ID', $NssAct_ID)->delete('nss_students');

    // Insert updated students list
    if (!empty($prn)) {
        $count = count($prn);
        for ($i = 0; $i < $count; $i++) {
            $studentData = array(
                'fkNssAct_ID'  => $NssAct_ID,
                'prn'          => $prn[$i],
                'student_name' => $student_name[$i],
                'mobile_no'    => $mobile_no[$i],
                'occupation'   => $occupation[$i]
            );
            $this->db->insert('nss_students', $studentData);
        }
    }
}

}
