<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class NewNSS extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('NewNSS_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }



   
     public function index()
	{
      $data['alldata']=$this->NewNSS_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin//NewNSS_detailview',$data);
		$this->load->view('admin/footer_view');
	

	}

   
    public function create()
	{
       $data['yeardata'] = $this->NewNSS_model->getyear();
         $data['activeYear'] = $this->NewNSS_model->getActiveYear();
 
 // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
 
		$this->load->view('admin/header_view');
		$this->load->view('admin/NewNSS_view',$data);
		$this->load->view('admin/footer_view');
	

	}



    // File upload method with improved error handling
    private function upload_file($file_name, $upload_path = './upload/')
    {
        // Ensure upload directory exists and is writable
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, TRUE);
        }
 
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
        // $config['max_size'] = 71680; // 5MB
        $config['encrypt_name'] = TRUE; // Use encrypted file names
 
        $this->upload->initialize($config);
 
        if (!$this->upload->do_upload($file_name)) {
            // If upload fails, return false or the current file
            return $this->input->post("hidden_photo{$file_name}");
        } else {
            $upload_data = $this->upload->data();
            return $upload_data['file_name'];
        }
    }


	public function insertNewNSS()
{
    try {
        $this->output->set_content_type('application/json');
        $this->load->library('upload');
        $this->load->helper(['form', 'url']);
        
        $posted_data = $this->input->post();
        log_message('debug', 'NSS Posted Data: ' . print_r($posted_data, true));

        // ============================================================
        // ✅ STEP 1: Validate Academic Year
        // ============================================================
        if (empty($posted_data['FiniYear'])) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please select an Academic Year'
            ]);
            return;
        }

        $selectedYear = $posted_data['FiniYear'];
$fk_submenuId = $this->input->post('fk_submenuId');
        // ============================================================
        // ✅ STEP 2: Create Main Excel Upload Record
        // ============================================================
        $excel_name = 'Manual Entry';
        $entry_type = 'manual';

        // Check if Excel file uploaded
        if (!empty($_FILES['activity_excel']['name'])) {
            $excel_name = $_FILES['activity_excel']['name'];
            $entry_type = 'excel';
        }

        $mainData = [
            'excel_name'   => $excel_name,
            'entry_type'   => $entry_type,
            'institute_id' => $this->session->userdata('institute_id') ?? 1,
            'created_by'=>$_SESSION['userID']
        ];

        $fkMain_id = $this->NewNSS_model->insertMain($mainData);
// Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $fkMain_id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

        if (!$fkMain_id) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to create main record'
            ]);
            return;
        }

        log_message('debug', 'Excel Upload ID created: ' . $fkMain_id);

        // ============================================================
        // ✅ STEP 3: Upload Report PDFs (if any)
        // ============================================================
        $report_pdf_paths = [];
        
        if (!empty($_FILES['report_pdf']['name'])) {
            foreach ($_FILES['report_pdf']['name'] as $key => $pdf_name) {
                if (!empty($pdf_name)) {
                    $_FILES['activity_report']['name']     = $_FILES['report_pdf']['name'][$key];
                    $_FILES['activity_report']['type']     = $_FILES['report_pdf']['type'][$key];
                    $_FILES['activity_report']['tmp_name'] = $_FILES['report_pdf']['tmp_name'][$key];
                    $_FILES['activity_report']['error']    = $_FILES['report_pdf']['error'][$key];
                    $_FILES['activity_report']['size']     = $_FILES['report_pdf']['size'][$key];

                    $config['upload_path']   = './uploads/nss_reports/';
                    $config['allowed_types'] = 'pdf';
                    $config['max_size']      = 71680; // 5MB
                    $config['file_name']     = uniqid() . '_' . $pdf_name;

                    if (!is_dir($config['upload_path'])) {
                        @mkdir($config['upload_path'], 0777, TRUE);
                    }

                    $this->upload->initialize($config);

                    if ($this->upload->do_upload('activity_report')) {
                        $uploadData = $this->upload->data();
                        $report_pdf_paths[$key] = 'uploads/nss_reports/' . $uploadData['file_name'];
                    } else {
                        $report_pdf_paths[$key] = null;
                        log_message('error', 'PDF Upload Error at index ' . $key . ': ' . $this->upload->display_errors());
                    }
                } else {
                    $report_pdf_paths[$key] = null;
                }
            }
        }

        // ============================================================
        // ✅ STEP 4: Insert Child Records (Activities)
        // ============================================================
        $insertCount = 0;
        $errors = [];

        if (!empty($posted_data['ActivityName']) && is_array($posted_data['ActivityName'])) {
            $count = count($posted_data['ActivityName']);

            for ($i = 0; $i < $count; $i++) {
                // Skip empty rows
                if (empty(trim($posted_data['ActivityName'][$i]))) {
                    continue;
                }

                $childData = [
                    'excel_upload_id' => $fkMain_id,
                    'Financial_Year'  => $selectedYear,
                    'NssActName'      => !empty($posted_data['ActivityName'][$i]) ? $posted_data['ActivityName'][$i] : null,
                    'PlaceOFAct'      => !empty($posted_data['PlaceOfActivity'][$i]) ? $posted_data['PlaceOfActivity'][$i] : null,
                    'ActDate'         => !empty($posted_data['DateOfActivity'][$i]) ? $posted_data['DateOfActivity'][$i] : null,
                    'StudPart'        => !empty($posted_data['StudentCount'][$i]) ? $posted_data['StudentCount'][$i] : null,
                    'Report_pdf'      => $report_pdf_paths[$i] ?? null,
                    'Month'           => !empty($posted_data['URL'][$i]) ? $posted_data['URL'][$i] : null,
                    'Institute_id'    => $this->session->userdata('institute_id') ?? 1
                ];

                log_message('debug', 'Child Data Row ' . ($i + 1) . ': ' . print_r($childData, true));

                if ($this->NewNSS_model->insertChild($childData)) {
                    $insertCount++;
                } else {
                    $errors[] = "Row " . ($i + 1) . " failed to insert";
                }
            }
        }

        // ============================================================
        // ✅ STEP 5: Return Response
        // ============================================================
        if ($insertCount > 0) {
            $yearLabel = $this->NewNSS_model->getYearLabel($selectedYear);
            $message = "Successfully saved {$insertCount} NSS activities for {$yearLabel}";

            if (!empty($errors)) {
                $message .= ". Some errors occurred: " . implode(", ", $errors);
            }

            echo json_encode([
                'status' => 'success',
                'message' => $message,
                'excel_upload_id' => $fkMain_id
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'No valid records to save. ' . implode(", ", $errors)
            ]);
        }

    } catch (Exception $e) {
        log_message('error', 'NSS insert error: ' . $e->getMessage());
        echo json_encode([
            'status' => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
}

/**
 * Load update form with existing data
 */
public function update()
{
    $excel_upload_id = $this->uri->segment(4);
    
    if (empty($excel_upload_id)) {
        redirect('NewNSS/index');
        return;
    }

    // Get main excel upload record
    $data['mainData'] = $this->NewNSS_model->getMainById($excel_upload_id);
    
    // Get child records (NSS activities) for this excel upload
    $data['childData'] = $this->NewNSS_model->getChildByMainId($excel_upload_id);
    
    // Get year data for dropdown
    $data['yeardata'] = $this->NewNSS_model->getyear();

     $data['activeYear'] = $this->NewNSS_model->getActiveYear();

    // For backward compatibility
    $data['data'] = !empty($data['childData']) ? $data['childData'] : [];

    $this->load->view('admin/header_view');
    $this->load->view('admin/NewNSS_view', $data);
    $this->load->view('admin/footer_view');
}
/**
 * Update NSS activities with improved structure
 */
public function updateNewNSS()
{
    try {
        $this->output->set_content_type('application/json');
        $this->load->library('upload');
        $this->load->helper(['form', 'url']);
        
        $posted_data = $this->input->post();
        log_message('debug', 'NSS Update Posted Data: ' . print_r($posted_data, true));

        // ============================================================
        // ✅ STEP 1: Validate Academic Year
        // ============================================================
        if (empty($posted_data['FiniYear'])) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please select an Academic Year'
            ]);
            return;
        }

        $selectedYear = $posted_data['FiniYear'];

        // ============================================================
        // ✅ STEP 2: Get or Create Main Excel Upload Record
        // ============================================================
        $excel_id = $posted_data['main_excel_id'] ?? null;
        $new_excel_uploaded = false;

        // Check if NEW Excel file is uploaded
        if (!empty($_FILES['activity_excel']['name']) && $_FILES['activity_excel']['error'] == 0) {
            $excel_name = $_FILES['activity_excel']['name'];
            
            $mainData = [
                'excel_name'   => $excel_name,
                'entry_type'   => 'excel',
                'institute_id' => $this->session->userdata('institute_id') ?? 1
            ];
            
            $new_excel_id = $this->NewNSS_model->insertMain($mainData);
            
            if ($new_excel_id) {
                $excel_id = $new_excel_id;
                $new_excel_uploaded = true;
                log_message('debug', "New Excel uploaded. New excel_upload_id: {$excel_id}");
            }
        }

        // Verify excel_id exists in database
        if (!empty($excel_id) && !$this->NewNSS_model->excelUploadExists($excel_id)) {
            log_message('error', "Excel upload ID {$excel_id} does not exist");
            $excel_id = null;
        }

        // If no valid excel_id, try to get from existing records
        if (empty($excel_id)) {
            $NssAct_ID = $posted_data['NssAct_ID'] ?? [];
            
            if (!empty($NssAct_ID) && is_array($NssAct_ID)) {
                foreach ($NssAct_ID as $id) {
                    if (!empty($id) && $id != '0') {
                        $existing = $this->NewNSS_model->getbyid($id);
                        if (!empty($existing[0]->excel_upload_id)) {
                            $excel_id = $existing[0]->excel_upload_id;
                            log_message('debug', "Retrieved excel_upload_id from existing record: {$excel_id}");
                            break;
                        }
                    }
                }
            }
        }

        // Last resort: create/get Manual Entry record
        if (empty($excel_id)) {
            $mainData = [
                'excel_name'   => 'Manual Entry',
                'entry_type'   => 'manual',
                'institute_id' => $this->session->userdata('institute_id') ?? 1
            ];
            
            $excel_id = $this->NewNSS_model->insertMain($mainData);
            log_message('debug', "Created new Manual Entry excel_upload_id: {$excel_id}");
        }

        if (empty($excel_id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to establish Excel upload reference'
            ]);
            return;
        }

        log_message('debug', "Final excel_upload_id: {$excel_id}");

        // ============================================================
        // ✅ STEP 3: Handle Deleted Records
        // ============================================================
        $existing_records = $this->NewNSS_model->getChildByMainId($excel_id);
        $existing_ids = [];
        
        foreach ($existing_records as $record) {
            $existing_ids[] = $record->NssAct_ID;
        }

        $submitted_ids = [];
        if (!empty($posted_data['NssAct_ID']) && is_array($posted_data['NssAct_ID'])) {
            foreach ($posted_data['NssAct_ID'] as $id) {
                if (!empty($id) && $id != '0') {
                    $submitted_ids[] = $id;
                }
            }
        }

        // Delete removed records
        $ids_to_delete = array_diff($existing_ids, $submitted_ids);
        if (!empty($ids_to_delete)) {
            foreach ($ids_to_delete as $delete_id) {
                $this->NewNSS_model->deleteSingleActivity($delete_id);
            }
            log_message('debug', 'Deleted NssAct_IDs: ' . implode(', ', $ids_to_delete));
        }

        // ============================================================
        // ✅ STEP 4: Upload Report PDFs (if any)
        // ============================================================
        $report_pdf_paths = [];
        $existing_reports = $posted_data['existing_report'] ?? [];

        if (!empty($_FILES['report_pdf']['name'])) {
            foreach ($_FILES['report_pdf']['name'] as $key => $pdf_name) {
                if (!empty($pdf_name)) {
                    $_FILES['activity_report']['name']     = $_FILES['report_pdf']['name'][$key];
                    $_FILES['activity_report']['type']     = $_FILES['report_pdf']['type'][$key];
                    $_FILES['activity_report']['tmp_name'] = $_FILES['report_pdf']['tmp_name'][$key];
                    $_FILES['activity_report']['error']    = $_FILES['report_pdf']['error'][$key];
                    $_FILES['activity_report']['size']     = $_FILES['report_pdf']['size'][$key];

                    $config['upload_path']   = './uploads/nss_reports/';
                    $config['allowed_types'] = 'pdf';
                    $config['max_size']      = 71680;
                    $config['file_name']     = uniqid() . '_' . $pdf_name;

                    if (!is_dir($config['upload_path'])) {
                        @mkdir($config['upload_path'], 0777, TRUE);
                    }

                    $this->upload->initialize($config);

                    if ($this->upload->do_upload('activity_report')) {
                        $uploadData = $this->upload->data();
                        $report_pdf_paths[$key] = 'uploads/nss_reports/' . $uploadData['file_name'];
                    } else {
                        $report_pdf_paths[$key] = $existing_reports[$key] ?? null;
                        log_message('error', 'PDF Upload Error at index ' . $key . ': ' . $this->upload->display_errors());
                    }
                } else {
                    $report_pdf_paths[$key] = $existing_reports[$key] ?? null;
                }
            }
        } else {
            // No new uploads, use existing
            $report_pdf_paths = $existing_reports;
        }

        // ============================================================
        // ✅ STEP 5: Update/Insert Child Records
        // ============================================================
        $updateCount = 0;
        $insertCount = 0;
        $errors = [];

        if (!empty($posted_data['ActivityName']) && is_array($posted_data['ActivityName'])) {
            $count = count($posted_data['ActivityName']);

            for ($i = 0; $i < $count; $i++) {
                // Skip empty rows
                if (empty(trim($posted_data['ActivityName'][$i]))) {
                    continue;
                }

                $childData = [
                    'excel_upload_id' => $excel_id,
                    'Financial_Year'  => $selectedYear,
                    'NssActName'      => !empty($posted_data['ActivityName'][$i]) ? $posted_data['ActivityName'][$i] : null,
                    'PlaceOFAct'      => !empty($posted_data['PlaceOfActivity'][$i]) ? $posted_data['PlaceOfActivity'][$i] : null,
                    'ActDate'         => !empty($posted_data['DateOfActivity'][$i]) ? $posted_data['DateOfActivity'][$i] : null,
                    'StudPart'        => !empty($posted_data['StudentCount'][$i]) ? $posted_data['StudentCount'][$i] : null,
                    'Report_pdf'      => $report_pdf_paths[$i] ?? null,
                    'Month'           => !empty($posted_data['URL'][$i]) ? $posted_data['URL'][$i] : null,
                    'Institute_id'    => $this->session->userdata('institute_id') ?? 1
                ];

                log_message('debug', 'Child Data Row ' . ($i + 1) . ': ' . print_r($childData, true));

                // Check if this is an update or insert
                $currentNssActID = !empty($posted_data['NssAct_ID'][$i]) && $posted_data['NssAct_ID'][$i] != '0' 
                    ? $posted_data['NssAct_ID'][$i] 
                    : null;

                if (!empty($currentNssActID)) {
                    // UPDATE existing record
                    if ($this->NewNSS_model->updateChild($currentNssActID, $childData)) {
                        $updateCount++;
                        log_message('debug', "Updated NssAct_ID: {$currentNssActID}");
                    } else {
                        $errors[] = "Row " . ($i + 1) . " failed to update";
                    }
                } else {
                    // INSERT new record
                    if ($this->NewNSS_model->insertChild($childData)) {
                        $insertCount++;
                        log_message('debug', "Inserted new record for: {$childData['NssActName']}");
                    } else {
                        $errors[] = "Row " . ($i + 1) . " failed to insert";
                    }
                }
            }
        }

        // ============================================================
        // ✅ STEP 6: Return Response
        // ============================================================
        $totalOperations = $updateCount + $insertCount;

        if ($totalOperations > 0) {
            $yearLabel = $this->NewNSS_model->getYearLabel($selectedYear);
            $message = "Successfully processed {$totalOperations} NSS activities for {$yearLabel}";
            
            if ($updateCount > 0) {
                $message .= " (Updated: {$updateCount}";
            }
            if ($insertCount > 0) {
                $message .= $updateCount > 0 ? ", Added: {$insertCount})" : " (Added: {$insertCount})";
            } else if ($updateCount > 0) {
                $message .= ")";
            }

            if (!empty($errors)) {
                $message .= ". Some errors occurred: " . implode(", ", $errors);
            }

            echo json_encode([
                'status' => 'success',
                'message' => $message,
                'excel_upload_id' => $excel_id,
                'updated' => $updateCount,
                'inserted' => $insertCount
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'No valid records to save. ' . implode(", ", $errors)
            ]);
        }

    } catch (Exception $e) {
        log_message('error', 'NSS update error: ' . $e->getMessage());
        echo json_encode([
            'status' => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
}

/**
 * Delete all activities for a given excel_upload_id
 */
public function deleteAllActivities()
{
    try {
        $this->output->set_content_type('application/json');
        
        $nss_act_id = $this->input->post('nss_act_id');
        $excel_upload_id = $this->input->post('excel_upload_id');
        
        log_message('debug', "Delete request - NssAct_ID: {$nss_act_id}, Excel ID: {$excel_upload_id}");
        
        // Try to get excel_upload_id from either source
        if (empty($excel_upload_id) && !empty($nss_act_id)) {
            $existing = $this->NewNSS_model->getbyid($nss_act_id);
            if (!empty($existing[0]->excel_upload_id)) {
                $excel_upload_id = $existing[0]->excel_upload_id;
                log_message('debug', "Retrieved excel_upload_id from NssAct_ID: {$excel_upload_id}");
            }
        }
        
        if (empty($excel_upload_id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Invalid request - no excel upload ID found'
            ]);
            return;
        }
        
        // Delete all child records
        if ($this->NewNSS_model->deleteChildRecords($excel_upload_id)) {
            echo json_encode([
                'status' => 'success',
                'message' => 'All activities deleted successfully',
                'excel_upload_id' => $excel_upload_id
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to delete activities'
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'Delete all activities error: ' . $e->getMessage());
        echo json_encode([
            'status' => 'error',
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
}



}
