<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OutwardReport extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('OutwardReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    public function Report()
    {
        $data['yeardata'] = $this->OutwardReport_model->getyear();
        $data['institutedata'] = $this->OutwardReport_model->getinstitu();
        $data['departdata'] = $this->OutwardReport_model->getdepart();
         $data['mainuserdata'] = $this->OutwardReport_model->getmainuser();
        $data['categorydata'] = $this->OutwardReport_model->getCategory(); // New
        $data['itemdata'] = $this->OutwardReport_model->getItems(); // New
        
        // Get active year
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
        
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/OutwardReport_view', $data);
        $this->load->view('admin/footer_view');
    }

     public function getReportData()
    {
        $institu = $this->input->post('fk_institu');
        $department = $this->input->post('fkdepartment_id'); // Changed variable name
        $mainuser = $this->input->post('fkmainuser_id'); // Changed variable name
        $category = $this->input->post('fkCategory_id');
        $item = $this->input->post('fkItem_id');
        $year_id = $this->input->post('year');
        $startDate = $this->input->post('startdate');
        $endDate = $this->input->post('enddate');

        $data = $this->OutwardReport_model->getFilteredData(
            $institu, 
            $department, 
            $mainuser, 
            $category, 
            $item, 
            $year_id, 
            $startDate, 
            $endDate
        );
        
        echo json_encode($data);
    }

    public function getPrintHeadings()
    {
        $data = $this->OutwardReport_model->getPrintHeadings();
        echo json_encode($data);
    }


   public function getItemDetails()
    {
        $main_id = $this->input->post('main_id');
        $data = $this->OutwardReport_model->getItemDetails($main_id);
        echo json_encode($data);
    }

    public function getItemsByCategory()
    {
        $category_id = $this->input->post('category_id');
        $items = $this->OutwardReport_model->getItemsByCategory($category_id);
        echo json_encode($items);
    }
}