<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ParentMeet extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('ParentMeet_model');
              $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

   
     public function index()
	{
      $data['alldata']=$this->ParentMeet_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/ParentMeet_detailview',$data);
		$this->load->view('admin/footer_view');
	

	}

      public function dashboard()
	{
    //   $data['alldata']=$this->ParentMeet_model->getdetailview();

        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/ParentMeet_dash_view');
		$this->load->view('admin/footer_view');
	

	}

    public function create()
	{
    //    $data['load_script'] = 'Designation';
       $data['yeardata'] = $this->ParentMeet_model->getyear();
           $data['Branch'] = $this->ParentMeet_model->get_all_Branch();
           $data['semdata'] = $this->ParentMeet_model->getsem();
        //  echo "<pre>";
        // print_r($data);

// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

		$this->load->view('admin/header_view');
		$this->load->view('admin/ParentMeet_view',$data);
		$this->load->view('admin/footer_view');
	

	}

function insertParentMeet()
{
    $fkBranch_id = $this->input->post('fkBranch_id');
    $MeetDate = $this->input->post('MeetDate');
    $NoStudent = $this->input->post('NoStudent');
    $NoParent = $this->input->post('NoParent');
    $FiniYear = $this->input->post('FiniYear');
 $fk_sem = $this->input->post('fk_sem');
 
    // Keep old files if no new uploaded
    $MeetingAgenda = $this->input->post('hidden_agenda');
    $MeetingInvi = $this->input->post('hidden_invitation');
    $ReportPdf = $this->input->post('hidden_report');
    $SuggestionParents = $this->input->post('hidden_suggestion');
    $ActionTaken = $this->input->post('hidden_action');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // Helper function for file upload
    $uploadFile = function($fieldName, $folder) {
        if (!empty($_FILES[$fieldName]['name'])) {
            $config['upload_path']   = FCPATH . 'uploads/' . $folder . '/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
            $config['max_size']      = 5120; // 5MB
            $config['file_name']     = time() . '_' . $_FILES[$fieldName]['name'];

            // Create folder if not exists
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->load->library('upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload($fieldName)) {
                $uploadData = $this->upload->data();
                return 'uploads/' . $folder . '/' . $uploadData['file_name'];
            } else {
                log_message('error', $fieldName . ' upload error: ' . $this->upload->display_errors());
                return null;
            }
        }
        return null;
    };

    // Upload files
    $uploadedAgenda = $uploadFile('MeetingAgenda', 'MeetingAgenda');
    if ($uploadedAgenda) $MeetingAgenda = $uploadedAgenda;

    $uploadedInvitation = $uploadFile('MeetingInvi', 'MeetingInvite');
    if ($uploadedInvitation) $MeetingInvi = $uploadedInvitation;

    $uploadedReport = $uploadFile('ReportPdf', 'ReportPdf');
    if ($uploadedReport) $ReportPdf = $uploadedReport;

    $uploadedSuggestion = $uploadFile('SuggestionParents', 'SuggestionParents');
    if ($uploadedSuggestion) $SuggestionParents = $uploadedSuggestion;

    $uploadedAction = $uploadFile('ActionTaken', 'ActionTaken');
    if ($uploadedAction) $ActionTaken = $uploadedAction;

    $StudParList = $this->input->post('StudParList');

    // Insert into parentmeet_master
    $fields = array(
        'fkBranch_id'       => $fkBranch_id,
        'MeetDate'          => $MeetDate,
        'NoStudent'         => $NoStudent,
        'NoParent'          => $NoParent,
        'FiniYear' => $FiniYear,
        'MeetingAgenda'     => $MeetingAgenda,
        'MeetingInvi'       => $MeetingInvi,
        'ReportPdf'         => $ReportPdf,
        'SuggestionParents' => $SuggestionParents,
        'ActionTaken'       => $ActionTaken,
        'StudParList'       => $StudParList,
        'fk_sem'       => $fk_sem,
        'created_by'=>$_SESSION['userID']
    );

    // Get active financial year
    // $finiYear = $this->db
    //     ->select('finiYear_id')
    //     ->from('finiyear_master')
    //     ->where('Active_Deactive', 1)
    //     ->get()
    //     ->row();

    // if ($finiYear) {
    //     $fields['FiniYear'] = $finiYear->finiYear_id;
    // }

    // Get institute
    $institute = $this->db
        ->select('Institu_id')
        ->from('institute_master')
        ->get()
        ->row();

    if ($institute) {
        $fields['Institute_id'] = $institute->Institu_id;
    }

    $this->db->insert('parentmeet_master', $fields);
    $meet_id = $this->db->insert_id();

        // ============================================================
    // ✅ Insert Log – Action 1 (Insert)
    // ============================================================

    $action     = 1;               // Insert
    $record_id  = $meet_id;        // Newly inserted Parent Meet ID
    $excel_name = null;
    $Fk_branch  = $fkBranch_id;    // Branch of the meeting

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );


    // Insert student-parent list
    $prn          = $this->input->post('prn');
    $student_name = $this->input->post('student_name');
    $parent_name  = $this->input->post('parent_name');
    $mobile_no    = $this->input->post('mobile_no');
    $occupation   = $this->input->post('occupation');

    if (!empty($prn)) {
        $count = count($prn);
        for ($i = 0; $i < $count; $i++) {
            if (!empty($prn[$i])) { // Skip empty rows
                $studentData = array(
                    'meet_id'      => $meet_id,
                    'prn'          => $prn[$i],
                    'student_name' => $student_name[$i],
                    'parent_name'  => $parent_name[$i],
                    'mobile_no'    => $mobile_no[$i],
                    'occupation'   => $occupation[$i]
                );
                $this->db->insert('parentmeet_students', $studentData);
            }
        }
    }

    echo json_encode(['status' => 'success', 'message' => 'Parent meeting saved successfully']);
}
	
  public function update()
	{
		$id=$this->uri->segment(4);
        $data['data']=$this->ParentMeet_model->getbyid($id);
   $data['Branch'] = $this->ParentMeet_model->get_all_Branch();
       $data['yeardata'] = $this->ParentMeet_model->getyear();
       $data['semdata'] = $this->ParentMeet_model->getsem();
        //  $data['load_script'] = 'Designation';

        //  echo "<pre>";
        // print_r($data);

        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
       
           $this->load->view('admin/header_view');
		$this->load->view('admin/ParentMeet_view',$data);
           $this->load->view('admin/footer_view');
	}

   
public function updateParentMeet()
{
    $Meet_id = $this->input->post('Meet_id');
    $fkBranch_id = $this->input->post('fkBranch_id');
    $MeetDate = $this->input->post('MeetDate');
    $NoStudent = $this->input->post('NoStudent');
    $NoParent = $this->input->post('NoParent');
    $FiniYear = $this->input->post('FiniYear');
 $fk_sem = $this->input->post('fk_sem');
 
    // Keep old files if no new uploaded
    $MeetingAgenda = $this->input->post('hidden_agenda');
    $MeetingInvi = $this->input->post('hidden_invitation');
    $ReportPdf = $this->input->post('hidden_report');
    $SuggestionParents = $this->input->post('hidden_suggestion');
    $ActionTaken = $this->input->post('hidden_action');
    $fk_submenuId = $this->input->post('fk_submenuId');

    // Helper function for file upload
    $uploadFile = function($fieldName, $folder) {
        if (!empty($_FILES[$fieldName]['name'])) {
            $config['upload_path']   = FCPATH . 'uploads/' . $folder . '/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf|doc|docx';
            $config['max_size']      = 5120; // 5MB
            $config['file_name']     = time() . '_' . $_FILES[$fieldName]['name'];

            // Create folder if not exists
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->load->library('upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload($fieldName)) {
                $uploadData = $this->upload->data();
                return 'uploads/' . $folder . '/' . $uploadData['file_name'];
            } else {
                log_message('error', $fieldName . ' upload error: ' . $this->upload->display_errors());
                return null;
            }
        }
        return null;
    };

    // Upload files only if new files selected
    $uploadedAgenda = $uploadFile('MeetingAgenda', 'MeetingAgenda');
    if ($uploadedAgenda) $MeetingAgenda = $uploadedAgenda;

    $uploadedInvitation = $uploadFile('MeetingInvi', 'MeetingInvite');
    if ($uploadedInvitation) $MeetingInvi = $uploadedInvitation;

    $uploadedReport = $uploadFile('ReportPdf', 'ReportPdf');
    if ($uploadedReport) $ReportPdf = $uploadedReport;

    $uploadedSuggestion = $uploadFile('SuggestionParents', 'SuggestionParents');
    if ($uploadedSuggestion) $SuggestionParents = $uploadedSuggestion;

    $uploadedAction = $uploadFile('ActionTaken', 'ActionTaken');
    if ($uploadedAction) $ActionTaken = $uploadedAction;

    $StudParList = $this->input->post('StudParList');

    // Update parentmeet_master
    $fields = array(
        'fkBranch_id'       => $fkBranch_id,
        'MeetDate'          => $MeetDate,
        'NoStudent'         => $NoStudent,
        'NoParent'          => $NoParent,
        'FiniYear' => $FiniYear,
        'MeetingAgenda'     => $MeetingAgenda,
        'MeetingInvi'       => $MeetingInvi,
        'ReportPdf'         => $ReportPdf,
        'SuggestionParents' => $SuggestionParents,
        'ActionTaken'       => $ActionTaken,
        'StudParList'       => $StudParList,
        'fk_sem'       => $fk_sem,
        'modified_by'=>$_SESSION['userID']
    );

    $this->db->where('Meet_id', $Meet_id)->update('parentmeet_master', $fields);

    // Handle student-parent list - delete old and insert fresh
    $this->db->where('meet_id', $Meet_id)->delete('parentmeet_students');

    $prn          = $this->input->post('prn');
    $student_name = $this->input->post('student_name');
    $parent_name  = $this->input->post('parent_name');
    $mobile_no    = $this->input->post('mobile_no');
    $occupation   = $this->input->post('occupation');

    if (!empty($prn)) {
        $count = count($prn);
        for ($i = 0; $i < $count; $i++) {
            if (!empty($prn[$i])) { // Skip empty rows
                $studentData = array(
                    'meet_id'      => $Meet_id,
                    'prn'          => $prn[$i],
                    'student_name' => $student_name[$i],
                    'parent_name'  => $parent_name[$i],
                    'mobile_no'    => $mobile_no[$i],
                    'occupation'   => $occupation[$i]
                );
                $this->db->insert('parentmeet_students', $studentData);
            }
        }
    }
    // ============================================================
    // ✅ Insert Log – Action 2 (Update)
    // ============================================================

    $action     = 2;               // Update
    $record_id  = $Meet_id;        // Parent meeting ID
    $excel_name = null;
    $Fk_branch  = $fkBranch_id;    // Branch related to the meeting

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );

    echo json_encode([
        'status'  => 'success',
        'message' => 'Parent meeting updated successfully'
    ]);

}

         public function Report()
	{
    //   $data['alldata']=$this->ParentMeet_model->getdetailview();
$data['institutedata'] = $this->ParentMeet_model->get_all_institute();
 $data['Branch'] = $this->ParentMeet_model->get_all_Branch();
    $data['branchdata'] = $this->ParentMeet_model->getbranch();   
$data['yeardata'] = $this->ParentMeet_model->getyear();
 $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        // echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
        $this->load->view('admin/ParentMeetReport',$data);
		$this->load->view('admin/footer_view');

	}


public function showDataByInstitute()
{
    $institute_id = $this->input->post('InstituteId');
    $startdate    = $this->input->post('startdate');
    $enddate      = $this->input->post('enddate');
    $branches     = $this->input->post('fkbranch_id');   // ✅ array from multi-select

    $data = $this->ParentMeet_model->getDataByInstitute(
        $institute_id,
        $startdate,
        $enddate,
        $branches
    );

    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->ParentMeet_model->getPrintHeadings();
    echo json_encode($data);
}

  

public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // may be an array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->ParentMeet_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->ParentMeet_model->getSingleYearData($year, $institu, $branches, $startDate, $endDate);
        $types   = $this->ParentMeet_model->getYearwiseTypes($year, $institu, $branches, $startDate, $endDate);
    }

    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}

 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS

    $result = $this->ParentMeet_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}

public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS

    $result = $this->ParentMeet_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}


public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu'); 
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');

    $result = $this->ParentMeet_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);

    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}


public function getStudentList()
{
    $meet_id = $this->input->post('meet_id');
    $this->load->model('ParentMeet_model');

    if (!$meet_id) {
        return $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode([]));
    }

    $students = $this->ParentMeet_model->getStudentsByMeetId($meet_id);

    return $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($students));
}



}
