<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PatentReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('PatentReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


public function Report()
{
    $data['yeardata'] = $this->PatentReport_model->getyear();
    $data['branchdata'] = $this->PatentReport_model->getbranch();
      $data['institutedata'] = $this->PatentReport_model->getinstitu();
      $data['maindata'] = $this->PatentReport_model->getmainuser();
       
      $activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();
 
$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;

    $this->load->view('admin/header_view');
    $this->load->view('admin/PatentReport_view.php', $data);
    $this->load->view('admin/footer_view');
}

// Controller में debug के लिए add करें
public function getPatentData()
{
    $institu_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id');
    $year_id = $this->input->post('year');
    $startDate = $this->input->post('startdate');
    $endDate = $this->input->post('enddate');
    
    // Debug
    log_message('debug', 'Patent Report Data: ' . json_encode($_POST));
    
    $data = $this->PatentReport_model->getPatenttDataFiltered($institu_id, $branch_ids, $year_id, $startDate, $endDate);
    
    // Debug
    log_message('debug', 'Query Result: ' . json_encode($data));
    
    echo json_encode($data);
}


public function getPrintHeadings()
{
    $data = $this->PatentReport_model->getPrintHeadings();
    echo json_encode($data);
}


// new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches = $this->input->post('branches');
    $userTypes = $this->input->post('userTypes');
 
    if ($year == "0" || empty($year)) {
        $summary = $this->PatentReport_model->getAllYearsData();
        $types = [];
    } else {
        $summary = $this->PatentReport_model->getSingleYearData($year, $branches, $userTypes);
        $types = $this->PatentReport_model->getYearwiseTypes($year, $branches, $userTypes);
    }
 
    echo json_encode([
        "status" => "success",
        "summary" => $summary,
        "types" => $types
    ]);
}

 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->PatentReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id');
    $institu = $this->input->post('fk_institu');
    $year = $this->input->post('year');
    $startDate = $this->input->post('StartDate');
    $endDate = $this->input->post('EndDate');
    $userTypes = $this->input->post('userTypes');
 
    $result = $this->PatentReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate, $userTypes);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu = $this->input->post('fk_institu');
    $branches = $this->input->post('branches');
    $years = $this->input->post('years');
    $startDate = $this->input->post('StartDate');
    $endDate = $this->input->post('EndDate');
    $userTypes = $this->input->post('userTypes');
 
    $result = $this->PatentReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate, $userTypes);
 
    echo json_encode([
        "status" => "success",
        "branchData" => $result['branchData'],
        "yearData" => $result['yearData']
    ]);
}
}






