<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Photolink extends CI_Controller {

     public function __construct()
{
    parent::__construct();
    $this->load->model('Photolink_model');
    $this->load->library('session');
     $this->load->model('Log_model');
        $this->load->helper('log'); // Load log helper
     if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    // Store the referrer URL using PHP superglobal
    $this->session->set_flashdata('prev_url', isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : base_url());
}

   // In Photolink controller (admin/Photolink.php)
public function index()
{
    $id = $this->input->get('id'); // Get the ID from URL
    $data['alldata'] = $this->Photolink_model->getdetailview($id); // Pass ID to model
     $data['branchdata'] = $this->Photolink_model->getbranch();

    
    $data['back_url'] = $this->session->userdata('last_page') ? $this->session->userdata('last_page') : base_url();
    
    $this->session->set_userdata('last_page', current_url());



    $this->load->view('admin/header_view');
    $this->load->view('admin/Photolink_detailview', $data);
    $this->load->view('admin/footer_view');
}


    public function create()
    {
        $data['yeardata'] = $this->Photolink_model->getyear();
         $data['branchdata'] = $this->Photolink_model->getbranch();

        $data['fkForm_id'] = $this->input->get('id');


        $data['back_url'] = $this->session->userdata('last_page') ? $this->session->userdata('last_page') : base_url();
    
    $this->session->set_userdata('last_page', current_url());

// ✅ Get current URL dynamically
        // $current_url = $this->uri->uri_string(); 
$current_url = $this->uri->uri_string();
if ($this->input->server('QUERY_STRING')) {
    $current_url .= '?' . $this->input->server('QUERY_STRING');
}
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Photolink_view', $data);
        $this->load->view('admin/footer_view');
    }

    // ========== INSERT FUNCTION ==========
    public function insertPhotolink()
    {
        $eventfunction_name = $this->input->post('eventfunction_name');
        $fkbranch_id    = $this->input->post('fkbranch_id');
        $year = $this->input->post('year');
        $photo_source = $this->input->post('photo_source');
        $fkForm_id = $this->input->post('fkForm_id'); 
        $fk_submenuId = $this->input->post('fk_submenuId'); 
        $this->load->library('upload');

        
        $fields = array(
            'eventfunction_name' => $eventfunction_name,
            'fkbranch_id'   => $fkbranch_id,
            'year' => $year,
            'photo_source' => $photo_source,
            'fkForm_id' => $fkForm_id,
            'created_by'=>$_SESSION['userID']
        );

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        if ($institute) {
            $fields['Institute'] = $institute->Institu_id;
        }

        $this->Photolink_model->insertdata($fields);
        $master_id = $this->db->insert_id();

        log_message('debug', "Created master record with multi_id: {$master_id}");

        $uploaded_files = [];

        // Step 2: Upload LOCAL photos
        if (!empty($_FILES['photos']['name'][0])) {
            $filesCount = count($_FILES['photos']['name']);

            for ($i = 0; $i < $filesCount; $i++) {
                $_FILES['file']['name']     = $_FILES['photos']['name'][$i];
                $_FILES['file']['type']     = $_FILES['photos']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['photos']['tmp_name'][$i];
                $_FILES['file']['error']    = $_FILES['photos']['error'][$i];
                $_FILES['file']['size']     = $_FILES['photos']['size'][$i];

                $config['upload_path']   = './uploads/multiplePhotos/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 5120;
                $config['encrypt_name']  = TRUE;
                
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, TRUE);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('file')) {
                    $uploadData = $this->upload->data();
                    $file_name = $uploadData['file_name'];
                    $uploaded_files[] = $file_name;

                    $this->Photolink_model->insertgallery([
                        'fk_multiID' => $master_id,
                        'photos' => 'uploads/multiplePhotos/' . $file_name,
                        'photo_type' => 'local',
                        'created_by'=>$_SESSION['userID']
                    ]);
                }
            }
        }

        // Step 3: Insert SINGLE GOOGLE URL
        $google_url = trim($this->input->post('google_url'));
        if (!empty($google_url) && filter_var($google_url, FILTER_VALIDATE_URL)) {
            $this->Photolink_model->insertgallery([
                'fk_multiID' => $master_id,
                'photos' => $google_url,
                'photo_type' => 'google'
            ]);
        }

        // Step 4: Generate single URL
        $single_url = base_url('admin/Photolink/viewPhotos/' . $master_id);

        $this->db->where('multi_id', $master_id)
                 ->update('multiphoto_master', [
                     'photo_url' => $single_url
                 ]);

        echo json_encode([
            'status' => 'success',
            'message' => 'Photos uploaded successfully',
            'master_id' => $master_id,
            'url' => $single_url
        ]);
        
         // log table code
 $action = 3;
        $record_id = null;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name,$Fk_branch,$_SESSION['userID']);
        
    }

    // ========== UPDATE FUNCTION ==========
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Photolink_model->getbyid($id);
        $data['selectedGallary'] = $this->Photolink_model->getSelectedPhotos($id);
         $data['branchdata'] = $this->Photolink_model->getbranch();
        $data['yeardata'] = $this->Photolink_model->getyear();

        $data['back_url'] = $this->session->userdata('last_page') ? $this->session->userdata('last_page') : base_url();
    
    $this->session->set_userdata('last_page', current_url());

        $this->load->view('admin/header_view');
        $this->load->view('admin/Photolink_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function updatePhotolink()
    {
        $multi_id = $this->input->post('multi_id');
        $eventfunction_name = $this->input->post('eventfunction_name');
        $fkbranch_id    = $this->input->post('fkbranch_id');
        $year = $this->input->post('year');
         $photo_source = $this->input->post('photo_source');
        //   $fkForm_id = $this->input->post('fkForm_id'); // ⭐ ADDED: Get fkForm_id

        // Get the existing record to preserve fkForm_id
    $existing_record = $this->Photolink_model->getbyid($multi_id);
    $fkForm_id = $existing_record[0]->fkForm_id; // Preserve the original fkForm_id
    
        $this->load->library('upload');

        // Step 1: Remove LOCAL photos
        $removed_local = $this->input->post('removed_local_photos');
        if (!empty($removed_local)) {
            $photosArray = explode(',', $removed_local);
            foreach ($photosArray as $photoFileName) {
                $child_record = $this->db->where('fk_multiID', $multi_id)
                                        ->where('photos', $photoFileName)
                                        ->where('photo_type', 'local')
                                        ->get('multiphoto_child')
                                        ->row();
                
                if ($child_record) {
                    $this->db->where('childID', $child_record->childID)->delete('multiphoto_child');
                    $file_path = FCPATH . $photoFileName;
                    if (file_exists($file_path)) {
                        unlink($file_path);
                    }
                }
            }
        }

        // Step 2: Handle GOOGLE URL (Remove old one if needed)
        $remove_google = $this->input->post('remove_google_url');
        if ($remove_google == '1') {
            // Delete existing Google URL
            $this->db->where('fk_multiID', $multi_id)
                     ->where('photo_type', 'google')
                     ->delete('multiphoto_child');
        }

        // Step 3: Upload new LOCAL photos
        if (!empty($_FILES['photos']['name'][0])) {
            $count_files = count($_FILES['photos']['name']);
            
            for ($i = 0; $i < $count_files; $i++) {
                $_FILES['file']['name']     = $_FILES['photos']['name'][$i];
                $_FILES['file']['type']     = $_FILES['photos']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['photos']['tmp_name'][$i];
                $_FILES['file']['error']    = $_FILES['photos']['error'][$i];
                $_FILES['file']['size']     = $_FILES['photos']['size'][$i];

                $config['upload_path']   = './uploads/multiplePhotos/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp';
                $config['max_size']      = 5120;
                $config['encrypt_name']  = TRUE;
                
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, TRUE);
                }

                $this->upload->initialize($config);

                if ($this->upload->do_upload('file')) {
                    $upload_data = $this->upload->data();
                    $file_name = $upload_data['file_name'];

                    $this->db->insert('multiphoto_child', [
                        'fk_multiID' => $multi_id,
                        'photos' => 'uploads/multiplePhotos/' . $file_name,
                        'photo_type' => 'local'
                    ]);
                }
            }
        }

        // Step 4: Insert/Update SINGLE GOOGLE URL
        $google_url = trim($this->input->post('google_url'));
        
        if (!empty($google_url) && filter_var($google_url, FILTER_VALIDATE_URL)) {
            // First, check if a Google URL already exists
            $existing_google = $this->db->where('fk_multiID', $multi_id)
                                       ->where('photo_type', 'google')
                                       ->get('multiphoto_child')
                                       ->row();
            
            if ($existing_google) {
                // Update existing Google URL
                $this->db->where('childID', $existing_google->childID)
                         ->update('multiphoto_child', [
                             'photos' => $google_url
                         ]);
            } else {
                // Insert new Google URL
                $this->db->insert('multiphoto_child', [
                    'fk_multiID' => $multi_id,
                    'photos' => $google_url,
                    'photo_type' => 'google'
                ]);
            }
        }

        // Step 5: Update master table
        $single_url = base_url('admin/Photolink/viewPhotos/' . $multi_id);
        $this->db->where('multi_id', $multi_id)
                 ->update('multiphoto_master', [
                     'photo_url' => $single_url,
                     'eventfunction_name' => $eventfunction_name,
                     'fkbranch_id'   => $fkbranch_id,
                     'year' => $year,
                     'photo_source' => $photo_source,
                     'fkForm_id' => $fkForm_id // ⭐ ADDED: Update fkForm_id
                 ]);

        $total_photos = $this->Photolink_model->getPhotoCount($multi_id);

        echo json_encode([
            'status' => 'success',
            'message' => 'Photos updated successfully',
            'total_photos' => $total_photos,
            'url' => $single_url
        ]);
    }

    // ========== VIEW PHOTOS PAGE ==========
    // public function viewPhotos($master_id)
    // {
    //     $data['master_data'] = $this->Photolink_model->getbyid($master_id);
    //     $data['photos'] = $this->Photolink_model->getSelectedPhotos($master_id);
    //     $data['master_id'] = $master_id;

    //     $this->load->view('admin/header_view');
    //     $this->load->view('admin/Photolink_gallery_view', $data);
    //     $this->load->view('admin/footer_view');
    // }

    public function viewPhotos($master_id)
{
    $data['master_data'] = $this->Photolink_model->getbyid($master_id);
    $data['photos'] = $this->Photolink_model->getSelectedPhotos($master_id);
    $data['master_id'] = $master_id;

    
    if (empty($data['photos']['local']) && !empty($data['photos']['google'])) {
     
        redirect($data['photos']['google'][0]);
        exit;
    }

    
    $this->load->view('admin/header_view');
    $this->load->view('admin/Photolink_gallery_view', $data);
    $this->load->view('admin/footer_view');
}


}