<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class RequisitionReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('RequisitionReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

public function Report()
{

     $data['yeardata'] = $this->RequisitionReport_model->getyear();
      
    $data['institutedata'] = $this->RequisitionReport_model->getinstitu();
   
    $data['branchdata'] = $this->RequisitionReport_model->getbranch();

//      $activeYear = $this->db
//     ->select('finiYear_id')
//     ->from('finiyear_master')
//     ->where('Active_Deactive', 1)
//     ->get()
//     ->row();
 
// $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
    
    $this->load->view('admin/header_view');
    $this->load->view('admin/RequisitionReport_view.php',$data);
    $this->load->view('admin/footer_view');
}


public function getReportData()
{
    $institu   = $this->input->post('institute');
    $branches  = $this->input->post('fkbranch_id'); // multiple select
    $year_id    = $this->input->post('year'); 
 
   // Get date values from the request
    $startDate = $this->input->post('startdate');
    $endDate   = $this->input->post('enddate');

    $data = $this->RequisitionReport_model->getFilteredData($institu, $branches, $year_id, $startDate, $endDate);

    echo json_encode($data);
}

public function getPrintHeadings()
{
    $data = $this->RequisitionReport_model->getPrintHeadings();
    echo json_encode($data);
}



// new 

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    

    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->RequisitionReport_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year
        $summary = $this->RequisitionReport_model->getSingleYearData($year,$branches);
        $types   = $this->RequisitionReport_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->RequisitionReport_model->getBranchwiseCount($institu, $branches, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkbranch_id'); // match JS
    $year      = $this->input->post('year');
    $startDate = $this->input->post('StartDate');  // match JS
    $endDate   = $this->input->post('EndDate');    // match JS
 
    $result = $this->RequisitionReport_model->getBranchDetailsData($branch_id, $institu, $year, $startDate, $endDate);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
    $startDate = $this->input->post('StartDate');
    $endDate   = $this->input->post('EndDate');
 
    $result = $this->RequisitionReport_model->getCombinedData($institu, $branches, $years, $startDate, $endDate);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 



}