<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Scholership extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Scholership_model');
        $this->load->helper('url');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

    // ============ VIEW METHODS ============
    
    public function create()
    {
        $data['yearList'] = $this->Scholership_model->getYears();
        $data['activeYear'] = $this->Scholership_model->getActiveYear();
        $data['mainData'] = null; // For new record

        // ✅ Get current URL dynamically

        $current_url = $this->uri->uri_string();        

        // ✅ Fetch SubID from database

        $data['subId'] = $this->Log_model->getsubID($current_url);
//  print_r($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Scholership_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Scholership_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Scholership_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Scholership_dash_view');
        $this->load->view('admin/footer_view');
    }

    // ============ INSERT METHOD ============
    
    public function insertScholership()
    {
        try {
            // Get POST data
            $finiYear = $this->input->post('FiniYear');
            $fk_submenuId = $this->input->post('fk_submenuId');
            $tableData = json_decode($this->input->post('tableData'), true);
           
            
            // Handle Excel file upload
            $excelFileName = null;
            if (!empty($_FILES['excel_file']['name'])) {
                $config['upload_path'] = './uploads/scholership/';
                $config['allowed_types'] = 'xls|xlsx';
                $config['max_size'] = 10240; // 10MB
                $config['file_name'] = 'scholership_' . time() . '_' . $_FILES['excel_file']['name'];
                
                // Create directory if not exists
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }
                
                $this->load->library('upload', $config);
                
                if ($this->upload->do_upload('excel_file')) {
                    $uploadData = $this->upload->data();
                    $excelFileName = $uploadData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'message' => $this->upload->display_errors()
                    ]);
                    return;
                }
            }
            
            // Prepare main table data
            $mainData = [
                'FiniYear' => $finiYear,
                'ExcelName' => $excelFileName,
                'created_by' => $this->session->userdata('user_id') ?? 1,
                'created_at' => date('Y-m-d H:i:s'),
                'is_on' => 1,
                'is_active' => 1
            ];
            
            // Insert main record
            $mainId = $this->Scholership_model->insertMain($mainData);

 
        // Insert log - Action 1 (Insert)
        $action = 1;
        $record_id = $mainId;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
        //  $sub_id = $this->db->insert_id();
            
            if ($mainId) {
                // Insert child records
                $insertedCount = 0;
                foreach ($tableData as $row) {
                    $childData = [
                        'fkMain_id' => $mainId,
                        'Student_name' => $row['student_name'],
                        'PRN' => $row['prn'],
                        'mobile_no' => $row['mobile_no'],
                        'branch_name' => $row['branch_name'],
                        'Scholer_Level' => $row['scholer_level'],
                        'ScholershipName' => $row['scholership_name'],
                        'Caste' => $row['caste'],
                        'created_by'=>$_SESSION['userID'],
                        'created_date' => date('Y-m-d H:i:s'),
                        'is_on' => 1,
                        'is_active' => 1
                    ];
                    
                    if ($this->Scholership_model->insertChild($childData)) {
                        $insertedCount++;
                    }
                }
                
                echo json_encode([
                    'status' => 'success',
                    'message' => "$insertedCount records inserted successfully",
                    'main_id' => $mainId
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to insert main record'
                ]);
            }
            
        } catch (Exception $e) {
            echo json_encode([
                'status' => 'error',
                'message' => $e->getMessage()
            ]);
        }
    }

    // ============ UPDATE METHOD ============
    
    public function update()
    {
        $id = $this->uri->segment(4);
        $data['mainData'] = $this->Scholership_model->getMainById($id);
        $data['childData'] = $this->Scholership_model->getChildByMainId($id);
        $data['yearList'] = $this->Scholership_model->getYears();
        $data['activeYear'] = $this->Scholership_model->getActiveYear();

        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Scholership_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function updateScholership()
    {
        try {
            // Get POST data
            $mainId = $this->input->post('Main_id');
            $finiYear = $this->input->post('FiniYear');
            $fk_submenuId = $this->input->post('fk_submenuId');
            $tableData = json_decode($this->input->post('tableData'), true);
           
            
            // Get existing main data
            $existingMain = $this->Scholership_model->getMainById($mainId);
            $excelFileName = $existingMain->ExcelName;
            
            // Handle Excel file upload (if new file uploaded)
            if (!empty($_FILES['excel_file']['name'])) {
                $config['upload_path'] = './uploads/scholership/';
                $config['allowed_types'] = 'xls|xlsx';
                $config['max_size'] = 10240; // 10MB
                $config['file_name'] = 'scholership_' . time() . '_' . $_FILES['excel_file']['name'];
                
                // Create directory if not exists
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path'], 0777, true);
                }
                
                $this->load->library('upload', $config);
                
                if ($this->upload->do_upload('excel_file')) {
                    // Delete old file if exists
                    if ($excelFileName && file_exists('./uploads/scholership/' . $excelFileName)) {
                        unlink('./uploads/scholership/' . $excelFileName);
                    }
                    
                    $uploadData = $this->upload->data();
                    $excelFileName = $uploadData['file_name'];
                }
            }
            
            // Prepare main table data for update
            $mainData = [
                'Main_id' => $mainId,
                'FiniYear' => $finiYear,
                'ExcelName' => $excelFileName,
                'modified_by'=>$_SESSION['userID'],
                'modified_date' => date('Y-m-d H:i:s')
            ];
            
            // Update main record
            if ($this->Scholership_model->updateMain($mainData)) {

                
        $action = 2;
        $record_id = $mainId;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
                // Delete existing child records
                $this->Scholership_model->deleteChildByMainId($mainId);
                
                // Insert new child records
                $insertedCount = 0;
                foreach ($tableData as $row) {
                    $childData = [
                        'fkMain_id' => $mainId,
                        'Student_name' => $row['student_name'],
                        'PRN' => $row['prn'],
                        'mobile_no' => $row['mobile_no'],
                        'branch_name' => $row['branch_name'],
                        'Scholer_Level' => $row['scholer_level'],
                        'ScholershipName' => $row['scholership_name'],
                        'Caste' => $row['caste'],
                        'created_by' => $this->session->userdata('user_id') ?? 1,
                        'created_date' => date('Y-m-d H:i:s'),
                        'is_on' => 1,
                        'is_active' => 1
                    ];
                    
                    if ($this->Scholership_model->insertChild($childData)) {
                        $insertedCount++;
                    }
                }
                
                echo json_encode([
                    'status' => 'success',
                    'message' => "Record updated with $insertedCount entries",
                    'main_id' => $mainId
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to update main record'
                ]);
            }
            
        } catch (Exception $e) {
            echo json_encode([
                'status' => 'error',
                'message' => $e->getMessage()
            ]);
        }
    }

    // ============ DELETE METHOD ============
    
    public function delete()
    {
        $id = $this->uri->segment(4);
        
        // Soft delete - mark as deleted
        $result = $this->Scholership_model->deleteMain($id);
        
        if ($result) {
            $this->session->set_flashdata('success', 'Record deleted successfully');
        } else {
            $this->session->set_flashdata('error', 'Failed to delete record');
        }
        
        redirect('admin/Scholership/index');
    }
}