<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ScholershipReport extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('ScholershipReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');

        }
    }

   public function Report()
    {
        $data['branchList'] = $this->ScholershipReport_model->getBranches();
        $data['levelList'] = $this->ScholershipReport_model->getLevels();
        $data['casteList'] = $this->ScholershipReport_model->getCastes();
        $data['yearList'] = $this->ScholershipReport_model->getYears();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/ScholershipReport_view.php', $data);
        $this->load->view('admin/footer_view');
    }


public function getReportData()
{
    // Get POST data from AJAX
    $branch_ids = $this->input->post('branch_ids');
    $level_ids = $this->input->post('level_ids');
    $caste_ids = $this->input->post('caste_ids');
    $year_ids = $this->input->post('year_ids');

    // Call model to get filtered data
    $data = $this->ScholershipReport_model->getFilteredData(
        $branch_ids,
        $level_ids,
        $caste_ids,
        $year_ids
    );

    // Return JSON response
    echo json_encode($data);
}

public function getPrintHeadings()
{
    $data = $this->ScholershipReport_model->getPrintHeadings();
    echo json_encode($data);
}



// new 

// Add/Update these methods in ScholershipReport controller

public function getCombinedData()
{
    $branches = $this->input->post('branches');   // array
    $years = $this->input->post('years');         // array
    
    // Get branchwise count
    $branchData = $this->getBranchwiseCountData($branches, $years);
    
    // Get yearwise count  
    $yearData = $this->getYearwiseCountData($branches, $years);
    
    echo json_encode([
        "status" => "success",
        "branchData" => $branchData,
        "yearData" => $yearData
    ]);
}

private function getBranchwiseCountData($branches = [], $years = [])
{
    $this->db->select('sm.branch_name, COUNT(sm.scholerID) as Grant_count, sm.branch_name as branch_id');
    $this->db->from('scholership_master sm');
    $this->db->join('scholershipmain_master smm', 'smm.Main_id = sm.fkMain_id', 'left');
    
    $this->db->where('sm.is_active', 1);
    
    if (!empty($branches) && is_array($branches)) {
        $this->db->where_in('sm.branch_name', $branches);
    }
    
    if (!empty($years) && is_array($years)) {
        $this->db->where_in('smm.FiniYear', $years);
    }
    
    $this->db->group_by('sm.branch_name');
    $this->db->order_by('sm.branch_name', 'ASC');
    
    return $this->db->get()->result();
}

private function getYearwiseCountData($branches = [], $years = [])
{
    $this->db->select('fm.finiYear_id as year_id, fm.fini_Label as year, COUNT(sm.scholerID) as count');
    $this->db->from('scholership_master sm');
    $this->db->join('scholershipmain_master smm', 'smm.Main_id = sm.fkMain_id', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = smm.FiniYear', 'left');
    
    $this->db->where('sm.is_active', 1);
    
    if (!empty($branches) && is_array($branches)) {
        $this->db->where_in('sm.branch_name', $branches);
    }
    
    if (!empty($years) && is_array($years)) {
        $this->db->where_in('smm.FiniYear', $years);
    }
    
    $this->db->group_by('fm.finiYear_id, fm.fini_Label');
    $this->db->order_by('fm.finiYear_id', 'ASC');
    
    return $this->db->get()->result();
}

public function getBranchDetails()
{
    $branch_name = $this->input->post('branch_id'); // Actually branch_name
    $years = $this->input->post('year');
    
    $this->db->select('sm.*, smm.ExcelName, fm.fini_Label as year_label');
    $this->db->from('scholership_master sm');
    $this->db->join('scholershipmain_master smm', 'smm.Main_id = sm.fkMain_id', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = smm.FiniYear', 'left');
    
    $this->db->where('sm.is_active', 1);
    $this->db->where('sm.branch_name', $branch_name);
    
    if (!empty($years)) {
        if (is_array($years)) {
            $this->db->where_in('smm.FiniYear', $years);
        } else {
            $this->db->where('smm.FiniYear', $years);
        }
    }
    
    $result = $this->db->get()->result();
    echo json_encode($result);
}

public function getYearwiseData()
{
    $year = $this->input->post('year');
    $branches = $this->input->post('branches');
    
    $this->db->select('sm.*, smm.ExcelName, fm.fini_Label as year');
    $this->db->from('scholership_master sm');
    $this->db->join('scholershipmain_master smm', 'smm.Main_id = sm.fkMain_id', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = smm.FiniYear', 'left');
    
    $this->db->where('sm.is_active', 1);
    $this->db->where('smm.FiniYear', $year);
    
    if (!empty($branches) && is_array($branches)) {
        $this->db->where_in('sm.branch_name', $branches);
    }
    
    $types = $this->db->get()->result_array();
    
    echo json_encode([
        "status" => "success",
        "types" => $types
    ]);
}

}