<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StockReport extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('StockReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Report()
    {
        $data['yeardata'] = $this->StockReport_model->getyear();
        $data['institutedata'] = $this->StockReport_model->getinstitu();
        
        $data['categorydata'] = $this->StockReport_model->getCategory(); // New
        $data['itemdata'] = $this->StockReport_model->getItems(); // New
        
        // Get active year
        $activeYear = $this->db
            ->select('finiYear_id')
            ->from('finiyear_master')
            ->where('Active_Deactive', 1)
            ->get()
            ->row();
        
        $data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/StockReport_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function getReportData()
    {
        $institu = $this->input->post('fk_institu');
        $supplier = $this->input->post('fkSupplier_id');
        $category = $this->input->post('fkCategory_id'); // New
        $item = $this->input->post('fkItem_id'); // New
        $year_id = $this->input->post('year');
        $startDate = $this->input->post('startdate');
        $endDate = $this->input->post('enddate');

        $data = $this->StockReport_model->getFilteredData($institu, $category, $item, $year_id, $startDate, $endDate);
        
        echo json_encode($data);
    }

    public function getPrintHeadings()
    {
        $data = $this->StockReport_model->getPrintHeadings();
        echo json_encode($data);
    }

    // AJAX method to get items by category
    public function getItemsByCategory()
    {
        $category_id = $this->input->post('category_id');
        $items = $this->StockReport_model->getItemsByCategory($category_id);
        echo json_encode($items);
    }
}