<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sttpexcel extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Sttpexcel_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
    }

    // ================= VIEW =================
    public function create() {
        $current_url = $this->uri->uri_string();
        $data['subId'] = $this->Log_model->getsubID($current_url);
        $this->load->view('admin/header_view');
        $this->load->view('admin/Sttpexcel_view', $data);
        $this->load->view('admin/footer_view');
    }

    // ================= IMPORT =================
    public function import_excel_save() {
        try {
            $fk_submenuId = $this->input->post('fk_submenuId');
            $filename = '';

            /* ================= FILE UPLOAD ================= */
            if (!empty($_FILES['excel_file']['name'])) {
                $uploadDir = FCPATH . 'uploads/excel/';
                if (!is_dir($uploadDir)) {
                    mkdir($uploadDir, 0777, true);
                }

                $filename = 'sttp_excel_' . date('Ymd_His') . '_' . $_FILES['excel_file']['name'];
                $targetFile = $uploadDir . $filename;

                if (!move_uploaded_file($_FILES['excel_file']['tmp_name'], $targetFile)) {
                    echo "file_error";
                    return;
                }
            }

            /* ================= TABLE DATA ================= */
            $tableData = $this->input->post('tableData');
            if (empty($tableData)) {
                echo "no_data";
                return;
            }

            $rows = json_decode($tableData, true);
            if (empty($rows) || json_last_error() !== JSON_ERROR_NONE) {
                echo "invalid_json";
                return;
            }

            /* ================= MASTER MAPS ================= */
            $yearMap = [];
            $branchMap = [];
            $durationMap = [];

            // Financial Year Map
            $yearResult = $this->db->get('finiyear_master')->result();
            foreach ($yearResult as $r) {
                $yearMap[strtolower(trim((string)$r->fini_Label))] = $r->finiYear_id;
            }

            // Branch Map
            $branchResult = $this->db->get('branch_master')->result();
            foreach ($branchResult as $r) {
                $branchMap[strtolower(trim((string)$r->branch_name))] = $r->branch_id;
            }

            // Duration Map
            $durationResult = $this->db->get('internduration_master')->result();
            foreach ($durationResult as $r) {
                $durationMap[strtolower(trim((string)$r->duration_type))] = $r->duration_id;
            }

            /* ================= INSERT DATA ================= */
            $insertData = [];
            $rowCount = 0;

            foreach ($rows as $row) {
                $rowCount++;
                if ($rowCount === 1) continue; // skip header row

                /* ---- Financial Year ---- */
                $yearStr = strtolower(trim($row['Financial_Year'] ?? ''));
                if (!empty($yearStr) && !isset($yearMap[$yearStr])) {
                    $this->db->insert('finiyear_master', [
                        'fini_Label' => ucfirst($yearStr),
                        'is_active' => 1
                    ]);
                    $yearMap[$yearStr] = $this->db->insert_id();
                }
                $Financial_Year = $yearMap[$yearStr] ?? null;

                /* ---- Branch ---- */
                $branchStr = strtolower(trim($row['fk_branch'] ?? ''));
                if (!empty($branchStr) && !isset($branchMap[$branchStr])) {
                    $this->db->insert('branch_master', [
                        'branch_name' => ucfirst($branchStr),
                        'is_active' => 1
                    ]);
                    $branchMap[$branchStr] = $this->db->insert_id();
                }
                $fk_branch = $branchMap[$branchStr] ?? null;

                /* ---- Duration ---- */
                $durationStr = strtolower(trim($row['fk_duration'] ?? ''));
                if (!empty($durationStr) && !isset($durationMap[$durationStr])) {
                    $this->db->insert('internduration_master', [
                        'duration_type' => ucfirst($durationStr),
                        'is_active' => 1
                    ]);
                    $durationMap[$durationStr] = $this->db->insert_id();
                }
                $fk_duration = $durationMap[$durationStr] ?? null;

                /* ---- Date Convert ---- */
                $start_date = $this->convertExcelDate($row['start_date'] ?? '');
                $end_date = $this->convertExcelDate($row['end_date'] ?? '');

                /* ---- Final Insert ---- */
                $insertData[] = [
                    'sttp_name' => trim($row['sttp_name'] ?? ''),
                    'fk_branch' => $fk_branch,
                    'faculty_name' => trim($row['faculty_name'] ?? ''),
                    'fk_duration' => $fk_duration,
                    'start_date' => $start_date,
                    'end_date' => $end_date,
                    'Financial_Year' => $Financial_Year,
                    'organized' => trim($row['organized'] ?? ''),
                    'name_of' => trim($row['name_of'] ?? ''),
                    'faculty_thumb' => trim($row['faculty_thumb'] ?? ''),
                    'created_date' => date('Y-m-d')
                ];
            }

            /* ================= SAVE ================= */
            if (!empty($insertData)) {
                $this->db->insert_batch('sttp_master', $insertData);
                
                // Log the import
                if (!empty($filename)) {
                    insert_log($this, $fk_submenuId, 4, null, $filename, null);
                }
                
                echo "success";
            } else {
                echo "no_data";
            }

        } catch (Exception $e) {
            log_message('error', 'STTP Excel Import Error: ' . $e->getMessage());
            echo "error: " . $e->getMessage();
        }
    }


    
    // ================= HELPER FUNCTION =================
    private function convertExcelDate($date) {
        if (empty($date)) {
            return null;
        }

        // If numeric (Excel serial date)
        if (is_numeric($date)) {
            // Excel date serial number conversion
            return gmdate("Y-m-d", ($date - 25569) * 86400);
        }

        // If string date format
        $dateStr = str_replace('/', '-', trim($date));
        $timestamp = strtotime($dateStr);
        
        if ($timestamp !== false) {
            return date('Y-m-d', $timestamp);
        }

        return null;
    }
}
?>