<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StudComp extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('StudComp_model');
         $this->load->library('email');
    }


     public function index()
	{
       $data['alldata']=$this->StudComp_model->getdetailStudComp();

		$this->load->view('admin/header_view');
         $this->load->view('admin/studComp_detailView',$data);
		$this->load->view('admin/footer_view');
	

	}

    public function create()
	{ 
         $data['genders'] = $this->StudComp_model->get_all_genders();
         $data['complaint_categories'] = $this->StudComp_model->get_all_complaint_categories();
          $data['branch'] = $this->StudComp_model->get_all_Branch();
           $data['Class'] = $this->StudComp_model->get_all_class();
		// $this->load->view('common/header_view');
		$this->load->view('admin/studComp_view',$data);
		// $this->load->view('common/footer_view');
	

	}


     // File upload method with improved error handling
    private function upload_file($file_name, $upload_path = './upload/')
    {
        // Ensure upload directory exists and is writable
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, TRUE);
        }
 
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'gif|jpg|png|jpeg|pdf';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE; // Use encrypted file names
 
        $this->upload->initialize($config);
 
        if (!$this->upload->do_upload($file_name)) {
            // If upload fails, return false or the current file
            return $this->input->post("hidden_photo{$file_name}");
        } else {
            $upload_data = $this->upload->data();
            return $upload_data['file_name'];
        }
    }

// 	function insertStudentComplaint(){
//         $Stud_name= $this->input->post('Stud_name'); 
//         $Stud_mailId= $this->input->post('Stud_mailId');
//         $Stud_mobileNo= $this->input->post('Stud_mobileNo');
//         $StudPRN_NO=$this->input->post('StudPRN_NO');
//         $fkgender_id=$this->input->post('fkgender_id');
//         $fkdep_id=$this->input->post('fkdep_id');
//         $fkbranch_id=$this->input->post('fkbranch_id');
//         $fkComp_id=$this->input->post('fkComp_id');
//         $Comp_Desp=$this->input->post('Comp_Desp');
//          $fkclass_id=$this->input->post('fkclass_id');
//              $this->load->library('upload');
//     $photo_filename = $this->upload_file('attachment', './uploads/complaint/');
//     $attachment = $photo_filename ? 'uploads/complaint/' . $photo_filename : '';

//        $fields=array('Stud_name'=>$Stud_name,
//                      'Stud_mailId'=>$Stud_mailId,
//                       'Stud_mobileNo'=>$Stud_mobileNo,
//                      'StudPRN_NO'=>$StudPRN_NO,  
//                       'fkgender_id'=>$fkgender_id,
//                        'fkdep_id'=>$fkdep_id,                
//                       'fkbranch_id'=>$fkbranch_id,
//                        'fkComp_id'=>$fkComp_id,
//                         'Comp_Desp'=>$Comp_Desp,
//                         'fkclass_id'=>$fkclass_id,
//                         'attachment'=>$attachment


//                     );

//                     // echo "<pre>";
//                     // print_r($fields);
//          $insert_id = $this->StudComp_model->insertdata($fields);
    
//     // Make sure this is the only output
//     echo json_encode(['status' => 'success', 'id' => $insert_id]);

//             // echo json_encode($fields);
        
    
//    } 

public function insertStudentComplaint() {
    $Stud_name     = $this->input->post('Stud_name'); 
    $Stud_mailId   = $this->input->post('Stud_mailId');
    $Stud_mobileNo = $this->input->post('Stud_mobileNo');
    $StudPRN_NO    = $this->input->post('StudPRN_NO');
    $fkgender_id   = $this->input->post('fkgender_id');
    $fkdep_id      = $this->input->post('fkdep_id');
    $fkbranch_id   = $this->input->post('fkbranch_id');
    $fkComp_id     = $this->input->post('fkComp_id');
    $Comp_Desp     = $this->input->post('Comp_Desp');
    $fkclass_id    = $this->input->post('fkclass_id');

    // File upload
    $this->load->library('upload');
    $photo_filename = $this->upload_file('attachment', './Assets/Upload/');
    $attachment = $photo_filename ? '/Assets/Upload/' . $photo_filename : '';

// $this->load->library('upload');
// $this->load->helper('image'); // Required for image_thumb()

// $photo_filename = $this->upload_file('attachment', './Assets/Upload/');
// $attachment = $photo_filename ? '/Assets/Upload/' . $photo_filename : '';

// if ($photo_filename) {
//     image_thumb('Assets/Upload', $photo_filename, 800, 600, 60); // Compress image
// }
  


    $fields = array(
        'Stud_name'     => $Stud_name,
        'Stud_mailId'   => $Stud_mailId,
        'Stud_mobileNo' => $Stud_mobileNo,
        'StudPRN_NO'    => $StudPRN_NO,
        'fkgender_id'   => $fkgender_id,
        'fkdep_id'      => $fkdep_id,
        'fkbranch_id'   => $fkbranch_id,
        'fkComp_id'     => $fkComp_id,
        'Comp_Desp'     => $Comp_Desp,
        'fkclass_id'    => $fkclass_id,
        'attachment'    => $attachment
    );

    $finiYear = $this->db
                ->select('finiYear_id')
                ->from('finiyear_master')
                ->where('Active_Deactive', 1)
                ->get()
                ->row();
 
if ($finiYear) {
    $fields['Financial_Year'] = $finiYear->finiYear_id;
}


    $insert_id = $this->StudComp_model->insertdata($fields);

    // ✅ Return JSON response immediately
    if (ob_get_level()) ob_end_clean();
    header('Content-Type: application/json');
    echo json_encode(['status' => 'success', 'id' => $insert_id]);

    // ✅ Flush output so JS can show Swal immediately
    if (function_exists('fastcgi_finish_request')) {
        session_write_close();
        fastcgi_finish_request();
    } else {
        session_write_close();
        ignore_user_abort(true);
        flush();
    }

    // ✅ Trigger background email via CURL (non-blocking)
    $background_url = base_url('admin/StudComp/sendEmailBackground/' . $insert_id);
    $ch = curl_init($background_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 1); // don't wait
    curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
    curl_exec($ch);
    curl_close($ch);
}

public function sendEmailBackground($id = null) {
    $complaint = $this->StudComp_model->getComplaintById($id);
    if (!$complaint) return;

    try {
        $this->sendPackageEmail(
            $complaint->Stud_mailId,
            $complaint->Stud_name,
            $complaint->Stud_mobileNo,
            $complaint->StudPRN_NO
        );
        log_message('info', '✅ Email sent for complaint ID: ' . $id);
    } catch (Exception $e) {
        log_message('error', '❌ Email failed for complaint ID ' . $id . ': ' . $e->getMessage());
    }
}



private function sendPackageEmail($Stud_mailId, $Stud_name, $Stud_mobileNo,$StudPRN_NO)
{
    $config = array(
        'protocol'    => 'smtp',
        'smtp_host'   => 'smtp.gmail.com',
        'smtp_port'   => 587,
        'smtp_user'   => 'shrutikamble895@gmail.com',
        'smtp_pass'   => 'pkfgsapvnjakwfyt', // App-specific password
        'smtp_crypto' => 'tls',
        'mailtype'    => 'html',
        'charset'     => 'utf-8',
        'newline'     => "\r\n",
        'crlf'        => "\r\n",
        'wordwrap'    => true
    );

    $this->email->initialize($config);

    // ✅ 1. Send confirmation email to student
    $this->email->from('shrutikamble895@gmail.com', 'Comtranse Technology');
    $this->email->to($Stud_mailId);
    $this->email->reply_to('shrutikamble895@gmail.com', 'Comtranse Technology');
    $this->email->subject('Registration Confirmation from Comtranse');

  $message = "
        A new complaint has been submitted.<br><br>
        <strong>Name:</strong> $Stud_name<br>
        <strong>Mobile:</strong> $Stud_mobileNo<br>
        <strong>Email:</strong> $Stud_mailId<br>
        <strong>PRN:</strong>$StudPRN_NO<br><br>
        Please check the dashboard for full details.
    ";

    $this->email->message($message);

    if (!$this->email->send()) {
        log_message('error', '❌ Student mail failed: ' . print_r($this->email->print_debugger(), true));
    } else {
        log_message('info', '✅ Student mail sent to: ' . $Stud_mailId);
    }

    // ✅ 2. Send office mail
    $this->email->clear(); // clear previous email

    $this->email->from('shrutikamble895@gmail.com', 'Comtranse Technology');
    $this->email->to('nishantshinge5@gmail.com'); // Office email
    $this->email->subject('New Complaint Received from ' . $Stud_name);

   
$officeMessage = '
<html>
<head><title>Student Complaint</title></head>
<body style="font-family: Arial, sans-serif; color: #333;">
    <h2>Complaint from, '.$Stud_name.',</h2>
    <p>Received student complaint successfully.</p>
    <p><strong>Mobile:</strong> '.$Stud_mobileNo.'</p>
    <p><strong>PRN No:</strong> '.$StudPRN_NO.'</p>
    <br>
    <hr>
    <small>This is an automated message sent to '.$Stud_mailId.' to confirm your complaint submission.</small>
</body>
</html>';

    $this->email->message($officeMessage);

    if (!$this->email->send()) {
        log_message('error', '❌ Office mail failed: ' . print_r($this->email->print_debugger(), true));
    } else {
        log_message('info', '✅ Office mail sent to: office@sitcoe.org');
    }
}

	
     public function printComplaint($id) {
    $data['complaint'] = $this->StudComp_model->getComplaintById($id);
 $data['genders'] = $this->StudComp_model->get_all_genders();
         $data['complaint_categories'] = $this->StudComp_model->get_all_complaint_categories();
          $data['branch'] = $this->StudComp_model->get_all_Branch();
           $data['Class'] = $this->StudComp_model->get_all_class();
    $data['heading'] = $this->StudComp_model->getPrintHeadings();


    $this->load->view('admin/complaint_print_view', $data);
} 
   

   
}