<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StudentFeedReport extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('StudentFeedReport_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Report()
    {
        $data['hostelList'] = $this->StudentFeedReport_model->getHostels();
        $data['branchList'] = $this->StudentFeedReport_model->getBranches();
        $data['yearList'] = $this->StudentFeedReport_model->getYears();
        $data['instituteList'] = $this->StudentFeedReport_model->getInstitutes();
        $data['activeYear'] = $this->StudentFeedReport_model->getActiveYear();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/StudentFeedReport_view', $data);
        $this->load->view('admin/footer_view');
    }

    // Get filtered feedback data
    public function getFeedbackData()
    {
        $this->output->set_content_type('application/json');
        
        $hostel_ids = $this->input->post('hostel_ids');
        $branch_ids = $this->input->post('branch_ids');
        $year_ids = $this->input->post('year_ids');
        $Institu_ids = $this->input->post('Institu_ids');
        
        log_message('debug', '=== Feedback Filter Request ===');
        log_message('debug', 'Hostel IDs: ' . json_encode($hostel_ids));
        log_message('debug', 'Branch IDs: ' . json_encode($branch_ids));
        log_message('debug', 'Year IDs: ' . json_encode($year_ids));
        log_message('debug', 'Institute IDs: ' . json_encode($Institu_ids));
        
        try {
            $data = $this->StudentFeedReport_model->getFeedbackDataFiltered(
                $hostel_ids, 
                $branch_ids, 
                $year_ids,
                $Institu_ids
            );
            
            log_message('debug', 'Query Result Count: ' . count($data));
            
            echo json_encode($data, JSON_UNESCAPED_UNICODE);
            
        } catch (Exception $e) {
            log_message('error', 'getFeedbackData error: ' . $e->getMessage());
            echo json_encode([
                'error' => true,
                'message' => $e->getMessage()
            ]);
        }
    }

    // Get combined chart data (branch + year wise)
    public function getChartData()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $branches = $this->input->post('branches');
            $years = $this->input->post('years');
            
            log_message('debug', 'Chart filters - Branches: ' . json_encode($branches) . ', Years: ' . json_encode($years));
            
            $result = $this->StudentFeedReport_model->getCombinedChartData($branches, $years);
            
            echo json_encode([
                "status" => "success",
                "branchData" => $result['branchData'],
                "yearData" => $result['yearData']
            ]);
            
        } catch (Exception $e) {
            log_message('error', 'getChartData error: ' . $e->getMessage());
            echo json_encode([
                "status" => "error",
                "message" => $e->getMessage(),
                "branchData" => [],
                "yearData" => []
            ]);
        }
    }

    // Get detailed data for specific branch
    public function getBranchDetails()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $branch_id = $this->input->post('branch_id');
            $years = $this->input->post('years');
            
            log_message('debug', 'Branch details - ID: ' . $branch_id . ', Years: ' . json_encode($years));
            
            $result = $this->StudentFeedReport_model->getBranchDetailsData($branch_id, $years);
            
            echo json_encode($result);
            
        } catch (Exception $e) {
            log_message('error', 'getBranchDetails error: ' . $e->getMessage());
            echo json_encode([]);
        }
    }

    // Get detailed data for specific year
    public function getYearDetails()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $year_id = $this->input->post('year_id');
            $branches = $this->input->post('branches');
            
            log_message('debug', 'Year details - ID: ' . $year_id . ', Branches: ' . json_encode($branches));
            
            $result = $this->StudentFeedReport_model->getYearDetailsData($year_id, $branches);
            
            echo json_encode([
                "status" => "success",
                "data" => $result
            ]);
            
        } catch (Exception $e) {
            log_message('error', 'getYearDetails error: ' . $e->getMessage());
            echo json_encode([
                "status" => "error",
                "message" => $e->getMessage(),
                "data" => []
            ]);
        }
    }

    // Get print headings for reports
    public function getPrintHeadings()
    {
        $this->output->set_content_type('application/json');
        
        try {
            $headings = $this->StudentFeedReport_model->getPrintHeadings();
            
            if ($headings) {
                echo json_encode($headings);
            } else {
                echo json_encode([
                    'logo' => 'Assets/images/sit_logo.png',
                    'head' => 'Student Feedback Report',
                    'subHead1' => 'Institution Name',
                    'subHead2' => 'Address Line',
                    'subHead3' => 'Contact Information'
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'getPrintHeadings error: ' . $e->getMessage());
            echo json_encode([
                'logo' => 'Assets/images/sit_logo.png',
                'head' => 'Student Feedback Report',
                'subHead1' => '',
                'subHead2' => '',
                'subHead3' => ''
            ]);
        }
    }

// Add this method to your StudentFeedReport.php controller

/**
 * Get feedback details by Feedback ID (for specific student)
 * Returns all feedback responses for a specific student's feedback record
 */
public function getFeedbackDetailsByFeedback()
{
    $this->output->set_content_type('application/json');
    
    try {
        $feedback_id = $this->input->post('feedback_id');
        
        if (empty($feedback_id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Feedback ID is required',
                'data' => []
            ]);
            return;
        }
        
        log_message('debug', 'Fetching feedback details for Feedback ID: ' . $feedback_id);
        
        $data = $this->StudentFeedReport_model->getFeedbackDetailsByFeedback($feedback_id);
        
        if (!empty($data)) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Feedback details retrieved successfully',
                'data' => $data
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => 'No feedback details found',
                'data' => []
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'getFeedbackDetailsByFeedback error: ' . $e->getMessage());
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage(),
            'data' => []
        ]);
    }
}

/**
 * Get feedback details by URL ID (OLD METHOD - keeping for compatibility)
 * Returns all feedback responses for a specific URL
 */
public function getFeedbackDetailsByUrl()
{
    $this->output->set_content_type('application/json');
    
    try {
        $url_id = $this->input->post('url_id');
        
        if (empty($url_id)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'URL ID is required',
                'data' => []
            ]);
            return;
        }
        
        log_message('debug', 'Fetching feedback details for URL ID: ' . $url_id);
        
        $data = $this->StudentFeedReport_model->getFeedbackDetailsByUrl($url_id);
        
        if (!empty($data)) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Feedback details retrieved successfully',
                'data' => $data
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => 'No feedback details found',
                'data' => []
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'getFeedbackDetailsByUrl error: ' . $e->getMessage());
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage(),
            'data' => []
        ]);
    }
}
}