<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student_Counseling extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Student_Counseling_model');
        $this->load->library('upload'); 
         $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Student_Counseling_dash');
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Student_Counseling_model->getdetailview();
        $this->load->view('admin/header_view');
        $this->load->view('admin/Student_Counseling_detailview', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['counseling_types'] = $this->Student_Counseling_model->getCounselingTypes();
        $data['departments'] = $this->Student_Counseling_model->getDepartments();
        $data['yeardata'] = $this->Student_Counseling_model->getyear();
        $data['activeYear'] = $this->Student_Counseling_model->getActiveYear();

// ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Student_Counseling_view', $data);
        $this->load->view('admin/footer_view');
    }

    function insertcounseling()
    {
        $fk_counseling_type = $this->input->post('fk_counseling_type');
        $counseling_date = $this->input->post('counseling_date');
        $fk_department = $this->input->post('fk_department');
        $fk_year = $this->input->post('fk_year');
        $faculty_name = $this->input->post('faculty_name');
        $faculty_thumb = $this->input->post('faculty_thumb');
$fk_submenuId = $this->input->post('fk_submenuId');

        $upload_dir = './uploads/counseling_pdf/';
        $pdf_filename = $this->upload_file('pdf_file', $upload_dir); 
        
        if ($pdf_filename === false && !empty($_FILES['pdf_file']['name'])) {
             echo json_encode(['status' => 'error', 'message' => 'Failed to upload PDF file.']);
             return;
        }
        
        $pdf_file = $pdf_filename ? '/uploads/counseling_pdf/' . $pdf_filename : ''; 

        $fields = array(
            'fk_counseling_type' => $fk_counseling_type,
            'counseling_date' => $counseling_date,
            'fk_department' => $fk_department,
            'fk_year' => $fk_year,
            'faculty_name' => $faculty_name,
            'faculty_thumb' => $faculty_thumb,
            'pdf_file' => $pdf_file, 
            'created_date' => date('Y-m-d H:i:s'),
            'created_by'=>$_SESSION['userID']
        );

        $institute = $this->db
            ->select('Institu_id')
            ->from('institute_master')
            ->get()
            ->row();

        if ($institute) {
            $fields['fkInstitu_id'] = $institute->Institu_id;
        } else {
            $fields['fkInstitu_id'] = 1; 
        }

        $insertSuccess = $this->Student_Counseling_model->insertdata($fields);
        
        // Insert log - Action 1 (Insert)

        $action = 1;

        $record_id = $insertSuccess;

        $excel_name = null;

        $Fk_branch = $fk_department;

        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
        
        if (!$insertSuccess) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert counseling data']);
            return;
        }

        $counseling_id = $this->db->insert_id();

        $student_names = $this->input->post('student_name');
        $prn_nos = $this->input->post('prn_no');
        $mobile_nos = $this->input->post('mobile_no');
        $remarks = $this->input->post('remark');

        if (!empty($student_names)) {
            foreach ($student_names as $i => $name) {
                if (trim($name) == '') continue;
                
                $detailData = array(
                    'fk_counseling_id' => $counseling_id,
                    'student_name' => $name,
                    'prn_no' => $prn_nos[$i] ?? null,
                    'mobile_no' => $mobile_nos[$i] ?? null,
                    'remark' => $remarks[$i] ?? null
                );

                $detailSuccess = $this->Student_Counseling_model->insertDetail($detailData);
                
                if (!$detailSuccess) {
                    echo json_encode(['status' => 'error', 'message' => 'Failed to insert student detail for: ' . $name]);
                    return;
                }
            }
        }

        echo json_encode(['status' => 'success']);
    }

    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Student_Counseling_model->getbyid($id);
        $data['counseling_types'] = $this->Student_Counseling_model->getCounselingTypes();
        $data['departments'] = $this->Student_Counseling_model->getDepartments();
        $data['detailData'] = $this->Student_Counseling_model->getDetailByMainId($id);
        $data['yeardata'] = $this->Student_Counseling_model->getyear();
        $data['activeYear'] = $this->Student_Counseling_model->getActiveYear();

$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Student_Counseling_view', $data);
        $this->load->view('admin/footer_view');
    }

    public function updatecounseling()
    {
        $stud_counseling_id = $this->input->post('stud_counseling_id');
        $fk_counseling_type = $this->input->post('fk_counseling_type');
        $counseling_date = $this->input->post('counseling_date');
        $faculty_name = $this->input->post('faculty_name');
        $faculty_thumb = $this->input->post('faculty_thumb');
        $fk_department = $this->input->post('fk_department');
        $fk_year = $this->input->post('fk_year');
$fk_submenuId = $this->input->post('fk_submenuId');

        $upload_dir = './uploads/counseling_pdf/';
        $existing_pdf = $this->input->post('hidden_pdf'); 
        $pdf_filename = false;

        if (!empty($_FILES['pdf_file']['name'])) {
            $pdf_filename = $this->upload_file('pdf_file', $upload_dir);
            
            if ($pdf_filename === false) {
                 echo json_encode(['status' => 'error', 'message' => 'Failed to upload PDF file. Check permissions/size.']);
                 return;
            }
        }
        
        $pdf_file = $pdf_filename ? '/uploads/counseling_pdf/' . $pdf_filename : $existing_pdf;

        $fields = [
            'stud_counseling_id' => $stud_counseling_id,
            'fk_counseling_type' => $fk_counseling_type,
            'counseling_date' => $counseling_date,
            'faculty_name' => $faculty_name,
            'faculty_thumb' => $faculty_thumb,
            'fk_department' => $fk_department,
            'fk_year' => $fk_year,
            'pdf_file' => $pdf_file, 
            'modified_date' => date('Y-m-d H:i:s'),
            'modified_by'=>$_SESSION['userID']
        ];

        $updateSuccess = $this->Student_Counseling_model->update($fields);
        
        // Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $stud_counseling_id;
        $excel_name = null;
        $Fk_branch = $fk_department;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);
        
        if (!$updateSuccess) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update main counseling data']);
            return;
        }

        $existing_details = $this->Student_Counseling_model->getDetailByMainId($stud_counseling_id);
        $existing_ids = array();
        foreach($existing_details as $detail) {
            $existing_ids[] = $detail->counseling_detail_id;
        }

        $detail_ids = $this->input->post('counseling_detail_id');
        $student_names = $this->input->post('student_name');
        $prn_nos = $this->input->post('prn_no');
        $mobile_nos = $this->input->post('mobile_no');
        $remarks = $this->input->post('remark');

        $processed_ids = array();

        if (!empty($student_names)) {
            foreach ($student_names as $i => $name) {
                if (trim($name) == '') continue;
                
                $detailData = array(
                    'fk_counseling_id' => $stud_counseling_id,
                    'student_name' => $name,
                    'prn_no' => $prn_nos[$i] ?? null,
                    'mobile_no' => $mobile_nos[$i] ?? null,
                    'remark' => $remarks[$i] ?? null
                );

                $existing_id = $detail_ids[$i] ?? null;
                
                if (!empty($existing_id) && is_numeric($existing_id)) {
                    $detailSuccess = $this->Student_Counseling_model->updateDetail($existing_id, $detailData);
                    if (!$detailSuccess) {
                        // This failure is less critical, only warn/log if needed, but not stop the main update success
                    }
                    $processed_ids[] = $existing_id;
                } else {
                    $detailSuccess = $this->Student_Counseling_model->insertDetail($detailData);
                    if (!$detailSuccess) {
                        echo json_encode(['status' => 'error', 'message' => 'Failed to insert new student detail for: ' . $name]);
                        return;
                    }
                }
            }
        }

        $ids_to_delete = array_diff($existing_ids, $processed_ids);
        if (!empty($ids_to_delete)) {
            foreach($ids_to_delete as $delete_id) {
                $deleteSuccess = $this->Student_Counseling_model->deleteDetail($delete_id);
                if (!$deleteSuccess) {
                    echo json_encode(['status' => 'error', 'message' => 'Failed to delete student detail']);
                    return;
                }
            }
        }

        echo json_encode(['status' => 'success']);
    }

    private function upload_file($field_name, $upload_path) {
        if (!empty($_FILES[$field_name]['name'])) {
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'pdf|doc|docx';
            $config['max_size'] = 10000; 
            $config['encrypt_name'] = TRUE; 
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $this->upload->initialize($config); 
            
            if ($this->upload->do_upload($field_name)) {
                $upload_data = $this->upload->data();
                return $upload_data['file_name'];
            } else {
                return false;
            }
        }
        return false;
    }

    public function insert_counseling_type()
    {
        $counseling_name = $this->input->post('counseling_name');
        
        $fields = array(
            'counseling_name' => $counseling_name,
            'created_date' => date('Y-m-d H:i:s')
        );

        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        if ($institute) {
            $fields['fkInstitu_id'] = $institute->Institu_id;
        } else {
            $fields['fkInstitu_id'] = 1;
        }

        $insertSuccess = $this->Student_Counseling_model->insertCounselingType($fields);
        
        if (!$insertSuccess) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert counseling type']);
            return;
        }
        
        echo json_encode(['status' => 'success']);
    }
}