<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Survey extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Survey_model');
        $this->load->helper('url');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }
    
     public function dashboard()
    {
        // $data['alldata'] = $this->Survey_model->getdetailGST();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Survey_dash_view');
        $this->load->view('admin/footer_view');
    }

    public function create($institute_id = null, $Hostel_id = null, $financial_year_id = null)
    {
        // Validate required parameters
        if (empty($institute_id) || empty($Hostel_id) || empty($financial_year_id)) {
            show_error('Invalid parameters. Please provide institute_id, Hostel_id, and financial_year_id.');
            return;
        }

        // Get the current URL
        $current_url = current_url(); // Gets the full current URL
        
        // Fetch fkURL_id and is_active from student_feedback_urls table by matching the URL
        $this->db->select('url_id, is_active, generated_url');
        $this->db->from('student_feedback_urls');
        $this->db->where('fkInsitute_id', $institute_id);
        $this->db->where('fkHostelType_id', $Hostel_id);
        $this->db->where('FiniYear', $financial_year_id);
        $url_data = $this->db->get()->row();
        
        // If URL record exists, validate it
        $fkURL_id = null;
        if ($url_data) {
            // Check if URL is active
            if ($url_data->is_active == 0) {
                $this->show_error_page('This URL is Expired', 'This feedback URL is no longer active. Please contact your administrator.');
                return;
            }
            
            // Get fkURL_id
            $fkURL_id = $url_data->url_id;
        }

        // Fetch heading data where is_active = 1
        $this->db->select('subHead1, head, logo, subHead2, subHead3');
        $this->db->from('heading_master');
        $this->db->where('is_active', 1);
        $this->db->where('is_on', 1);
        $heading_data = $this->db->get()->row();

        // Fetch specific financial year data using ID from URL
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('finiYear_id', $financial_year_id);
        $financial_year = $this->db->get()->row();

        // Validate financial year exists
        if (!$financial_year) {
            show_error('Invalid financial year ID.');
            return;
        }

        // Fetch specific institute data using ID from URL
        $this->db->select('Institu_id, Institu_Name');
        $this->db->from('institute_master');
        $this->db->where('Institu_id', $institute_id);
        $institute_data = $this->db->get()->row();

        // Validate institute exists
        if (!$institute_data) {
            show_error('Invalid institute ID.');
            return;
        }

        // Fetch specific hostel type data using ID from URL
        $this->db->select('Hostel_id, Hostel_Name');
        $this->db->from('hostel_master');
        $this->db->where('Hostel_id', $Hostel_id);
        $hostel_type_data = $this->db->get()->row();

        // Validate hostel type exists
        if (!$hostel_type_data) {
            show_error('Invalid hostel type ID.');
            return;
        }

        // Fetch survey structure (headings and subheadings)
        $survey_structure = $this->Survey_model->get_survey_structure();
        
        // Fetch options
        $options = $this->Survey_model->get_options();

        // Fetch branches from branch_master table
        $branches = $this->Survey_model->get_branches();

        // Prepare data array for view
        $data['heading'] = $heading_data;
        $data['financial_year'] = $financial_year;
        $data['institute_id'] = $institute_data->Institu_id;
        $data['institute_name'] = $institute_data->Institu_Name;
        $data['Hostel_id'] = $hostel_type_data->Hostel_id;
        $data['Hostel_Name'] = $hostel_type_data->Hostel_Name;
        $data['fkURL_id'] = $fkURL_id; // Pass fkURL_id to view
        $data['survey_structure'] = $survey_structure;
        $data['options'] = $options;
        $data['branches'] = $branches;

        $this->load->view('admin/Survey_view', $data);
    }

    // Custom error page for URL validation errors
    private function show_error_page($title, $message)
    {
        $error_html = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>' . $title . '</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: "Segoe UI", Tahoma, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .error-container {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .error-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            border-radius: 50%;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            color: white;
        }
        .error-container h1 {
            font-size: 24px;
            color: #333;
            margin-bottom: 15px;
            font-weight: 600;
        }
        .error-container p {
            color: #666;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 25px;
        }
        .contact-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            font-size: 14px;
            color: #666;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">⚠️</div>
        <h1>' . $title . '</h1>
        <p>' . $message . '</p>
        <div class="contact-info">
            <strong>Need Help?</strong><br>
            Please contact your college administrator for assistance.
        </div>
    </div>
</body>
</html>';
        
        echo $error_html;
        exit;
    }

    public function submit_survey()
    {
        // Get student information
        $student_name = $this->input->post('studentName');
        $prn_number = $this->input->post('prnNumber');
        $branch = $this->input->post('branch');
        
        // Get financial year ID, institute ID, hostel type ID, and fkURL_id from hidden fields
        $financial_year_id = $this->input->post('financial_year_id');
        $institute_id = $this->input->post('institute_id');
        $Hostel_id = $this->input->post('Hostel_id');
        $fkURL_id = $this->input->post('fkURL_id'); // Get fkURL_id from POST
        
        // Validate student information
        if (empty($student_name) || empty($prn_number) || empty($branch)) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Please provide all student information'
            ]);
            return;
        }
        
        // Verify URL is still active before submission
        if (!empty($fkURL_id)) {
            $this->db->select('is_active');
            $this->db->from('student_feedback_urls');
            $this->db->where('url_id', $fkURL_id);
            $url_check = $this->db->get()->row();
            
            if (!$url_check || $url_check->is_active == 0) {
                echo json_encode([
                    'status' => 'error', 
                    'message' => 'This feedback URL is no longer active. Please contact your administrator.'
                ]);
                return;
            }
        }
        
        // Check if student has already submitted feedback
        if ($this->Survey_model->check_submission_exists($prn_number)) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'You have already submitted feedback for this year.'
            ]);
            return;
        }
        
        // Get branch ID from branch name
        $this->db->select('branch_id');
        $this->db->from('branch_master');
        $this->db->where('branch_name', $branch);
        $branch_data = $this->db->get()->row();
        
        $branch_id = $branch_data ? $branch_data->branch_id : NULL;
        
        // Start transaction
        $this->db->trans_start();
        
        // Insert into feedback_main table
        $feedback_main_data = [
            'student_name' => $student_name,
            'branchId' => $branch_id,
            'prnno' => $prn_number,
            'financial_year_id' => $financial_year_id,
            'institute_id' => $institute_id,
            'Hostel_id' => $Hostel_id,
            'fkURL_id' => !empty($fkURL_id) ? $fkURL_id : NULL, // Save fkURL_id
            'is_default' => 0
        ];
        
        $this->db->insert('feedback_main', $feedback_main_data);
        $feedback_id = $this->db->insert_id();
        
        // Get all POST data for detail responses
        $responses = $this->input->post();
        
        // Process and save responses to feedback_detail
        $detail_data = [];
        foreach ($responses as $key => $value) {
            if (strpos($key, 'q') === 0) { // Questions are named like q5, q6, etc.
                $subheading_id = str_replace('q', '', $key);
                
                // Get heading_id from subheading_id
                $this->db->select('heading_id');
                $this->db->from('feedbacksubheading');
                $this->db->where('subheading_id', $subheading_id);
                $heading_result = $this->db->get()->row();
                
                if ($heading_result) {
                    $detail_data[] = [
                        'feedback_id' => $feedback_id,
                        'heading_id' => $heading_result->heading_id,
                        'subheading_id' => $subheading_id,
                        'option_id' => $value,
                        'is_default' => 0
                    ];
                }
            }
        }
        
        // Check if we have responses to save
        if (empty($detail_data)) {
            $this->db->trans_rollback();
            echo json_encode([
                'status' => 'error', 
                'message' => 'No survey responses found'
            ]);
            return;
        }
        
        // Insert all detail responses using batch insert
        $this->db->insert_batch('feedback_detail', $detail_data);
        
        // Complete transaction
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === FALSE) {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Error submitting survey. Please try again.'
            ]);
        } else {
            echo json_encode([
                'status' => 'success', 
                'message' => 'Survey submitted successfully! Thank you for your feedback.'
            ]);
        }
    }
}