<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tech_report extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Tech_report_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


   
   
    public function create()
	{
  $data['branchdata'] = $this->Tech_report_model->getbranch();
 $data['levaldata'] = $this->Tech_report_model->getlevel();
  $data['institutedata'] = $this->Tech_report_model->getinstitu();
    $data['partydata'] = $this->Tech_report_model->getparti();
  $data['eventsdata'] = $this->Tech_report_model->getevent();
    $data['classdata'] = $this->Tech_report_model->getclass();
    $data['rankdata'] = $this->Tech_report_model->getrank();
    $data['typedata'] = $this->Tech_report_model->gettype();
        $data['profdata'] = $this->Tech_report_model->getproff();
        $data['eventdata'] = $this->Tech_report_model->geteventnames();


$data['yeardata'] = $this->Tech_report_model->getyear();


$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/Tech_report_view',$data);
		$this->load->view('admin/footer_view');
	

	}


 public function showDataByInstitute() {
        $institute_ids = $this->input->post('fk_institu');
        $branch_ids = $this->input->post('fkbranch_id');
        $class_ids = $this->input->post('fk_class');
        $level_ids = $this->input->post('fk_leval');
        $event_types = $this->input->post('fk_eventtype');
        $participate_types = $this->input->post('fk_particiType');
        $rank_name = $this->input->post('fk_rank');
        $type_name = $this->input->post('fk_type');
         $prof_bodyName = $this->input->post('fk_pofessional');
        $year = $this->input->post('year');

        $data = $this->Tech_report_model->getDataByInstitute(
            $year,
            $institute_ids,
            $branch_ids,
            $class_ids,
            $level_ids,
            $event_types,
            $participate_types,
            $rank_name,
            $type_name,
            $prof_bodyName
        );

        echo json_encode($data);
    }


// for print
public function getPrintHeadings()
{
    $data = $this->Tech_report_model->getPrintHeadings();
    echo json_encode($data);
}

// year and branch chart
 
 
 public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $events    = $this->input->post('events');   // array of event names
    $years     = $this->input->post('years');    // array of years

    $result = $this->Tech_report_model->getCombinedData($institu, $events, $years);

    echo json_encode([
        "status"     => "success",
        "eventData"  => $result['eventData'],   // ✅ Eventwise
        "yearData"   => $result['yearData']     // ✅ Yearwise
    ]);
}

public function getEventDetails()
{
    $eventName = $this->input->post('event_name');
    $institu   = $this->input->post('fk_institu');
    $year      = $this->input->post('year');

    $result = $this->Tech_report_model->getEventDetailsData($eventName, $institu, $year);
    echo json_encode($result);
}

// public function getYearwiseData()
// {
//     $year = $this->input->post('year');

//     if ($year == "0" || empty($year)) {
//         $summary = $this->Tech_report_model->getAllYearsData();
//         $types   = [];
//     } else {
//         $summary = $this->Tech_report_model->getSingleYearData($year);
//         $types   = $this->Tech_report_model->getYearwiseTypes($year);
//     }

//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }
 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $events  = $this->input->post('events');   // may be an array
    
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->Tech_report_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->Tech_report_model->getSingleYearData($year, $events);
        $types   = $this->Tech_report_model->getYearwiseTypes($year,$events);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}


}
