<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class TotalPlace extends CI_Controller {
	
    public function __construct()
    {
        parent::__construct();
        $this->load->model('TotalPlace_model');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }


   
   
    public function create()
	{
  $data['branchdata'] = $this->TotalPlace_model->getbranch();
 $data['companydata'] = $this->TotalPlace_model->getcompany();
  $data['institutedata'] = $this->TotalPlace_model->getinstitu();
    $data['catdata'] = $this->TotalPlace_model->getcat();
  $data['typedata'] = $this->TotalPlace_model->gettype();
    $data['classdata'] = $this->TotalPlace_model->getclass();
    $data['packdata'] = $this->TotalPlace_model->getsalary();
 $data['placedata'] = $this->TotalPlace_model->getplace();
  $data['divdata'] = $this->TotalPlace_model->getdiv();   

$data['yeardata'] = $this->TotalPlace_model->getyear();


$activeYear = $this->db
    ->select('finiYear_id')
    ->from('finiyear_master')
    ->where('Active_Deactive', 1)
    ->get()
    ->row();

$data['active_year_id'] = $activeYear ? $activeYear->finiYear_id : 0;
        
        //  echo "<pre>";
        // print_r($data);

		$this->load->view('admin/header_view');
		$this->load->view('admin/TotalPlace_view',$data);
		$this->load->view('admin/footer_view');
	

	}



public function showDataByInstitute()
{
    $institute_id = $this->input->post('fk_institu');
    $branch_ids = $this->input->post('fkbranch_id'); 
    $class_ids = $this->input->post('fk_class');
    $company_types = $this->input->post('fk_type');
    $company_categories = $this->input->post('fk_cat');
    $company_ids = $this->input->post('fk_company');
        $div_ids = $this->input->post('fk_div');
    $ids = $this->input->post('fk_place');
    $year = $this->input->post('year');
$salary_ids = $this->input->post('fksalary');

    $data = $this->TotalPlace_model->getDataByInstitute(
        $institute_id,
        $year,
        $branch_ids,
        $class_ids,
        $company_types,
        $company_categories,
        $company_ids,
        $div_ids,
        $ids,
         $salary_ids  
    );

    echo json_encode($data);
}

// for print
public function getPrintHeadings()
{
    $data = $this->TotalPlace_model->getPrintHeadings();
    echo json_encode($data);
}

// year and branch chart
 
 
// public function getYearwiseData()
// {
//     $year = $this->input->post('year');
 
//     if ($year == "0" || empty($year)) {
//         // All years
//         $summary = $this->TotalPlace_model->getAllYearsData();
//         $types   = [];
//     } else {
//         // Single year
//         $summary = $this->TotalPlace_model->getSingleYearData($year);
//         $types   = $this->TotalPlace_model->getYearwiseTypes($year);
//     }
 
//     echo json_encode([
//         "status"  => "success",
//         "summary" => $summary,
//         "types"   => $types
//     ]);
// }



 public function getYearwiseData()
{
    $year      = $this->input->post('year');
    $branches  = $this->input->post('branches');   // may be an array
    
 
    if ($year == "0" || empty($year)) {
        // All years
        $summary = $this->TotalPlace_model->getAllYearsData();
        $types   = [];
    } else {
        // Single year — pass all filters
        $summary = $this->TotalPlace_model->getSingleYearData($year, $branches);
        $types   = $this->TotalPlace_model->getYearwiseTypes($year,$branches);
    }
 
    echo json_encode([
        "status"  => "success",
        "summary" => $summary,
        "types"   => $types
    ]);
}
 
 
 
// Add these methods to your VAPReport controller
 
public function getBranchwiseData()
{
    $institu   = $this->input->post('fk_institu'); // match JS
    $branches  = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
 
    $result = $this->TotalPlace_model->getBranchwiseCount($institu, $branches, $year);
    echo json_encode($result);
}
 
public function getBranchDetails()
{
    $branch_id = $this->input->post('branch_id'); // correct
    $institu   = $this->input->post('fkBranchName_id'); // match JS
    $year      = $this->input->post('year');
   
    $result = $this->TotalPlace_model->getBranchDetailsData($branch_id, $institu, $year);
    echo json_encode($result);
}
 
 
public function getCombinedData()
{
    $institu   = $this->input->post('fk_institu');
    $branches  = $this->input->post('branches');   // array
    $years     = $this->input->post('years');      // array
  
    $result = $this->TotalPlace_model->getCombinedData($institu, $branches, $years);
 
    echo json_encode([
        "status"      => "success",
        "branchData"  => $result['branchData'],
        "yearData"    => $result['yearData']
    ]);
}
 
 


}
