<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class VAP extends CI_Controller {
   
    public function __construct()
    {
        parent::__construct();
        $this->load->model('VAP_model');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->load->model('Log_model');
        $this->load->helper('log');
         if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
 
        }
    }

    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/VAP_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->VAP_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/VAP_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['branchdata'] = $this->VAP_model->getbranch();
        $data['classdata'] = $this->VAP_model->getclass();
        $data['companydata'] = $this->VAP_model->getcompany();
        $data['yeardata'] = $this->VAP_model->getyear();
        // ✅ Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // ✅ Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/VAP_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    
    public function insertvap()
    {
        try {
            $this->output->set_content_type('application/json');

             $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
            $institute_id = $institute ? $institute->Institu_id : null;
            
            // Get arrays from POST
            $prn = $this->input->post('prn');
            $student_name = $this->input->post('student_name');
            $branch_id = $this->input->post('branch_id');
            $class_id = $this->input->post('class_id');
            $division = $this->input->post('division');
            $vap_title = $this->input->post('vap_title');
            $resource_person_name = $this->input->post('resource_person_name');
            $resource_person_contact = $this->input->post('resource_person_contact');
            $company_id = $this->input->post('company_id');
            $address = $this->input->post('address');
            $year = $this->input->post('year');
            $vap_start_date = $this->input->post('vap_start_date');
            $vap_end_date = $this->input->post('vap_end_date');
            $photo_url = $this->input->post('photo_url');
            $fk_submenuId = $this->input->post('fk_submenuId');

            // Get new master data
            $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
            $new_classes = json_decode($this->input->post('new_classes'), true) ?: [];
            $new_companies = json_decode($this->input->post('new_companies'), true) ?: [];
            $new_years = json_decode($this->input->post('new_years'), true) ?: [];
            
            log_message('debug', 'PRNs received: ' . print_r($prn, true));
            log_message('debug', 'New Branches: ' . print_r($new_branches, true));
            
            // Validation
            if (empty($prn) || !is_array($prn)) {
                echo json_encode(['status' => 'error', 'message' => 'At least one record is required']);
                return;
            }
            
            // Create mapping arrays
            $branch_mapping = [];
            $class_mapping = [];
            $company_mapping = [];
            $year_mapping = [];
            
            $masters_created = [
                'branches' => 0,
                'classes' => 0,
                'companies' => 0,
                'years' => 0
            ];
            
            // Insert new branches
            foreach ($new_branches as $branch_name) {
                if (!empty($branch_name)) {
                    $existing_id = $this->VAP_model->getBranchIdByName($branch_name);
                    
                    if ($existing_id) {
                        $branch_mapping['NEW::' . $branch_name] = $existing_id;
                    } else {
                        $branch_data = ['branch_name' => $branch_name];
                        $new_branch_id = $this->VAP_model->insert_branch($branch_name);
                        if ($new_branch_id) {
                            $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                            $masters_created['branches']++;
                        }
                    }
                }
            }
            
            // Insert new classes
            foreach ($new_classes as $class_name) {
                if (!empty($class_name)) {
                    $existing_id = $this->VAP_model->getClassIdByName($class_name);
                    
                    if ($existing_id) {
                        $class_mapping['NEW::' . $class_name] = $existing_id;
                    } else {
                        $new_class_id = $this->VAP_model->insert_class($class_name);
                        if ($new_class_id) {
                            $class_mapping['NEW::' . $class_name] = $new_class_id;
                            $masters_created['classes']++;
                        }
                    }
                }
            }
            
            // Insert new companies
            foreach ($new_companies as $company_name) {
                if (!empty($company_name)) {
                    $existing_id = $this->VAP_model->getCompanyIdByName($company_name);
                    
                    if ($existing_id) {
                        $company_mapping['NEW::' . $company_name] = $existing_id;
                    } else {
                        $new_company_id = $this->VAP_model->insert_company($company_name);
                        if ($new_company_id) {
                            $company_mapping['NEW::' . $company_name] = $new_company_id;
                            $masters_created['companies']++;
                        }
                    }
                }
            }
            
            // Insert new years
            foreach ($new_years as $year_name) {
                if (!empty($year_name)) {
                    $existing_id = $this->VAP_model->getYearIdByName($year_name);
                    
                    if ($existing_id) {
                        $year_mapping['NEW::' . $year_name] = $existing_id;
                    } else {
                        $new_year_id = $this->VAP_model->insert_year($year_name);
                        if ($new_year_id) {
                            $year_mapping['NEW::' . $year_name] = $new_year_id;
                            $masters_created['years']++;
                        }
                    }
                }
            }
            
            // Handle excel file upload
            $excel_name = null;
            if (!empty($_FILES['excel_file']['name'])) {
                $upload_path = './uploads/excel/';
                
                if (!is_dir($upload_path)) {
                    mkdir($upload_path, 0777, true);
                }
                
                $config['upload_path'] = $upload_path;
                $config['allowed_types'] = 'xlsx|xls';
                $config['max_size'] = 10240;
                $config['file_name'] = 'vap_excel_' . time() . '_' . $_FILES['excel_file']['name'];
                $config['overwrite'] = FALSE;
                
                $this->upload->initialize($config);
                
                if ($this->upload->do_upload('excel_file')) {
                    $upload_data = $this->upload->data();
                    $excel_name = $upload_data['file_name'];
                }
            }
            
            // Handle feedback files
            $feedback_files = [];
            $total_rows = count($prn);
            
            if (isset($_FILES['feedback'])) {
                $feedback_path = './uploads/feedback/';
                if (!is_dir($feedback_path)) {
                    mkdir($feedback_path, 0777, true);
                }
                
                if (isset($_FILES['feedback']['name']) && is_array($_FILES['feedback']['name'])) {
                    for ($i = 0; $i < $total_rows; $i++) {
                        $feedback_files[$i] = '';
                        
                        if (isset($_FILES['feedback']['name'][$i]) && 
                            $_FILES['feedback']['name'][$i] != '' && 
                            isset($_FILES['feedback']['error'][$i]) && 
                            $_FILES['feedback']['error'][$i] == 0) {
                            
                            $_FILES['single_feedback']['name'] = $_FILES['feedback']['name'][$i];
                            $_FILES['single_feedback']['type'] = $_FILES['feedback']['type'][$i];
                            $_FILES['single_feedback']['tmp_name'] = $_FILES['feedback']['tmp_name'][$i];
                            $_FILES['single_feedback']['error'] = $_FILES['feedback']['error'][$i];
                            $_FILES['single_feedback']['size'] = $_FILES['feedback']['size'][$i];
                            
                            $config['upload_path'] = $feedback_path;
                            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
                            $config['max_size'] = 5120;
                            $config['file_name'] = 'feedback_' . time() . '_' . $i . '_' . $_FILES['single_feedback']['name'];
                            
                            $this->upload->initialize($config);
                            
                            if ($this->upload->do_upload('single_feedback')) {
                                $upload_data = $this->upload->data();
                                $feedback_files[$i] = $upload_data['file_name'];
                            }
                        }
                    }
                }
            }

            $inserted_count = 0;
            $failed_count = 0;

            // Insert all VAP records
            for ($i = 0; $i < $total_rows; $i++) {
                // Skip if PRN is empty
                if (empty($prn[$i]) || trim($prn[$i]) == '') {
                    $failed_count++;
                    continue;
                }
                
                // Resolve branch ID
                $resolved_branch_id = isset($branch_id[$i]) && !empty($branch_id[$i]) ? $branch_id[$i] : null;
                if ($resolved_branch_id && strpos($resolved_branch_id, 'NEW::') === 0) {
                    if (isset($branch_mapping[$resolved_branch_id])) {
                        $resolved_branch_id = $branch_mapping[$resolved_branch_id];
                    } else {
                        $resolved_branch_id = null;
                    }
                }
                
                // Resolve class ID
                $resolved_class_id = isset($class_id[$i]) && !empty($class_id[$i]) ? $class_id[$i] : null;
                if ($resolved_class_id && strpos($resolved_class_id, 'NEW::') === 0) {
                    if (isset($class_mapping[$resolved_class_id])) {
                        $resolved_class_id = $class_mapping[$resolved_class_id];
                    } else {
                        $resolved_class_id = null;
                    }
                }
                
                // Resolve company ID
                $resolved_company_id = isset($company_id[$i]) && !empty($company_id[$i]) ? $company_id[$i] : null;
                if ($resolved_company_id && strpos($resolved_company_id, 'NEW::') === 0) {
                    if (isset($company_mapping[$resolved_company_id])) {
                        $resolved_company_id = $company_mapping[$resolved_company_id];
                    } else {
                        $resolved_company_id = null;
                    }
                }
                
                // Resolve year ID
                $resolved_year_id = isset($year[$i]) && !empty($year[$i]) ? $year[$i] : null;
                if ($resolved_year_id && strpos($resolved_year_id, 'NEW::') === 0) {
                    if (isset($year_mapping[$resolved_year_id])) {
                        $resolved_year_id = $year_mapping[$resolved_year_id];
                    } else {
                        $resolved_year_id = null;
                    }
                }
                
                // Prepare data for insertion
                $vapData = array(
                    'prn' => trim($prn[$i]),
                    'Student_name' => isset($student_name[$i]) ? trim($student_name[$i]) : null,
                    'fkbranch_id' => $resolved_branch_id,
                    'fkclass_id' => $resolved_class_id,
                    'Division' => isset($division[$i]) ? trim($division[$i]) : null,
                    'Vap_tittle' => isset($vap_title[$i]) ? trim($vap_title[$i]) : null,
                    'resource_person_name' => isset($resource_person_name[$i]) ? trim($resource_person_name[$i]) : null,
                    'resource_person_contact' => isset($resource_person_contact[$i]) ? trim($resource_person_contact[$i]) : null,
                    'Company_name' => $resolved_company_id,
                    'Address' => isset($address[$i]) ? trim($address[$i]) : null,
                    'Vap_Start' => isset($vap_start_date[$i]) && !empty($vap_start_date[$i]) ? $vap_start_date[$i] : null,
                    'Vap_End' => isset($vap_end_date[$i]) && !empty($vap_end_date[$i]) ? $vap_end_date[$i] : null,
                    'Photo_Url' => isset($photo_url[$i]) ? trim($photo_url[$i]) : null,
                    'Feedback' => isset($feedback_files[$i]) ? $feedback_files[$i] : null,
                    'finicial_Year' => $resolved_year_id,
                     'institute' => $institute_id, // Use the institute_id we retrieved
                    'excel_file' => $excel_name,
                    'created_by'=>$_SESSION['userID']
                );

                log_message('debug', "Inserting row {$i}: " . print_r($vapData, true));

                // if ($this->VAP_model->insertVAP($vapData)) {
                //     $inserted_count++;
                // } 
                $inserted_id = $this->VAP_model->insertVAP($vapData);

if ($inserted_id) {

    $inserted_count++;

    // 🔹 log insert
    $action = 1; // Insert
    $record_id = $inserted_id;
    $excel_name = null;
    $Fk_branch = null;

    insert_log(
        $this,
        $fk_submenuId,
        $action,
        $record_id,
        $excel_name,
        $Fk_branch,
        $_SESSION['userID']
    );
}

                
                else {
                    $failed_count++;
                }
            }

            // Prepare response
            if ($inserted_count > 0) {
                $message = "Successfully saved {$inserted_count} out of {$total_rows} VAP records";
                if ($failed_count > 0) {
                    $message .= ". {$failed_count} records failed or were skipped.";
                }
                
                echo json_encode([
                    'status' => 'success', 
                    'inserted_count' => $inserted_count,
                    'failed_count' => $failed_count,
                    'total_rows' => $total_rows,
                    'masters_created' => $masters_created,
                    'message' => $message
                ]);
            } else {
                echo json_encode([
                    'status' => 'error', 
                    'message' => "No records were saved. Total rows: {$total_rows}, Failed: {$failed_count}"
                ]);
            }
            
        } catch (Exception $e) {
            log_message('error', 'VAP insertion error: ' . $e->getMessage());
            echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
        }
    }

    


public function update($vap_id)
{
    // Get existing record
    $data['record'] = $this->VAP_model->getVAPById($vap_id);
    
    if (!$data['record']) {
        show_404();
        return;
    }
    
    // Get master data for dropdowns
    $data['branchdata'] = $this->VAP_model->getbranch();
    $data['classdata'] = $this->VAP_model->getclass();
    $data['companydata'] = $this->VAP_model->getcompany();
    $data['yeardata'] = $this->VAP_model->getyear();
    
    // Set empty childData for update mode (we only show single record)
    $data['childData'] = [];
    $data['mainData'] = $data['record']; // For hidden vap_id field
    
$current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
    // ✅ Fetch SubID from database
    $data['subId'] = $this->Log_model->getsubID($current_url);

    $this->load->view('admin/header_view');
    $this->load->view('admin/VAP_view.php', $data);
    $this->load->view('admin/footer_view');
}

public function updateVAP()
{
    try {
        $this->output->set_content_type('application/json');
        
        $vap_id = $this->input->post('vap_id');
        
        if (empty($vap_id)) {
            echo json_encode(['status' => 'error', 'message' => 'VAP ID is required']);
            return;
        }
        
        // Get form data - Arrays
        $prn = $this->input->post('prn');
        $student_name = $this->input->post('student_name');
        $branch_id = $this->input->post('branch_id');
        $class_id = $this->input->post('class_id');
        $division = $this->input->post('division');
        $vap_title = $this->input->post('vap_title');
        $resource_person_name = $this->input->post('resource_person_name');
        $resource_person_contact = $this->input->post('resource_person_contact');
        $company_id = $this->input->post('company_id');
        $address = $this->input->post('address');
        $year = $this->input->post('year');
        $vap_start_date = $this->input->post('vap_start_date');
        $vap_end_date = $this->input->post('vap_end_date');
        $photo_url = $this->input->post('photo_url');
        $fk_submenuId = $this->input->post('fk_submenuId');

        if (empty($prn) || !is_array($prn) || empty($prn[0])) {
            echo json_encode(['status' => 'error', 'message' => 'PRN is required']);
            return;
        }
        
        // Get new master data
        $new_branches = json_decode($this->input->post('new_branches'), true) ?: [];
        $new_classes = json_decode($this->input->post('new_classes'), true) ?: [];
        $new_companies = json_decode($this->input->post('new_companies'), true) ?: [];
        $new_years = json_decode($this->input->post('new_years'), true) ?: [];
        
        // Create mapping arrays
        $branch_mapping = [];
        $class_mapping = [];
        $company_mapping = [];
        $year_mapping = [];
        
        // Insert new branches
        foreach ($new_branches as $branch_name) {
            if (!empty($branch_name)) {
                $existing_id = $this->VAP_model->getBranchIdByName($branch_name);
                
                if ($existing_id) {
                    $branch_mapping['NEW::' . $branch_name] = $existing_id;
                } else {
                    $new_branch_id = $this->VAP_model->insert_branch($branch_name);
                    if ($new_branch_id) {
                        $branch_mapping['NEW::' . $branch_name] = $new_branch_id;
                    }
                }
            }
        }
        
        // Insert new classes
        foreach ($new_classes as $class_name) {
            if (!empty($class_name)) {
                $existing_id = $this->VAP_model->getClassIdByName($class_name);
                
                if ($existing_id) {
                    $class_mapping['NEW::' . $class_name] = $existing_id;
                } else {
                    $new_class_id = $this->VAP_model->insert_class($class_name);
                    if ($new_class_id) {
                        $class_mapping['NEW::' . $class_name] = $new_class_id;
                    }
                }
            }
        }
        
        // Insert new companies
        foreach ($new_companies as $company_name) {
            if (!empty($company_name)) {
                $existing_id = $this->VAP_model->getCompanyIdByName($company_name);
                
                if ($existing_id) {
                    $company_mapping['NEW::' . $company_name] = $existing_id;
                } else {
                    $new_company_id = $this->VAP_model->insert_company($company_name);
                    if ($new_company_id) {
                        $company_mapping['NEW::' . $company_name] = $new_company_id;
                    }
                }
            }
        }
        
        // Insert new years
        foreach ($new_years as $year_name) {
            if (!empty($year_name)) {
                $existing_id = $this->VAP_model->getYearIdByName($year_name);
                
                if ($existing_id) {
                    $year_mapping['NEW::' . $year_name] = $existing_id;
                } else {
                    $new_year_id = $this->VAP_model->insert_year($year_name);
                    if ($new_year_id) {
                        $year_mapping['NEW::' . $year_name] = $new_year_id;
                    }
                }
            }
        }
        
        // Get first row data
        $prn_val = isset($prn[0]) ? $prn[0] : null;
        $student_name_val = isset($student_name[0]) ? $student_name[0] : null;
        $branch_val = isset($branch_id[0]) ? $branch_id[0] : null;
        $class_val = isset($class_id[0]) ? $class_id[0] : null;
        $division_val = isset($division[0]) ? $division[0] : null;
        $vap_title_val = isset($vap_title[0]) ? $vap_title[0] : null;
        $resource_person_name_val = isset($resource_person_name[0]) ? $resource_person_name[0] : null;
        $resource_person_contact_val = isset($resource_person_contact[0]) ? $resource_person_contact[0] : null;
        $company_val = isset($company_id[0]) ? $company_id[0] : null;
        $address_val = isset($address[0]) ? $address[0] : null;
        $year_val = isset($year[0]) ? $year[0] : null;
        $vap_start_date_val = isset($vap_start_date[0]) ? $vap_start_date[0] : null;
        $vap_end_date_val = isset($vap_end_date[0]) ? $vap_end_date[0] : null;
        $photo_url_val = isset($photo_url[0]) ? $photo_url[0] : null;
        
        // Resolve branch ID
        $resolved_branch_id = $branch_val;
        if ($branch_val && strpos($branch_val, 'NEW::') === 0) {
            if (isset($branch_mapping[$branch_val])) {
                $resolved_branch_id = $branch_mapping[$branch_val];
            } else {
                $resolved_branch_id = null;
            }
        }
        
        // Resolve class ID
        $resolved_class_id = $class_val;
        if ($class_val && strpos($class_val, 'NEW::') === 0) {
            if (isset($class_mapping[$class_val])) {
                $resolved_class_id = $class_mapping[$class_val];
            } else {
                $resolved_class_id = null;
            }
        }
        
        // Resolve company ID
        $resolved_company_id = $company_val;
        if ($company_val && strpos($company_val, 'NEW::') === 0) {
            if (isset($company_mapping[$company_val])) {
                $resolved_company_id = $company_mapping[$company_val];
            } else {
                $resolved_company_id = null;
            }
        }
        
        // Resolve year ID
        $resolved_year_id = $year_val;
        if ($year_val && strpos($year_val, 'NEW::') === 0) {
            if (isset($year_mapping[$year_val])) {
                $resolved_year_id = $year_mapping[$year_val];
            } else {
                $resolved_year_id = null;
            }
        }
        
        // Get existing record
        $existing_record = $this->VAP_model->getVAPById($vap_id);
        
        // Handle excel file upload
        $excel_name = null;
        if (!empty($_FILES['excel_file']['name'])) {
            $upload_path = './uploads/excel/';
            
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $config['upload_path'] = $upload_path;
            $config['allowed_types'] = 'xlsx|xls';
            // $config['max_size'] = 10240;
            $config['file_name'] = 'vap_excel_' . time() . '_' . $_FILES['excel_file']['name'];
            $config['overwrite'] = FALSE;
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('excel_file')) {
                $upload_data = $this->upload->data();
                $excel_name = $upload_data['file_name'];
                
                // Delete old file
                if ($existing_record && !empty($existing_record->excel_file)) {
                    $old_file = $upload_path . $existing_record->excel_file;
                    if (file_exists($old_file)) {
                        unlink($old_file);
                    }
                }
            }
        } else {
            $excel_name = $existing_record ? $existing_record->excel_file : null;
        }
        
        // Handle feedback file upload
        $feedback_name = null;
        if (!empty($_FILES['feedback']['name'][0])) {
            $feedback_path = './uploads/feedback/';
            
            if (!is_dir($feedback_path)) {
                mkdir($feedback_path, 0777, true);
            }
            
            $_FILES['single_feedback']['name'] = $_FILES['feedback']['name'][0];
            $_FILES['single_feedback']['type'] = $_FILES['feedback']['type'][0];
            $_FILES['single_feedback']['tmp_name'] = $_FILES['feedback']['tmp_name'][0];
            $_FILES['single_feedback']['error'] = $_FILES['feedback']['error'][0];
            $_FILES['single_feedback']['size'] = $_FILES['feedback']['size'][0];
            
            $config['upload_path'] = $feedback_path;
            $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
            // $config['max_size'] = 5120;
            $config['file_name'] = 'feedback_' . time() . '_' . $_FILES['single_feedback']['name'];
            
            $this->upload->initialize($config);
            
            if ($this->upload->do_upload('single_feedback')) {
                $upload_data = $this->upload->data();
                $feedback_name = $upload_data['file_name'];
                
                // Delete old feedback file
                if ($existing_record && !empty($existing_record->Feedback)) {
                    $old_file = $feedback_path . $existing_record->Feedback;
                    if (file_exists($old_file)) {
                        unlink($old_file);
                    }
                }
            }
        } else {
            $feedback_name = $existing_record ? $existing_record->Feedback : null;
        }
        
        // Get institute ID
        $institute = $this->db->select('Institu_id')->from('institute_master')->get()->row();
        $institute_id = $institute ? $institute->Institu_id : null;
        
        // Prepare update data
        $updateData = array(
            'prn' => $prn_val,
            'Student_name' => $student_name_val,
            'fkbranch_id' => $resolved_branch_id,
            'fkclass_id' => $resolved_class_id,
            'Division' => $division_val,
            'Vap_tittle' => $vap_title_val,
            'resource_person_name' => $resource_person_name_val,
            'resource_person_contact' => $resource_person_contact_val,
            'Company_name' => $resolved_company_id,
            'Address' => $address_val,
            'finicial_Year' => $resolved_year_id,
            'Vap_Start' => $vap_start_date_val,
            'Vap_End' => $vap_end_date_val,
            'Photo_Url' => $photo_url_val,
            'Feedback' => $feedback_name,
            'institute' => $institute_id,
            'excel_file' => $excel_name,
            'modified_by'=>$_SESSION['userID']
        );
        
        log_message('debug', 'Update data: ' . print_r($updateData, true));
        
        if ($this->VAP_model->updateVAP($vap_id, $updateData)) {

// Insert log - Action 2 (Update)
        $action = 2;
        $record_id = $vap_id;
        $excel_name = null;
        $Fk_branch = null;
        insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch,$_SESSION['userID']);

            echo json_encode([
                'status' => 'success',
                'message' => 'VAP record updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update VAP record'
            ]);
        }
        
    } catch (Exception $e) {
        log_message('error', 'VAP update error: ' . $e->getMessage());
        echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
    }
}
}
?>