<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vision extends CI_Controller {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Vision_model');
        $this->load->model('Log_model');
        $this->load->helper('log');
        
        if(empty($this->session->userdata('userID')))
        {
            redirect('admin/MenuLogin');
        }
    }

    public function Dashboard()
    {
        $this->load->view('admin/header_view');
        $this->load->view('admin/Vision_dash_view.php');
        $this->load->view('admin/footer_view');
    }

    public function index()
    {
        $data['alldata'] = $this->Vision_model->getdetailview();
        
        $this->load->view('admin/header_view');
        $this->load->view('admin/Vision_detailview.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function create()
    {
        $data['branchdata'] = $this->Vision_model->getbranch();
        $data['yeardata'] = $this->Vision_model->getyear();
        $data['activeYear'] = $this->Vision_model->getActiveYear();
        
        // Get current URL dynamically
        $current_url = $this->uri->uri_string();        
        // Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);

        $this->load->view('admin/header_view');
        $this->load->view('admin/Vision_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function insertVision()
    {
        try {
            $fkbranch_id = $this->input->post('fkbranch_id');
            $finicial_Year = $this->input->post('finicial_Year');
            
            // ===================================================================
            // CRITICAL: DO NOT USE xss_clean() on HTML content with base64 images
            // It will remove the base64 data and break images!
            // Use FALSE parameter to get raw POST data
            // ===================================================================
            $Vision = $this->input->post('Vision', FALSE);
            $Mission = $this->input->post('Mission', FALSE);
            
            $fk_submenuId = $this->input->post('fk_submenuId');

            // Debug: Log the length of content being saved
            log_message('debug', 'Vision content length: ' . strlen($Vision));
            log_message('debug', 'Mission content length: ' . strlen($Mission));

            // Get institute id
            $institute = $this->db->select('Institu_id')
                                  ->from('institute_master')
                                  ->get()
                                  ->row();

            $fields = array(
                'fkbranch_id' => $fkbranch_id,
                'finicial_Year' => $finicial_Year,
                'Vision' => $Vision,
                'Mission' => $Mission,
                'institute' => $institute ? $institute->Institu_id : null,
                'created_by' => $this->session->userdata('userID'),
                'created_date' => date('Y-m-d H:i:s'),
                'is_on' => 1,
                'is_active' => 1
            );

            $inserted_id = $this->Vision_model->insertdata($fields);
     
            // Insert log - Action 1 (Insert)
            if($fk_submenuId) {
                $action = 1;
                $record_id = $inserted_id;
                $excel_name = null;
                $Fk_branch = $fkbranch_id;
                insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch, $this->session->userdata('userID'));
            }
            
            $response = array(
                'status' => 'success',
                'message' => 'Vision & Mission created successfully',
                'data' => array(
                    'id' => $inserted_id,
                    'vision_length' => strlen($Vision),
                    'mission_length' => strlen($Mission)
                ),
                'id' => $inserted_id
            );
            
            echo json_encode($response);
            
        } catch(Exception $e) {
            log_message('error', 'Insert Vision Error: ' . $e->getMessage());
            $response = array(
                'status' => 'error',
                'message' => $e->getMessage()
            );
            echo json_encode($response);
        }
    }

    public function update()
    {
        $id = $this->uri->segment(4);
        $data['data'] = $this->Vision_model->getbyid($id);
        $data['branchdata'] = $this->Vision_model->getbranch();
        $data['yeardata'] = $this->Vision_model->getyear();
        $data['activeYear'] = $this->Vision_model->getActiveYear();
        
        $current_url = $this->uri->segment(1) . '/' . $this->uri->segment(2) . '/create';
        // Fetch SubID from database
        $data['subId'] = $this->Log_model->getsubID($current_url);
        
        // Debug: Check what we're loading
        if(!empty($data['data'])) {
            log_message('debug', 'Loading Vision ID: ' . $data['data'][0]->Vision_id);
            log_message('debug', 'Vision content length: ' . strlen($data['data'][0]->Vision));
            log_message('debug', 'Mission content length: ' . strlen($data['data'][0]->Mission));
        }
       
        $this->load->view('admin/header_view');
        $this->load->view('admin/Vision_view.php', $data);
        $this->load->view('admin/footer_view');
    }

    public function updateVision()
    {
        try {
            $Vision_id = $this->input->post('Vision_id'); 
            $fkbranch_id = $this->input->post('fkbranch_id');
            $finicial_Year = $this->input->post('finicial_Year');
            
            // ===================================================================
            // CRITICAL: DO NOT USE xss_clean() on HTML content with base64 images
            // ===================================================================
            $Vision = $this->input->post('Vision', FALSE);
            $Mission = $this->input->post('Mission', FALSE);
            
            $fk_submenuId = $this->input->post('fk_submenuId');

            // Debug: Log the length of content being saved
            log_message('debug', 'Updating Vision ID: ' . $Vision_id);
            log_message('debug', 'Vision content length: ' . strlen($Vision));
            log_message('debug', 'Mission content length: ' . strlen($Mission));

            $fields = array(
                'Vision_id' => $Vision_id,
                'fkbranch_id' => $fkbranch_id,
                'finicial_Year' => $finicial_Year,
                'Vision' => $Vision,
                'Mission' => $Mission,
                'modified_by' => $this->session->userdata('userID'),
                'modified_date' => date('Y-m-d H:i:s')
            );
            
            $this->Vision_model->update($fields);
            
            // Insert log - Action 2 (Update)
            if($fk_submenuId) {
                $action = 2;
                $record_id = $Vision_id;
                $excel_name = null;
                $Fk_branch = $fkbranch_id;
                insert_log($this, $fk_submenuId, $action, $record_id, $excel_name, $Fk_branch, $this->session->userdata('userID'));
            }
            
            $response = array(
                'status' => 'success',
                'message' => 'Vision & Mission updated successfully',
                'data' => array(
                    'id' => $Vision_id,
                    'vision_length' => strlen($Vision),
                    'mission_length' => strlen($Mission)
                )
            );
            
            echo json_encode($response);
            
        } catch(Exception $e) {
            log_message('error', 'Update Vision Error: ' . $e->getMessage());
            $response = array(
                'status' => 'error',
                'message' => $e->getMessage()
            );
            echo json_encode($response);
        }
    }

    public function getVisionDetails($id)
    {
        $data = $this->Vision_model->getVisionDetailsById($id);
        
        // Debug: Check data before sending
        if($data) {
            log_message('debug', 'Getting Vision Details ID: ' . $id);
            log_message('debug', 'Vision length: ' . strlen($data->Vision));
            log_message('debug', 'Mission length: ' . strlen($data->Mission));
        }
        
        echo json_encode($data);
    }

    public function delete()
    {
        $id = $this->input->post('id');
        
        if($id) {
            $fields = array(
                'deleted_by' => $this->session->userdata('userID'),
                'deleted_date' => date('Y-m-d H:i:s'),
                'is_active' => 0
            );
            
            $this->db->where('Vision_id', $id);
            $result = $this->db->update('vision_master', $fields);
            
            if($result) {
                echo json_encode(array('status' => 'success', 'message' => 'Record deleted successfully'));
            } else {
                echo json_encode(array('status' => 'error', 'message' => 'Failed to delete record'));
            }
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'Invalid ID'));
        }
    }
    
    /**
     * Check database structure and data integrity
     * Access via: your-domain/admin/Vision/checkDatabase
     */
    public function checkDatabase()
    {
        // Only allow in development/testing
        if(ENVIRONMENT !== 'development') {
            show_404();
            return;
        }
        
        echo "<h2>Database Structure Check</h2>";
        
        // Check column types
        $query = $this->db->query("SHOW COLUMNS FROM vision_master WHERE Field IN ('Vision', 'Mission')");
        echo "<h3>Column Types:</h3>";
        echo "<pre>";
        print_r($query->result());
        echo "</pre>";
        
        // Check data lengths
        $query = $this->db->query("
            SELECT 
                Vision_id,
                LENGTH(Vision) as vision_length,
                LENGTH(Mission) as mission_length,
                SUBSTRING(Vision, 1, 200) as vision_preview
            FROM vision_master 
            WHERE is_active = 1 
            ORDER BY Vision_id DESC 
            LIMIT 5
        ");
        
        echo "<h3>Recent Data Lengths:</h3>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Vision Length</th><th>Mission Length</th><th>Preview</th></tr>";
        foreach($query->result() as $row) {
            echo "<tr>";
            echo "<td>{$row->Vision_id}</td>";
            echo "<td>{$row->vision_length}</td>";
            echo "<td>{$row->mission_length}</td>";
            echo "<td>" . htmlspecialchars(substr($row->vision_preview, 0, 100)) . "...</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<h3>What to look for:</h3>";
        echo "<ul>";
        echo "<li>Column Type should be 'longtext' - if it's 'text', run the ALTER TABLE command</li>";
        echo "<li>If length is exactly 65535, data was truncated - you need to re-save that record</li>";
        echo "<li>Images in preview should show as <img src=\"data:image...</li>";
        echo "</ul>";
    }
}