<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

function image_thumb($folder_name, $image_name, $width, $height, $quality = 60)
{
    $CI =& get_instance();

    // Use a fixed path (Assets/Upload)
    $full_path = FCPATH . 'Assets/Upload'; // folder where original image is stored
    $thumb_dir = $full_path . '/thumb/';

    // Create thumb directory if it doesn't exist
    if (!is_dir($thumb_dir)) {
        mkdir($thumb_dir, 0777, true);
    }

    // Generate unique thumbnail file name
    $thumb_name = base64_encode($image_name) . '_' . $width . '_' . $height . strrchr($image_name, '.');
    $image_thumb = $thumb_dir . $thumb_name;

    // If thumbnail doesn't exist, create it
    if (!file_exists($image_thumb)) {
        $CI->load->library('image_lib');

        $config['image_library'] = 'gd2';
        $config['source_image'] = $full_path . '/' . $image_name; // original image path
        $config['new_image'] = $image_thumb;                      // output thumbnail path
        $config['maintain_ratio'] = TRUE;
        $config['width'] = $width;
        $config['height'] = $height;
        $config['quality'] = $quality . '%';

        $CI->image_lib->initialize($config);
        if (!$CI->image_lib->resize()) {
            log_message('error', 'Image Resize Error: ' . $CI->image_lib->display_errors());
        }
        $CI->image_lib->clear();
    }

    // Return the public URL of the thumbnail
    return base_url('Assets/Upload/thumb/' . $thumb_name);
}

function generate_thumbnail($image_name, $width, $height, $quality = 60)
{
    return image_thumb('Assets/Upload', $image_name, $width, $height, $quality);
}

