<?php
/**
 * Log Helper Function
 * Place this file in: application/helpers/log_helper.php
 * Load it in autoload.php or controller: $this->load->helper('log');
 */

if (!function_exists('insert_log')) {
    /**
     * Insert log entry into log_master table
     * 
     * @param object $ci - CodeIgniter instance
     * @param int $fk_submenuId - Submenu ID from form
     * @param int $action - Action type (1=Insert, 2=Update, 3=Photo Upload, 4=Excel)
     * @param int|null $record_id - Primary key ID of affected record (for action 1,2)
     * @param string|null $excel_name - Excel file name (for action 4)
     * @param int $fk_userId - User ID (default: 1)
     * @return bool - Success or failure
     */
    function insert_log($ci, $fk_submenuId, $action, $record_id = null, $excel_name = null, $Fk_branch = null, $fk_userId = 1)
    {
        // Set timezone to Asia/Kolkata
        date_default_timezone_set('Asia/Kolkata');
        
        // Get current date and time
        $current_date = date('Y-m-d');
        $current_time = date('H:i:s');
        
        // Get IP address
        $ip_address = get_client_ip();
        
        // Prepare log data
        $log_data = array(
            'fk_submenuId' => $fk_submenuId,
            'fk_userId' => $fk_userId,
            'date' => $current_date,
            'time' => $current_time,
            'Fk_branch' =>$Fk_branch,
            // 'Ip_addresss' => $ip_address,
            'action' => $action
        );
        
        // Add Id for action 1 (Insert) or 2 (Update)
        if ($action == 1 || $action == 2) {
            $log_data['Id'] = $record_id;
        }
        
        // Add ExcelName for action 4 (Excel)
        if ($action == 4) {
            $log_data['ExcelName'] = $excel_name;
        }
        
        // Insert log
        return $ci->Log_model->insertdata($log_data);
    }
}

if (!function_exists('get_client_ip')) {
    /**
     * Get client IP address
     * 
     * @return string - IP address
     */
    function get_client_ip()
    {
        $ip_address = '';
        
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            // IP from shared internet
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            // IP passed from proxy
            $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            // Remote address
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }
        
        return $ip_address;
    }
}