<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AnswerType_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ==================== CRUD FUNCTIONS ====================

    // Get by ID
    public function getbyid($id)
    {
        $this->db->select("answerTypemaster.*");
        $this->db->where('answertypeid', $id);
        $query = $this->db->get('answerTypemaster');
        return $query->result();
    }
// Add this method to your AnswerType_model.php
public function checkDuplicateOrderNumber($orderno, $answertypeid = null)
{
    $this->db->select('answertypeid, is_active');
    $this->db->from('answerTypemaster');
    $this->db->where('orderno', $orderno);
    
    if ($answertypeid) {
        $this->db->where('answertypeid !=', $answertypeid);
    }
    
    $query = $this->db->get();
    return $query->result();
}
    // Insert Answer Type
    public function insertAnswerType($data)
    {
        $insert_data = array(
            'answertypename' => $data['answertypename'],
            'orderno'        => $data['orderno'],
            'is_default'     => isset($data['is_default']) ? $data['is_default'] : 0,
            'is_on'          => isset($data['is_on']) ? $data['is_on'] : 0,
            'is_active'      => isset($data['is_active']) ? $data['is_active'] : 1,
            'created_date'   => date('Y-m-d H:i:s'),
            'created_by'     => $this->session->userdata('user_id')
        );
        
        if ($this->db->insert('answerTypemaster', $insert_data)) {
            return array(
                'status'         => true,
                'answertypeid'   => $this->db->insert_id()
            );
        }
        
        return array('status' => false);
    }

    // Update Answer Type
    public function updateAnswerType($answertypeid, $data)
    {
        $update_data = array(
            'answertypename' => $data['answertypename'],
            'orderno'        => $data['orderno'],
            'is_default'     => isset($data['is_default']) ? $data['is_default'] : 0,
            'is_on'          => isset($data['is_on']) ? $data['is_on'] : 0,
            'is_active'      => isset($data['is_active']) ? $data['is_active'] : 1,
            'modified_date'  => date('Y-m-d H:i:s'),
            'modified_by'    => $this->session->userdata('user_id')
        );
        
        $this->db->where('answertypeid', $answertypeid);
        return $this->db->update('answerTypemaster', $update_data);
    }

    // Delete Answer Type
    public function deleteAnswerType($answertypeid)
    {
        $this->db->where('answertypeid', $answertypeid);
        return $this->db->delete('answerTypemaster');
    }

    // Toggle Active Status
    public function toggleActiveStatus($answertypeid, $is_active)
    {
        $data = array(
            'is_active'      => $is_active == 1 ? 1 : 0,
            'modified_date'  => date('Y-m-d H:i:s'),
            'modified_by'    => $this->session->userdata('user_id')
        );
        $this->db->where('answertypeid', $answertypeid);
        return $this->db->update('answerTypemaster', $data);
    }

    // ==================== LIST FUNCTIONS ====================

    // Get all answer types
    public function getAllAnswerTypes()
    {
        $this->db->select('answerTypemaster.*');
        $this->db->from('answerTypemaster');
        $this->db->order_by('answerTypemaster.orderno', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get active answer types (for dropdown)
    public function getActiveAnswerTypes()
    {
        $this->db->select('answerTypemaster.answertypeid, answerTypemaster.answertypename');
        $this->db->from('answerTypemaster');
        $this->db->where('answerTypemaster.is_active', 1);
        $this->db->order_by('answerTypemaster.orderno', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Check duplicate
    public function checkDuplicateAnswerType($answertypename, $answertypeid = null)
    {
        $this->db->select('answertypeid');
        $this->db->from('answerTypemaster');
        $this->db->where('answertypename', $answertypename);
        
        if ($answertypeid) {
            $this->db->where('answertypeid !=', $answertypeid);
        }
        
        $query = $this->db->get();
        return $query->num_rows() > 0;
    }
}
?>