<?php
class Award_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

      public function insertdata($model)
    {
     $this->db->insert('award_master',$model);
     return $this->db->insert_id();
    }


    public function getdetailview()
    {      
        $this->db->select('award_master.*, level_master.leval_name, institute_master.Institu_name');
        $this->db->from('award_master');
        $this->db->join('level_master', 'award_master.fkAwardType_id = level_master.level_id', 'left');
        $this->db->join('institute_master', 'award_master.fkInsitute_id = institute_master.Institu_id', 'left');
        $this->db->order_by('award_master.Award_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_all_AwardType()
    {
        return $this->db->get('level_master')->result();
    }

    public function get_all_institute()
    {
        return $this->db->get('institute_master')->result();
    }

    public function insertGallery($data)
    {
        return $this->db->insert('award_gallery', $data);
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function deleteExistingPhotos($gallery_id, $removed_photos_array)
    {
        if (!empty($removed_photos_array)) {
            $this->deleteSpecificPhotos($gallery_id, $removed_photos_array);
            foreach ($removed_photos_array as $file_path) {
                $full_path = FCPATH . $file_path;
                if (file_exists($full_path)) {
                    unlink($full_path);
                }
            }
        }
    }

    public function getAwardGallery($award_id) {
        return $this->db
            ->select('*')
            ->from('award_gallery')
            ->where('fkAward_id', $award_id)
            ->get()
            ->result();
    }

    public function deleteSpecificAwardPhotos($gallery_id, $photos) {
        $this->db->where('fkAward_id', $gallery_id);
        $this->db->where_in('file_path', $photos);
        return $this->db->delete('award_gallery');
    }

    public function deleteimagedata($fkAward_id)
    {
        return $this->db->where('fkAward_id', $fkAward_id)
                        ->delete('award_gallery');
    }

    public function deleteSpecificPhotos($award_id, $file_paths) {
        if (empty($file_paths)) return false;

        $this->db->where('fkAward_id', $award_id);
        $this->db->where_in('file_path', $file_paths);
        return $this->db->delete('award_gallery');
    }

    public function insertMultiplePhotos($gallery_id, $file_path)
    {
        if (empty($file_path)) return false;
       
        $insert_data = [];
        foreach ($file_path as $path) {
            $insert_data[] = [
                'fkAward_id' => $gallery_id,
                'file_path' => $path
            ];
        }
       
        return $this->db->insert_batch('award_gallery', $insert_data);
    }

    public function getSelectedimage($guest_id)
    {
        if (empty($guest_id)) return [];
       
        $this->db->select('talk_photos');
        $this->db->from('guesttalk_photo_master');
        $this->db->where('fkGuest_id', $guest_id);
        $query = $this->db->get();
     
        if ($query->num_rows() > 0) {
            return array_column($query->result_array(), 'talk_photos');
        }
       
        return [];
    }

    public function getbyid($id)
    {
        $this->db->select("award_master.*");
        $this->db->where('Award_id',$id);
        $query = $this->db->get('award_master');
        return $query->result();
    }
    
    public function update($model)
    {
        return $sql = $this->db->where('Award_id',$model['Award_id'])->update('award_master',$model); 
    }

    // UPDATED METHOD - Removed institute_id parameter
    public function getAllAwardData($year_id, $fkAwardType_id = [], $AwardCertify = [], $AwardAmt = [])
    {
        $this->db->select('award_master.*, level_master.leval_name, institute_master.Institu_name');
        $this->db->from('award_master');
        $this->db->join('level_master', 'award_master.fkAwardType_id = level_master.level_id', 'left');
        $this->db->join('institute_master', 'award_master.fkInsitute_id = institute_master.Institu_id', 'left');

        // Removed institute filter

        if (!empty($fkAwardType_id)) {
            $this->db->where_in('award_master.fkAwardType_id', $fkAwardType_id);
        }

        if (!empty($AwardCertify)) {
            $this->db->where_in('award_master.AwardCertify', $AwardCertify);
        }

        if (!empty($year_id)) {
            $this->db->where('award_master.FiniYear', $year_id);
        }

        if (!empty($AwardAmt)) {
            $this->db->where_in('award_master.AwardAmt', $AwardAmt);
        }

        $this->db->order_by('award_master.FiniYear', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

    public function getAllYearsData()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("award_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = award_master.FiniYear")
            ->group_by("award_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }
     
    public function getSingleYearData($yearId)
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("award_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = award_master.FiniYear")
            ->where("award_master.FiniYear", $yearId)
            ->group_by("award_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }
     
    public function getYearwiseTypes($yearId)
    {
        return $this->db->select("award_master.Award_name, award_master.fkAwardType_id, level_master.leval_name, finiyear_master.fini_Label as year")
            ->from("award_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = award_master.FiniYear")
            ->join("level_master", "award_master.fkAwardType_id = level_master.level_id")
            ->where("award_master.FiniYear", $yearId)
            ->get()
            ->result_array();
    }

    // UPDATED METHOD - Removed institu parameter
    public function getCombinedData($years = [], $startDate = null, $endDate = null)
    {
        $response = [];

        // Yearwise Count
        $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Award_id) as count");
        $this->db->from("award_master sr");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.FiniYear");

        // Removed institute filter

        if (!empty($years)) {
            $this->db->where_in('sr.FiniYear', (array)$years);
        }
        
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();

        return $response;
    }
}