<?php
class Budgetuti_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert parent data to budgetuti_main_master
    public function insertMain($data) {
        $this->db->insert('budgetuti_main_master', $data);
        return $this->db->insert_id();
    }
    
    // Insert child data to budgetutilazation_master
    public function insertChild($data) {
        return $this->db->insert('budgetutilazation_master', $data);
    }
    
    // Update main record
    public function updateMain($budgetmain_id, $data) {
        $this->db->where('budgetmain_id', $budgetmain_id);
        return $this->db->update('budgetuti_main_master', $data);
    }
    
    // Delete child records by main ID
    public function deleteChildByMainId($budgetmain_id) {
        $this->db->where('fkbudgetmain_id', $budgetmain_id);
        return $this->db->delete('budgetutilazation_master');
    }
    
    // Get main record by ID
    public function getMainById($id) {
        $this->db->select('*');
        $this->db->from('budgetuti_main_master');
        $this->db->where('budgetmain_id', $id);
        $query = $this->db->get();
        return $query->row();
    }
    
    // Get child records by main ID
   public function getChildByMainId($budgetmain_id) {
    $this->db->select('
        budgetutilazation_master.*,
        expensivetype_master.expen_name,
        allocationtype_master.name as allocation_name
    ');
    $this->db->from('budgetutilazation_master');
    $this->db->join('expensivetype_master', 'expensivetype_master.expentype_id = budgetutilazation_master.fkexpentype_id', 'left');
    $this->db->join('allocationtype_master', 'allocationtype_master.allocationtype_id = budgetutilazation_master.fkallocationtype_id', 'left');
    $this->db->where('budgetutilazation_master.fkbudgetmain_id', $budgetmain_id);
    $query = $this->db->get();
    return $query->result();
}
    
    // Get branch data
    public function getbranch() {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get financial year data
    public function getYearData() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

      public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}
    
    // Get allocation type data
    public function getallocationData() {
        $this->db->select('allocationtype_id, name');
        $this->db->from('allocationtype_master');
        $this->db->order_by('name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Other existing methods
    public function getAllInternships() {
        $this->db->select('
        budgetuti_main_master.budgetmain_id,
        budgetuti_main_master.excel_file,
        budgetuti_main_master.fkbranch_id,
        branch_master.branch_name,
        budgetuti_main_master.budgetuti_date,
        budgetuti_main_master.Desscription_main,
        budgetuti_main_master.finicial_Year,
        finiyear_master.fini_Label
       
        
    ');
        $this->db->from('budgetuti_main_master');
       
    // $this->db->join('branch_master', 'branch_master.branch_id = internshipstud_master.fkbranch_id', 'left');
    // $this->db->join('classmaster', 'classmaster.class_id = internshipstud_master.fkclass_id', 'left');
    // $this->db->join('company_category', 'company_category.compCat_id = internshipstud_master.fkcompCat_id', 'left');
    // $this->db->join('company_master', 'company_master.ID = internshipstud_master.fkcomp_Id', 'left');
    // $this->db->join('internshiptype_master', 'internshiptype_master.inter_id = internshipstud_master.fkinter_id', 'left');
    // $this->db->join('internduration_master', 'internduration_master.duration_id = internshipstud_master.fkduration_id', 'left');
    $this->db->join('branch_master','budgetuti_main_master.fkbranch_id = branch_master.branch_id','left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = budgetuti_main_master.finicial_Year');
    $this->db->order_by('budgetuti_main_master.budgetmain_id', 'DESC');
   
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }
    
    
    
    // Get all budget records with joins
    public function getAllBudgets() {
    $this->db->select('
        bm.budgetmain_id,
        bm.fkbranch_id,
        bm.finicial_Year,
        bm.budgetuti_date,
        bm.Desscription_main,
        bm.excel_file,
        br.branch_name,
        fy.fini_Label,
        COUNT(bc.budgetuti_id) as total_records,
        SUM(bc.amount) as total_amount
    ');
    $this->db->from('budgetuti_main_master bm');
    $this->db->join('branch_master br', 'br.branch_id = bm.fkbranch_id', 'left');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = bm.finicial_Year', 'left');
    $this->db->join('budgetutilazation_master bc', 'bc.fkbudgetmain_id = bm.budgetmain_id', 'left');
    $this->db->group_by('bm.budgetmain_id');
    $this->db->order_by('bm.budgetmain_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}

    // Get expensive type data with allocation type
public function getExpensiveData() {
    $this->db->select('
        expensivetype_master.expentype_id, 
        expensivetype_master.expen_name,
        expensivetype_master.fkallocationtype_id,
        allocationtype_master.name as allocation_name
    ');
    $this->db->from('expensivetype_master');
    $this->db->join('allocationtype_master', 'allocationtype_master.allocationtype_id = expensivetype_master.fkallocationtype_id', 'left');
    $this->db->where('expensivetype_master.is_on', 1);
    $this->db->order_by('expensivetype_master.expen_name', 'ASC');
    $query = $this->db->get();
    return $query->result();
}
}