<?php
class ChapterReport_model extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    // Get all institutes
    public function get_all_institute()
    {
        return $this->db->get('institute_master')->result();
    }

    public function get_all_Branch() {
        return $this->db->get('branch_master')->result();
    }

    public function get_all_Faculty() {
        return $this->db->get('faculty_master')->result();
    }

    public function get_all_Student() {
        return $this->db->get('student_reg')->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getAllClubNames()
    {
        return $this->db->select('club_id, NameClub')
            ->from('chapterclub_master')
           ->group_by('NameClub')
            ->order_by('NameClub', 'ASC')
            ->get()
            ->result();
    }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $query = $this->db->get();
        return $query->result();
    }

    // Main report query with all filters
    public function getDataByInstitute($institute_id, $startdate = null, $enddate = null, $branches = [], $faculties = [], $students = [], $year = null)
    {
        $this->db->select('
            cm.*, 
            bm.branch_name, 
            fm.fac_Fullname as faculty_name, 
            sr.FullName as student_name,
            im.Institu_name,
            fy.fini_Label as year_name
        ');
        $this->db->from('chapterclub_master cm');
        $this->db->join('branch_master bm', 'cm.fkbranch_id = bm.branch_id', 'left');
        $this->db->join('faculty_master fm', 'cm.fkFacCo_id = fm.fac_id', 'left');
        $this->db->join('student_reg sr', 'cm.fkStudCo_id = sr.Student_id', 'left');
        $this->db->join('institute_master im', 'cm.InstituteId = im.Institu_id', 'left');
        $this->db->join('finiyear_master fy', 'cm.FiniYear = fy.finiYear_id', 'left');

        // Filters
        if (!empty($institute_id)) {
            $this->db->where('cm.InstituteId', $institute_id);
        }

        if (!empty($year) && $year != "0") {
            $this->db->where('cm.FiniYear', $year);
        }

        if (!empty($startdate) && !empty($enddate)) {
            $this->db->where('cm.StartDate >=', $startdate);
            $this->db->where('cm.StartDate <=', $enddate);
        }

        if (!empty($branches)) {
            $this->db->where_in('cm.fkbranch_id', $branches);
        }

        if (!empty($faculties)) {
            $this->db->where_in('cm.fkFacCo_id', $faculties);
        }

        if (!empty($students)) {
            $this->db->where_in('cm.fkStudCo_id', $students);
        }

        $this->db->order_by('cm.StartDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get full club details including students, activities, and faculties
    public function getClubFullDetails($club_id) 
    {
        $data = [];

        // Main club details
        $data['club'] = $this->db
            ->select('
                cm.*, 
                bm.branch_name, 
                fm.fac_Fullname, 
                sr.FullName,
                fy.fini_Label as year_name
            ')
            ->from('chapterclub_master cm')
            ->join('branch_master bm', 'cm.fkbranch_id = bm.branch_id', 'left')
            ->join('faculty_master fm', 'cm.fkFacCo_id = fm.fac_id', 'left')
            ->join('student_reg sr', 'cm.fkStudCo_id = sr.Student_id', 'left')
            ->join('finiyear_master fy', 'cm.FiniYear = fy.finiYear_id', 'left')
            ->where('cm.club_id', $club_id)
            ->get()
            ->row();

        // Students list
        $data['students'] = $this->db
            ->select('*')
            ->from('studentclub_list')
            ->where('club_id', $club_id)
            ->get()
            ->result();

        // Activities list
        $data['activities'] = $this->db
            ->select('*')
            ->from('activitiesclub_master')
            ->where('club_id', $club_id)
            ->get()
            ->result();

        // ✅ Faculty list - Based on your image 4 (facultylistxcel table)
        $data['faculties'] = $this->db
            ->select('*')
            ->from('facultylistxcel')
            ->where('club_id', $club_id)
            ->get()
            ->result();

        return $data;
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

    // Yearwise data methods
    public function getAllYearsData()
    {
        return $this->db->select("
                fy.finiYear_id as year_id, 
                fy.fini_Label as year, 
                COUNT(*) as count
            ")
            ->from("chapterclub_master cm")
            ->join("finiyear_master fy", "fy.finiYear_id = cm.FiniYear")
            ->group_by("cm.FiniYear, fy.fini_Label, fy.finiYear_id")
            ->get()
            ->result_array();
    }

    public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
    {
        $this->db->select("
                fy.finiYear_id as year_id, 
                fy.fini_Label as year, 
                COUNT(*) as count
            ")
            ->from("chapterclub_master cm")
            ->join("finiyear_master fy", "fy.finiYear_id = cm.FiniYear");

        $this->db->where("cm.FiniYear", $yearId);

        if (!empty($institu)) {
            $this->db->where('cm.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('cm.fkbranch_id', (array)$branches);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("cm.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by("cm.FiniYear, fy.fini_Label, fy.finiYear_id");

        return $this->db->get()->result_array();
    }

    public function getYearwiseTypes($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
    {
        $this->db->select("
                cm.NameClub, 
                cm.fkbranch_id, 
                bm.branch_name, 
                fy.fini_Label as year
            ")
            ->from("chapterclub_master cm")
            ->join("finiyear_master fy", "fy.finiYear_id = cm.FiniYear")
            ->join("branch_master bm", "bm.branch_id = cm.fkbranch_id", "left")
            ->where("cm.FiniYear", $yearId);

        if (!empty($institu)) {
            $this->db->where('cm.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('cm.fkbranch_id', (array)$branches);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("cm.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        return $this->db->get()->result_array();
    }

    public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('
                bm.branch_id,
                bm.branch_name,
                COUNT(cm.club_id) as club_count
            ');
        $this->db->from('branch_master bm');
        $this->db->join('chapterclub_master cm', 'bm.branch_id = cm.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('cm.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('bm.branch_id', (array)$branches);
        }
        if (!empty($year) && $year != 0) {
            $this->db->where('cm.FiniYear', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("cm.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by('bm.branch_id, bm.branch_name');
        $this->db->order_by('bm.branch_name', 'ASC');

        return $this->db->get()->result();
    }

    public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('
                cm.club_id,
                cm.NameClub,
                cm.fkbranch_id,
                bm.branch_name
            ');
        $this->db->from('chapterclub_master cm');
        $this->db->join('branch_master bm', 'bm.branch_id = cm.fkbranch_id', 'left');

        if (is_array($branch_id)) {
            $this->db->where_in('cm.fkbranch_id', $branch_id);
        } else {
            $this->db->where('cm.fkbranch_id', $branch_id);
        }

        if (!empty($institu)) {
            $this->db->where('cm.InstituteId', $institu);
        }
        if (!empty($year)) {
            if (is_array($year)) {
                $this->db->where_in('cm.FiniYear', $year);
            } else {
                $this->db->where('cm.FiniYear', $year);
            }
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("cm.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        return $this->db->get()->result();
    }

    public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
    {
        $response = [];

        // Branchwise Count
        $this->db->select('bm.branch_id, bm.branch_name, COUNT(cm.club_id) as club_count');
        $this->db->from('branch_master bm');
        $this->db->join('chapterclub_master cm', 'bm.branch_id = cm.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('cm.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('bm.branch_id', (array)$branches);
        }
        if (!empty($years)) {
            $this->db->where_in('cm.FiniYear', (array)$years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("cm.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by('bm.branch_id, bm.branch_name');
        $this->db->order_by('bm.branch_name', 'ASC');
        $response['branchData'] = $this->db->get()->result();

        // Yearwise Count
        $this->db->select("
                fy.finiYear_id as year_id, 
                fy.fini_Label as year, 
                COUNT(cm.club_id) as count
            ");
        $this->db->from("chapterclub_master cm");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = cm.FiniYear");

        if (!empty($institu)) {
            $this->db->where('cm.InstituteId', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('cm.fkbranch_id', (array)$branches);
        }
        if (!empty($years)) {
            $this->db->where_in('cm.FiniYear', (array)$years);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("cm.StartDate BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();

        return $response;
    }
}