<?php
class Citation_report_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Get unique faculty names from citation_master
    public function getfaculty()
    {
        $this->db->select('faculty_name');
        $this->db->from('citation_master');
        $this->db->where('is_active', 1);
        $this->db->group_by('faculty_name');
        $this->db->order_by('faculty_name', 'ASC');
        return $this->db->get()->result();
    }

    // Get year data
    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    // Get master table data by faculty name
    public function getMasterDataByFaculty($faculty_name)
    {
        $this->db->select('
            citation_master.*, 
            finiyear_master.fini_Label
        ');
        $this->db->from('citation_master');
        $this->db->join('finiyear_master', 
            'citation_master.Financial_Year = finiyear_master.finiYear_id', 
            'left');
        
        if (!empty($faculty_name)) {
            $this->db->where('citation_master.faculty_name', $faculty_name);
        }
        
        $this->db->where('citation_master.is_active', 1);
        $this->db->order_by('citation_master.cit_id', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get citation articles grouped by year for graph
    public function getArticlesByYear($cit_id)
    {
        $this->db->select('
            citation_article.year,
            COUNT(citation_article.artID) as article_count
        ');
        $this->db->from('citation_article');
        $this->db->where('citation_article.fk_citID', $cit_id);
        $this->db->where('citation_article.is_active', 1);
        $this->db->group_by('citation_article.year');
        $this->db->order_by('citation_article.year', 'ASC');
        
        $query = $this->db->get();
        return $query->result_array();
    }

    // Get all articles list for a faculty member
    public function getArticlesList($cit_id)
    {
        $this->db->select('
            citation_article.artID,
            citation_article.article_name,
            citation_article.date,
            citation_article.year
        ');
        $this->db->from('citation_article');
        $this->db->where('citation_article.fk_citID', $cit_id);
        $this->db->where('citation_article.is_active', 1);
        $this->db->order_by('citation_article.year', 'DESC');
        
        return $this->db->get()->result_array();
    }

    // For print headings
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}