<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CollegeFeedbackSurvey_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ==================== QUESTIONS & ANSWERS ====================

    /**
     * Get questions by feedback type with proper ordering
     * @param int $feedbackfor_id
     * @return array Questions with question_id, question_name, and isanswerortext
     */
    public function get_questions_by_feedback($feedbackfor_id)
    {
        $this->db->select('questionid, question_name, feedbackid, isanswerortext');
        $this->db->from('question_master');
        $this->db->where('feedbackid', $feedbackfor_id);
        $this->db->where('is_active', 1);
        $this->db->order_by('questionid', 'ASC'); // Order questions
        
        $query = $this->db->get();
        return $query->result();
    }

    /**
     * Get answer options ordered by orderno
     * @param int $feedbackfor_id
     * @return array Answer options with proper ordering
     */
    public function get_answer_options($feedbackfor_id)
    {
        $this->db->select('
            aft.answertypeid,
            atm.answertypename,
            atm.orderno
        ');
        $this->db->from('feedbackforanswer aft');
        $this->db->join('answerTypemaster atm', 'aft.answertypeid = atm.answertypeid', 'inner');
        $this->db->where('aft.feedbackfor_id', $feedbackfor_id);
        $this->db->where('atm.is_active', 1);
        $this->db->order_by('atm.orderno', 'ASC'); // Order by orderno ascending
        
        $query = $this->db->get();
        return $query->result();
    }

    // ==================== URL VALIDATION ====================

    /**
     * Validate URL from collegefeedback_master table
     * @param int $institute_id
     * @param int $feedbackfor_id
     * @param int $branch_id
     * @param int $financial_year_id
     * @return object|null URL data with url_id and is_active
     */
    public function validate_survey_url($institute_id, $feedbackfor_id, $branch_id, $financial_year_id)
    {
        $this->db->select('url_id, is_active, generated_url');
        $this->db->from('collegefeedback_master');
        $this->db->where('fkInsitute_id', $institute_id);
        $this->db->where('fkfeedbackforid', $feedbackfor_id);
        $this->db->where('fkbranchid', $branch_id);
        $this->db->where('academicyear', $financial_year_id);
        
        $query = $this->db->get();
        
        if ($query->num_rows() == 0) {
            return null;
        }
        
        $result = $query->row();
        
        if ($result->is_active == 0 || $result->is_active === null) {
            return null;
        }
        
        return $result;
    }

    // ==================== MASTER DATA ====================

 /**
 * Get feedback type name by ID
 */
public function get_feedbackfor_name($feedbackfor_id)
{
    $this->db->select('feedbackid, feedbackforname, questionperpage');
    $this->db->from('feedbackfor_master');
    $this->db->where('feedbackid', $feedbackfor_id);
    $this->db->where('is_active', 1);
    
    $query = $this->db->get();
    return $query->row();
}

    /**
     * Get institute data
     */
    public function get_institute($institute_id)
    {
        $this->db->select('Institu_id, Institu_Name');
        $this->db->from('institute_master');
        $this->db->where('Institu_id', $institute_id);
        
        $query = $this->db->get();
        return $query->row();
    }

    /**
     * Get branch data
     */
    public function get_branch($branch_id)
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('branch_id', $branch_id);
        $this->db->where('is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    /**
     * Get all branches (for dropdown when branch_id = 0)
     */
    public function get_all_branches($institute_id = null)
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        
        if ($institute_id) {
            $this->db->where('fkInstitu_id', $institute_id);
        }
        
        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    /**
     * Get financial year data
     */
    public function get_financial_year($year_id)
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('finiYear_id', $year_id);
        
        $query = $this->db->get();
        return $query->row();
    }

    /**
     * Get heading data (logo, institute name, etc.)
     */
    public function get_heading_data()
    {
        $this->db->select('subHead1, head, logo, subHead2, subHead3');
        $this->db->from('heading_master');
        $this->db->where('is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    // ==================== SUBMISSION ====================

    /**
     * Check if feedback already submitted for this branch + feedback type + year
     */
    public function check_submission_exists($branch_id, $feedbackfor_id, $financial_year_id)
    {
        $this->db->select('COUNT(*) as count');
        $this->db->from('collagefeedback_formmaster');
        $this->db->where('fkbranch_id', $branch_id);
        $this->db->where('feedbackforid', $feedbackfor_id);
        $this->db->where('finicial_Year', $financial_year_id);
        
        $result = $this->db->get()->row();
        return $result->count > 0;
    }

    /**
     * Insert survey responses
     * @param array $responses Array of response data
     * @return bool Success/failure
     */
    public function insert_survey_responses($responses)
    {
        return $this->db->insert_batch('collagefeedback_formmaster', $responses);
    }

    // ==================== HELPER FUNCTIONS ====================
}
?>