<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CollegeFeedback_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ==================== MASTER DATA FUNCTIONS ====================

    // Get institute data (same as StudentFeedback_model)
    public function getinstitute()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    // Get feedbackfor_master data (replaces getHostel)
    public function getFeedbackFor()
    {
        $this->db->select('feedbackfor_master.feedbackid, feedbackfor_master.feedbackforname');
        $this->db->from('feedbackfor_master');
        $this->db->where('feedbackfor_master.is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    // Get branch_master data filtered by institute
public function getBranch($institute_id = null)
{
    $this->db->select('branch_master.branch_id, branch_master.branch_name');
    $this->db->from('branch_master');

    // 1. Institute Filter (agar parameter pass kiya gaya ho)
    if ($institute_id) {
        $this->db->where('branch_master.fkInstitu_id', $institute_id);
    }

    // 2. Session-based Branch Filter (New Code Merged)
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        // Agar string hai (comma separated), toh array mein convert karein
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }

    // 3. Status and Sorting
    $this->db->where('branch_master.is_active', 1);
    $this->db->order_by('branch_master.branch_name', 'ASC');

    $query = $this->db->get();
    return $query->result();
}

    // Get year data (same as StudentFeedback_model)
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get active year (same as StudentFeedback_model)
    public function getActiveYear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    // ==================== CRUD FUNCTIONS ====================

    // Get by ID (for edit/update page)
    public function getbyid($id)
    {
        $this->db->select("collegefeedback_master.*");
        $this->db->where('url_id', $id);
        $query = $this->db->get('collegefeedback_master');
        return $query->result();
    }

    // Save generated URL (INSERT)
    public function saveGeneratedURL($data)
    {
        $token = $this->generateUniqueToken();
        
        $insert_data = array(
            'fkInsitute_id'   => $data['institute_id'],
            'fkfeedbackforid' => $data['feedbackforid'],
            'fkbranchid'      => $data['branchid'],
            'academicyear'    => $data['academicyear'],
            'generated_url'   => $data['url'],
            'url_token'       => $token,
            'is_active'       => isset($data['is_active']) ? $data['is_active'] : 1,
            'created_by'      => $this->session->userdata('user_id'),
            'created_at'      => date('Y-m-d H:i:s'),
            'expires_at'      => isset($data['expires_at']) ? $data['expires_at'] : NULL
        );
        
        if ($this->db->insert('collegefeedback_master', $insert_data)) {
            return array(
                'status' => true,
                'url_id' => $this->db->insert_id(),
                'token'  => $token
            );
        }
        
        return array('status' => false);
    }

    // Update URL (UPDATE)
    public function updateURL($url_id, $data)
    {
        $data['updated_at'] = date('Y-m-d H:i:s');
        $this->db->where('url_id', $url_id);
        return $this->db->update('collegefeedback_master', $data);
    }

    // Toggle Active/Inactive status
    public function toggleActiveStatus($url_id, $is_active)
    {
        $data = array(
            'is_active'  => $is_active == 1 ? 1 : 0,
            'updated_at' => date('Y-m-d H:i:s')
        );
        $this->db->where('url_id', $url_id);
        return $this->db->update('collegefeedback_master', $data);
    }

    // Delete URL
    public function deleteURL($url_id)
    {
        $this->db->where('url_id', $url_id);
        return $this->db->delete('collegefeedback_master');
    }

    // ==================== LIST / DETAIL FUNCTIONS ====================

    // Get all generated URLs with JOIN for display names
    public function getAllGeneratedURLs()
    {
        $this->db->select('collegefeedback_master.*, 
                          institute_master.Institu_name,
                          feedbackfor_master.feedbackforname,
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('collegefeedback_master');
        $this->db->join('institute_master',    'collegefeedback_master.fkInsitute_id   = institute_master.Institu_id',      'left');
        $this->db->join('feedbackfor_master',  'collegefeedback_master.fkfeedbackforid = feedbackfor_master.feedbackid',    'left');
        $this->db->join('branch_master',       'collegefeedback_master.fkbranchid      = branch_master.branch_id',         'left');
        $this->db->join('finiyear_master',     'collegefeedback_master.academicyear    = finiyear_master.finiYear_id',     'left');
        $this->db->order_by('collegefeedback_master.created_at', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get URLs by institute
    public function getURLsByInstitute($institute_id)
    {
        $this->db->select('collegefeedback_master.*, 
                          feedbackfor_master.feedbackforname,
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('collegefeedback_master');
        $this->db->join('feedbackfor_master',  'collegefeedback_master.fkfeedbackforid = feedbackfor_master.feedbackid',    'left');
        $this->db->join('branch_master',       'collegefeedback_master.fkbranchid      = branch_master.branch_id',         'left');
        $this->db->join('finiyear_master',     'collegefeedback_master.academicyear    = finiyear_master.finiYear_id',     'left');
        $this->db->where('collegefeedback_master.fkInsitute_id', $institute_id);
        $this->db->order_by('collegefeedback_master.created_at', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // ==================== TOKEN / VALIDATION FUNCTIONS ====================

    // Get URL by token
    public function getURLByToken($token)
    {
        $this->db->select('collegefeedback_master.*, 
                          institute_master.Institu_name,
                          feedbackfor_master.feedbackforname,
                          branch_master.branch_name,
                          finiyear_master.fini_Label');
        $this->db->from('collegefeedback_master');
        $this->db->join('institute_master',    'collegefeedback_master.fkInsitute_id   = institute_master.Institu_id',      'left');
        $this->db->join('feedbackfor_master',  'collegefeedback_master.fkfeedbackforid = feedbackfor_master.feedbackid',    'left');
        $this->db->join('branch_master',       'collegefeedback_master.fkbranchid      = branch_master.branch_id',         'left');
        $this->db->join('finiyear_master',     'collegefeedback_master.academicyear    = finiyear_master.finiYear_id',     'left');
        $this->db->where('collegefeedback_master.url_token', $token);
        $this->db->where('collegefeedback_master.is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    // Validate URL (check active + not expired)
    public function validateURL($token)
    {
        $this->db->select('*');
        $this->db->from('collegefeedback_master');
        $this->db->where('url_token', $token);
        $this->db->where('is_active', 1);
        
        $this->db->group_start();
        $this->db->where('expires_at IS NULL');
        $this->db->or_where('expires_at >', date('Y-m-d H:i:s'));
        $this->db->group_end();
        
        $query = $this->db->get();
        return $query->row();
    }

    // Increment response count
    public function incrementResponseCount($url_id)
    {
        $this->db->set('total_responses', 'total_responses + 1', FALSE);
        $this->db->where('url_id', $url_id);
        return $this->db->update('collegefeedback_master');
    }

    // ==================== PRIVATE HELPERS ====================

    // Generate unique token
    private function generateUniqueToken()
    {
        do {
            $token = bin2hex(random_bytes(16)); // 32 character token
            $this->db->where('url_token', $token);
            $query = $this->db->get('collegefeedback_master');
        } while ($query->num_rows() > 0);
        
        return $token;
    }
}
?>