<?php
  class Companypub_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('college_publication',$model);
			//return $sql->result();
	} 


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');
 
    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getsemester()
     {
      $this->db->select('semester_master.*,');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }

    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getpublication()
     {
      $this->db->select('college_publishtype.*,');
      $this->db->from('college_publishtype');
       $query = $this->db->get();
        return $query->result();
     }




public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $SemIDs = [], $c_ids = [], $startdate = null, $enddate = null,)
{
    $this->db->select('
        college_publication.*, 
        branch_master.branch_name, 
semester_master.Sem_Name,
college_publishtype.college_publishName');

    $this->db->from('college_publication');
    $this->db->join('branch_master', 'branch_master.branch_id = college_publication.fk_branch', 'left');
$this->db->join('semester_master', 'semester_master.SemID = college_publication.fk_semester', 'left');
   $this->db->join('college_publishtype', 'college_publishtype.c_id = college_publication.fk_pubtype', 'left');


    $this->db->where('college_publication.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('college_publication.fk_branch', $branch_ids);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
   
    }
// new code end
 

if (!empty($SemIDs)) {
    $this->db->where_in('college_publication.fk_semester', $SemIDs);
}

    
    if (!empty($year_id)) {
    $this->db->where('college_publication.Financial_Year', $year_id);
}

 if (!empty($c_ids)) {
    $this->db->where_in('college_publication.fk_pubtype', $c_ids);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('college_publication.date >=', $startdate);
        $this->db->where('college_publication.date <=', $enddate);
    }

     
        $this->db->order_by('college_publication.date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}


// public function getAllYearsData()
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("college_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
//         ->group_by("college_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }

// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("college_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
//         ->where("college_publication.Financial_Year", $yearId)
//         ->group_by("college_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }

// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("fini_Label as year, college_publishtype.college_publishName")
//         ->from("college_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
//         ->join('college_publishtype', 'college_publishtype.c_id = college_publication.fk_pubtype', 'left')
//         ->where("college_publication.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }

// chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("college_publication")
        ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
        ->group_by("college_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("college_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
//         ->where("college_publication.Financial_Year", $yearId)
//         ->group_by("college_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("college_publication.col_id, college_publication.fk_pubtype, finiyear_master.fini_Label as year,
//      college_publishtype.college_publishName,")
//         ->from("college_publication")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
//  ->join('college_publishtype', 'college_publishtype.c_id = college_publication.fk_pubtype', 'left')    
//      ->where("college_publication.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }

public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("college_publication")
        ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
        ->where("college_publication.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('college_publication.fk_branch', (array)$branches);
    }
 else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('college_publication.fk_branch', explode(',', $branchIds));
    }
}
  
 
    $this->db->group_by("college_publication.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("college_publication.col_id, college_publication.fk_pubtype,college_publication.description, college_publication.document,
    college_publication.document2,college_publication.document3,college_publication.document4,college_publication.document5,
    college_publication.document6,college_publication.document7,college_publication.document8,college_publication.document9,
    college_publication.document10,
    college_publication.Name_of, finiyear_master.fini_Label as year,college_publishtype.college_publishName,branch_master.branch_name,")
        ->from("college_publication")
        ->join("finiyear_master", "finiyear_master.finiYear_id = college_publication.Financial_Year")
 ->join('college_publishtype', 'college_publishtype.c_id = college_publication.fk_pubtype', 'left')
->join('branch_master', 'branch_master.branch_id = college_publication.fk_branch', 'left')    
        ->where("college_publication.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('college_publication.fk_branch', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('college_publication.fk_branch', explode(',', $branchIds));
    }
}
 
    return $this->db->get()->result_array();
}
 

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(college_publication.col_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('college_publication', 'branch_master.branch_id = college_publication.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('college_publication.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
   
    }
// new code end
 
    if (!empty($year) && $year != 0) {
        $this->db->where('college_publication.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('college_publication.fk_pubtype,
                       college_publication.col_id,
                       college_publication.fk_branch,
                       college_publication.description,
                       college_publication.document,
                        college_publication.document2,college_publication.document3,college_publication.document4,college_publication.document5,
    college_publication.document6,college_publication.document7,college_publication.document8,college_publication.document9,
    college_publication.document10,
                       college_publication.Name_of,
                       branch_master.branch_name,
                        college_publishtype.college_publishName,');
    $this->db->from('college_publication');
    $this->db->join('branch_master', 'branch_master.branch_id = college_publication.fk_branch', 'left');
 $this->db->join('college_publishtype', 'college_publishtype.c_id = college_publication.fk_pubtype', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('college_publication.fk_branch', $branch_id);
} else {
    $this->db->where('college_publication.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('college_publication.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('college_publication.Financial_Year', $year);
    // }

      if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('college_publication.Financial_Year', $year);
    } else {
        $this->db->where('college_publication.Financial_Year', $year);
    }
}


    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("college_publication.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.col_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('college_publication sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.col_id) as count");
    $this->db->from("college_publication sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
 else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
 

}