<?php
class Complaint_model extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

public function getComplaintDetails($branch_id = null)
{
    $this->db->select('sc.*, d.dep_name, b.branch_name, c.Comp_name');
    $this->db->from('studcomp_master sc');
    $this->db->join('department_master d', 'd.dep_id = sc.fkdep_id', 'left');
    $this->db->join('branch_master b', 'b.branch_id = sc.fkbranch_id', 'left');
    $this->db->join('complaintcat_master c', 'c.Comp_id = sc.fkComp_id', 'left');

    if ($branch_id !== null) {
        $this->db->where('sc.fkbranch_id', $branch_id);
    }

    $this->db->order_by('sc.StudComp_id', 'DESC');
    return $this->db->get()->result();
}
  public function geRegtComplaintDetails()
{
    $this->db->select('sc.*, d.dep_name, b.branch_name, c.Comp_name');

    $this->db->from('studcomp_master sc');
    $this->db->join('department_master d', 'd.dep_id = sc.fkdep_id', 'left');
    $this->db->join('branch_master b', 'b.branch_id = sc.fkbranch_id', 'left');
    $this->db->join('complaintcat_master c', 'c.Comp_id = sc.fkComp_id', 'left');
        $this->db->where('sc.HOD_Approval', 1);
    $this->db->order_by('sc.StudComp_id', 'DESC');
    return $this->db->get()->result();
}
  public function getPrincComplaintDetails()
{
    $this->db->select('sc.*, d.dep_name, b.branch_name, c.Comp_name');

    $this->db->from('studcomp_master sc');
    $this->db->join('department_master d', 'd.dep_id = sc.fkdep_id', 'left');
    $this->db->join('branch_master b', 'b.branch_id = sc.fkbranch_id', 'left');
    $this->db->join('complaintcat_master c', 'c.Comp_id = sc.fkComp_id', 'left');
    $this->db->where('sc.HOD_Approval', 1);
    $this->db->where('sc.REG_Approval', 1);
    $this->db->order_by('sc.StudComp_id', 'DESC');
    return $this->db->get()->result();
}
    // Insert new complaint
  public function getById($id)
{
    return $this->db->get_where('studcomp_master', ['StudComp_id' => $id])->row();
}

public function updateComplaint($id, $data)
{
    $this->db->where('StudComp_id', $id);
    return $this->db->update('studcomp_master', $data);
}

public function getClass()
{
    return $this->db->get('classmaster')->result();
}

public function getBranches()
{
    return $this->db->get('branch_master')->result();
}

public function getCategories()
{
    return $this->db->get('complaintcat_master')->result();
}

   
}
