<?php
  class Consultancy_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('consultancy_master',$model);
			//return $sql->result();
	} 


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getsemester()
     {
      $this->db->select('semester_master.*,');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }

    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getpublication()
     {
      $this->db->select('college_publishtype.*,');
      $this->db->from('college_publishtype');
       $query = $this->db->get();
        return $query->result();
     }


public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $startdate = null, $enddate = null,)
{
    $this->db->select('
        consultancy_master.*, 
        branch_master.branch_name,
         finiyear_master.fini_Label, faculty_master.fac_Fullname,');

    $this->db->from('consultancy_master');
    $this->db->join('branch_master', 'branch_master.branch_id = consultancy_master.fk_branch', 'left');
 $this->db->join('faculty_master', 'consultancy_master.fk_fac = faculty_master.fac_id', 'left');
 $this->db->join('finiyear_master', 'consultancy_master.Financial_year = finiyear_master.finiYear_id', 'left');


    $this->db->where('consultancy_master.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('consultancy_master.fk_branch', $branch_ids);
    }
// new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

    
    if (!empty($year_id)) {
    $this->db->where('consultancy_master.Financial_year', $year_id);
}

 

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('consultancy_master.startdate >=', $startdate);
        $this->db->where('consultancy_master.enddate <=', $enddate);
    }

     
        // $this->db->order_by('consultancy_master.date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}


// public function getAllYearsData()
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("consultancy_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
//         ->group_by("consultancy_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }

// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("consultancy_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
//         ->where("consultancy_master.Financial_Year", $yearId)
//         ->group_by("consultancy_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }

// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("fini_Label as year, college_publishtype.college_publishName")
//         ->from("consultancy_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
//         ->join('college_publishtype', 'college_publishtype.c_id = consultancy_master.fk_pubtype', 'left')
//         ->where("consultancy_master.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }

// chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("consultancy_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
        ->group_by("consultancy_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("consultancy_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
//         ->where("consultancy_master.Financial_Year", $yearId)
//         ->group_by("consultancy_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("consultancy_master.col_id, consultancy_master.fk_pubtype, finiyear_master.fini_Label as year,
//      college_publishtype.college_publishName,")
//         ->from("consultancy_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
//  ->join('college_publishtype', 'college_publishtype.c_id = consultancy_master.fk_pubtype', 'left')    
//      ->where("consultancy_master.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }

public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("consultancy_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
        ->where("consultancy_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('consultancy_master.fk_branch', (array)$branches);
    }
  else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('consultancy_master.fk_branch', explode(',', $branchIds));
    }
}
 
    $this->db->group_by("consultancy_master.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("consultancy_master.conslt_id, consultancy_master.Industry_name,consultancy_master.project_name,
    consultancy_master.Financial_year,consultancy_master.startdate,consultancy_master.enddate,consultancy_master.Area,consultancy_master.Revenue,
    consultancy_master.fk_fac,
    consultancy_master.request_letter,consultancy_master.approve_letter,consultancy_master.invoice,consultancy_master.report,
     finiyear_master.fini_Label as year,branch_master.branch_name,faculty_master.fac_Fullname,")
        ->from("consultancy_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = consultancy_master.Financial_Year")
->join('branch_master', 'branch_master.branch_id = consultancy_master.fk_branch', 'left') 
->join('faculty_master', 'consultancy_master.fk_fac = faculty_master.fac_id', 'left')

        ->where("consultancy_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('consultancy_master.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('consultancy_master.fk_branch', explode(',', $branchIds));
    }
}
 
    return $this->db->get()->result_array();
}
 

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(consultancy_master.col_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('consultancy_master', 'branch_master.branch_id = consultancy_master.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('consultancy_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('consultancy_master.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('consultancy_master.conslt_id,
                       consultancy_master.Industry_name,
                       consultancy_master.project_name,
                       consultancy_master.request_letter,
                       consultancy_master.approve_letter,
                        consultancy_master.invoice,consultancy_master.report,
                        consultancy_master.fk_fac,
                        consultancy_master.Financial_year,consultancy_master.startdate,consultancy_master.enddate,consultancy_master.Area,consultancy_master.Revenue,
                       branch_master.branch_name,faculty_master.fac_Fullname, finiyear_master.fini_Label');
    $this->db->from('consultancy_master');
    $this->db->join('branch_master', 'branch_master.branch_id = consultancy_master.fk_branch', 'left');
 $this->db->join('faculty_master', 'consultancy_master.fk_fac = faculty_master.fac_id', 'left');
        $this->db->join('finiyear_master', 'consultancy_master.Financial_year = finiyear_master.finiYear_id', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('consultancy_master.fk_branch', $branch_id);
} else {
    $this->db->where('consultancy_master.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('consultancy_master.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('consultancy_master.Financial_Year', $year);
    // }

      if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('consultancy_master.Financial_Year', $year);
    } else {
        $this->db->where('consultancy_master.Financial_Year', $year);
    }
}


    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("consultancy_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.conslt_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('consultancy_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.conslt_id) as count");
    $this->db->from("consultancy_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
 

}